/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;

public class AssetPaymentInProcessPayment extends PersistableBusinessObjectBase {

    protected String documentNumber;
    protected Long capitalAssetNumber;
    protected Integer sequenceNumber;
    protected Integer selectedPaymentSequenceNumber;
    protected AssetPayment assetPayment;

    public AssetPaymentInProcessPayment() {
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getCapitalAssetNumber() {
        return capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public Integer getSequenceNumber() {
        return sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public Integer getSelectedPaymentSequenceNumber() {
        return selectedPaymentSequenceNumber;
    }

    public void setSelectedPaymentSequenceNumber(Integer selectedPaymentSequenceNumber) {
        this.selectedPaymentSequenceNumber = selectedPaymentSequenceNumber;
    }

    public AssetPayment getAssetPayment() {
        return assetPayment;
    }

    public void setAssetPayment(AssetPayment assetPayment) {
        this.assetPayment = assetPayment;
    }
}
