/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch;

import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.cam.batch.ResetAssetDepreciationForFiscalYearStep;
import org.kuali.kfs.module.cam.batch.service.AssetDepreciationService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class ResetAssetDepreciationForFiscalYearStepTest {
    private ResetAssetDepreciationForFiscalYearStep step;
    @Mock
    private AssetDepreciationService assetDepreciationService;

    ResetAssetDepreciationForFiscalYearStepTest() {
    }

    @BeforeEach
    public void setUp() {
        this.step = new ResetAssetDepreciationForFiscalYearStep();
        this.step.setAssetDepreciationService(this.assetDepreciationService);
    }

    @Test
    void execute_Success() throws InterruptedException {
        Mockito.when((Object)this.assetDepreciationService.resetPeriodValuesWhenFirstFiscalPeriod()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.step.execute("resetAssetDepreciationForFiscalYearJob", new Date()));
    }

    @Test
    void execute_Failure() {
        Mockito.when((Object)this.assetDepreciationService.resetPeriodValuesWhenFirstFiscalPeriod()).thenReturn((Object)false);
        try {
            Assertions.assertFalse((boolean)this.step.execute("resetAssetDepreciationForFiscalYearJob", new Date()));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assertions.fail((String)"Exception thrown");
        }
    }
}

