/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.fp.businessobject.CapitalAssetAccountsGroupDetails;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformation;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformationDetail;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.module.cam.document.service.GlLineService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

public class GlLineServiceIntegTest
extends KualiIntegTestBase {
    private GlLineService glLineService;
    private BusinessObjectService businessObjectService;
    private AssetGlobalService assetGlobalService;
    private GeneralLedgerEntry primary;
    private List<GeneralLedgerEntry> entries;

    @ConfigureContext(session=UserNameFixture.bomiddle, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.glLineService = (GlLineService)SpringContext.getBean(GlLineService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.assetGlobalService = (AssetGlobalService)SpringContext.getBean(AssetGlobalService.class);
        GeneralLedgerEntry entry = this.createCABGLEntry("1031400", 1, new KualiDecimal(5200.5));
        GeneralLedgerEntry entry2 = this.createCABGLEntry("1031400", 2, new KualiDecimal(3300.5));
        this.primary = entry;
        this.entries = new ArrayList<GeneralLedgerEntry>();
        this.entries.add(entry);
        this.entries.add(entry2);
    }

    private CapitalAssetInformationDetail createNewCapitalAssetInformationDetail() {
        CapitalAssetInformationDetail assetInformationDetail = new CapitalAssetInformationDetail();
        assetInformationDetail.setDocumentNumber("1001");
        assetInformationDetail.setCapitalAssetLineNumber(Integer.valueOf(1));
        assetInformationDetail.setItemLineNumber(Integer.valueOf(1));
        assetInformationDetail.setCampusCode("BL");
        assetInformationDetail.setBuildingCode("BL001");
        assetInformationDetail.setBuildingRoomNumber("001");
        assetInformationDetail.setBuildingSubRoomNumber("23");
        assetInformationDetail.setCapitalAssetTagNumber("TGX");
        assetInformationDetail.setCapitalAssetSerialNumber("SER");
        this.businessObjectService.save((PersistableBusinessObject)assetInformationDetail);
        return assetInformationDetail;
    }

    private CapitalAssetAccountsGroupDetails createNewCapitalAssetAccountsGroupDetails() {
        CapitalAssetAccountsGroupDetails capitalAssetAccountsGroupDetails = new CapitalAssetAccountsGroupDetails();
        capitalAssetAccountsGroupDetails.setDocumentNumber("1001");
        capitalAssetAccountsGroupDetails.setChartOfAccountsCode(this.primary.getChartOfAccountsCode());
        capitalAssetAccountsGroupDetails.setAccountNumber(this.primary.getAccountNumber());
        capitalAssetAccountsGroupDetails.setSubAccountNumber(this.primary.getSubAccountNumber());
        capitalAssetAccountsGroupDetails.setFinancialDocumentLineTypeCode("C".equals(this.primary.getTransactionDebitCreditCode()) ? "F" : "T");
        capitalAssetAccountsGroupDetails.setCapitalAssetAccountLineNumber(Integer.valueOf(1));
        capitalAssetAccountsGroupDetails.setCapitalAssetLineNumber(Integer.valueOf(1));
        capitalAssetAccountsGroupDetails.setFinancialObjectCode(this.primary.getFinancialObjectCode());
        capitalAssetAccountsGroupDetails.setFinancialSubObjectCode(this.primary.getFinancialSubObjectCode());
        capitalAssetAccountsGroupDetails.setProjectCode(this.primary.getProjectCode());
        capitalAssetAccountsGroupDetails.setOrganizationReferenceId(this.primary.getOrganizationReferenceId());
        capitalAssetAccountsGroupDetails.setSequenceNumber(Integer.valueOf(0));
        capitalAssetAccountsGroupDetails.setAmount(KualiDecimal.ZERO);
        return capitalAssetAccountsGroupDetails;
    }

    private CapitalAssetInformation createNewCapitalAssetInformation() {
        CapitalAssetInformation assetInformation = new CapitalAssetInformation();
        assetInformation.setDocumentNumber("1001");
        assetInformation.setCapitalAssetActionIndicator("C");
        assetInformation.setCapitalAssetLineAmount(new KualiDecimal(5200.5));
        assetInformation.setCapitalAssetLineNumber(Integer.valueOf(1));
        assetInformation.setVendorHeaderGeneratedIdentifier(Integer.valueOf(1000));
        assetInformation.setVendorDetailAssignedIdentifier(Integer.valueOf(0));
        assetInformation.setCapitalAssetTypeCode("07009");
        assetInformation.setCapitalAssetManufacturerName("MFR");
        assetInformation.setCapitalAssetDescription("DESC");
        assetInformation.setCapitalAssetManufacturerModelNumber("MDL");
        this.businessObjectService.save((PersistableBusinessObject)assetInformation);
        return assetInformation;
    }

    private GeneralLedgerEntry createCABGLEntry(String accountNumber, int seqNumber, KualiDecimal amount) throws ParseException {
        Entry glEntry = this.createGLEntry(accountNumber, seqNumber, amount);
        this.businessObjectService.save((PersistableBusinessObject)glEntry);
        return new GeneralLedgerEntry(glEntry);
    }

    private Entry createGLEntry(String accountNumber, int seqNumber, KualiDecimal amount) throws ParseException {
        Entry entry = new Entry();
        entry.setUniversityFiscalYear(Integer.valueOf(2009));
        entry.setChartOfAccountsCode("BL");
        entry.setAccountNumber(accountNumber);
        entry.setSubAccountNumber("---");
        entry.setFinancialObjectCode("7015");
        entry.setFinancialSubObjectCode("---");
        entry.setFinancialBalanceTypeCode("AC");
        entry.setFinancialObjectTypeCode("AS");
        entry.setUniversityFiscalPeriodCode("10");
        entry.setFinancialDocumentTypeCode("INV");
        entry.setFinancialSystemOriginationCode("01");
        entry.setDocumentNumber("1001");
        entry.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(seqNumber));
        entry.setTransactionLedgerEntryDescription("Test GL");
        entry.setTransactionLedgerEntryAmount(amount);
        entry.setOrganizationReferenceId(null);
        entry.setReferenceFinancialSystemOriginationCode(null);
        entry.setReferenceFinancialDocumentNumber(null);
        entry.setTransactionDebitCreditCode("D");
        entry.setOrganizationDocumentNumber(null);
        entry.setProjectCode(null);
        entry.setTransactionDate(new Date(DateUtils.parseDate((String)"04/23/2009", (String[])new String[]{"MM/dd/yyyy"}).getTime()));
        entry.setTransactionPostingDate(new Date(DateUtils.parseDate((String)"04/23/2009", (String[])new String[]{"MM/dd/yyyy"}).getTime()));
        entry.setTransactionDateTimeStamp(new Timestamp(DateUtils.parseDate((String)"04/23/2009 10:59:59", (String[])new String[]{"MM/dd/yyyy HH:mm:ss"}).getTime()));
        return entry;
    }

    public void testCreateAssetGlobalDocument_noFPData() throws Exception {
        MaintenanceDocument assetGlobalDocument = (MaintenanceDocument)this.glLineService.createAssetGlobalDocument(this.primary, Integer.valueOf(1));
        GlLineServiceIntegTest.assertNotNull((Object)assetGlobalDocument);
        AssetGlobal assetGlobal = (AssetGlobal)assetGlobalDocument.getNewMaintainableObject().getBusinessObject();
        GlLineServiceIntegTest.assertEquals((String)"BL", (String)assetGlobal.getOrganizationOwnerChartOfAccountsCode());
        GlLineServiceIntegTest.assertEquals((String)"1031400", (String)assetGlobal.getOrganizationOwnerAccountNumber());
        GlLineServiceIntegTest.assertEquals((String)this.assetGlobalService.getNewAcquisitionTypeCode(), (String)assetGlobal.getAcquisitionTypeCode());
        GlLineServiceIntegTest.assertNull((Object)assetGlobal.getInventoryStatusCode());
        GlLineServiceIntegTest.assertNull((Object)assetGlobal.getCapitalAssetTypeCode());
        GlLineServiceIntegTest.assertNull((Object)assetGlobal.getManufacturerName());
        GlLineServiceIntegTest.assertNull((Object)assetGlobal.getManufacturerModelNumber());
        GlLineServiceIntegTest.assertNull((Object)assetGlobal.getVendorName());
        GlLineServiceIntegTest.assertNull((Object)assetGlobal.getCapitalAssetDescription());
        List assetGlobalDetails = assetGlobal.getAssetSharedDetails();
        GlLineServiceIntegTest.assertTrue((boolean)assetGlobalDetails.isEmpty());
        List assetPaymentDetails = assetGlobal.getAssetPaymentDetails();
        GlLineServiceIntegTest.assertEquals((int)0, (int)assetPaymentDetails.size());
    }

    public void testCreateAssetGlobalDocument_FPData() throws Exception {
        CapitalAssetInformation assetInformation = this.createNewCapitalAssetInformation();
        assetInformation.getCapitalAssetInformationDetails().add(this.createNewCapitalAssetInformationDetail());
        assetInformation.getCapitalAssetAccountsGroupDetails().add(this.createNewCapitalAssetAccountsGroupDetails());
        this.businessObjectService.save((PersistableBusinessObject)assetInformation);
        assetInformation.refreshNonUpdateableReferences();
        MaintenanceDocument assetGlobalDocument = (MaintenanceDocument)this.glLineService.createAssetGlobalDocument(this.primary, Integer.valueOf(1));
        GlLineServiceIntegTest.assertNotNull((Object)assetGlobalDocument);
        AssetGlobal assetGlobal = (AssetGlobal)assetGlobalDocument.getNewMaintainableObject().getBusinessObject();
        GlLineServiceIntegTest.assertEquals((String)"BL", (String)assetGlobal.getOrganizationOwnerChartOfAccountsCode());
        GlLineServiceIntegTest.assertEquals((String)"1031400", (String)assetGlobal.getOrganizationOwnerAccountNumber());
        GlLineServiceIntegTest.assertEquals((String)this.assetGlobalService.getNewAcquisitionTypeCode(), (String)assetGlobal.getAcquisitionTypeCode());
        GlLineServiceIntegTest.assertEquals((String)"A", (String)assetGlobal.getInventoryStatusCode());
        GlLineServiceIntegTest.assertEquals((String)"07009", (String)assetGlobal.getCapitalAssetTypeCode());
        GlLineServiceIntegTest.assertEquals((String)"MFR", (String)assetGlobal.getManufacturerName());
        GlLineServiceIntegTest.assertEquals((String)"MDL", (String)assetGlobal.getManufacturerModelNumber());
        GlLineServiceIntegTest.assertEquals((String)"DESC", (String)assetGlobal.getCapitalAssetDescription());
        GlLineServiceIntegTest.assertEquals((String)"ABC CLEANING SERVICES", (String)assetGlobal.getVendorName());
        List assetGlobalDetails = assetGlobal.getAssetSharedDetails();
        GlLineServiceIntegTest.assertEquals((int)1, (int)assetGlobalDetails.size());
        AssetGlobalDetail assetGlobalDetail = (AssetGlobalDetail)assetGlobalDetails.get(0);
        GlLineServiceIntegTest.assertEquals((String)"BL", (String)assetGlobalDetail.getCampusCode());
        GlLineServiceIntegTest.assertEquals((String)"BL001", (String)assetGlobalDetail.getBuildingCode());
        GlLineServiceIntegTest.assertEquals((String)"001", (String)assetGlobalDetail.getBuildingRoomNumber());
        GlLineServiceIntegTest.assertEquals((String)"23", (String)assetGlobalDetail.getBuildingSubRoomNumber());
        GlLineServiceIntegTest.assertEquals((String)"TGX", (String)assetGlobalDetail.getCampusTagNumber());
        GlLineServiceIntegTest.assertEquals((String)"SER", (String)assetGlobalDetail.getSerialNumber());
        List assetPaymentDetails = assetGlobal.getAssetPaymentDetails();
        GlLineServiceIntegTest.assertEquals((int)1, (int)assetPaymentDetails.size());
        this.assertAssetPaymentDetail((Document)assetGlobalDocument, (AssetPaymentDetail)assetPaymentDetails.get(0), "1031400", new KualiDecimal(5200.5), 1);
    }

    private void assertAssetPaymentDetail(Document document, AssetPaymentDetail detail, String accountNumber, KualiDecimal amount, Integer seqNo) {
        GlLineServiceIntegTest.assertEquals((String)document.getDocumentNumber(), (String)detail.getDocumentNumber());
        GlLineServiceIntegTest.assertEquals((Object)seqNo, (Object)detail.getSequenceNumber());
        GlLineServiceIntegTest.assertEquals((Object)2009, (Object)detail.getPostingYear());
        GlLineServiceIntegTest.assertEquals((String)"10", (String)detail.getPostingPeriodCode());
        GlLineServiceIntegTest.assertEquals((String)"BL", (String)detail.getChartOfAccountsCode());
        GlLineServiceIntegTest.assertEquals((String)accountNumber, (String)detail.getAccountNumber());
        GlLineServiceIntegTest.assertEquals((String)"", (String)detail.getSubAccountNumber());
        GlLineServiceIntegTest.assertEquals((String)"7015", (String)detail.getFinancialObjectCode());
        GlLineServiceIntegTest.assertEquals((String)"", (String)detail.getProjectCode());
        GlLineServiceIntegTest.assertEquals((String)"", (String)detail.getOrganizationReferenceId());
        GlLineServiceIntegTest.assertEquals((String)"01", (String)detail.getExpenditureFinancialSystemOriginationCode());
        GlLineServiceIntegTest.assertEquals((String)"1001", (String)detail.getExpenditureFinancialDocumentNumber());
        GlLineServiceIntegTest.assertEquals((String)"INV", (String)detail.getExpenditureFinancialDocumentTypeCode());
        GlLineServiceIntegTest.assertEquals((String)"04/23/2009", (String)new SimpleDateFormat("MM/dd/yyyy", Locale.US).format(detail.getExpenditureFinancialDocumentPostedDate()));
        GlLineServiceIntegTest.assertEquals((String)"", (String)detail.getPurchaseOrderNumber());
        GlLineServiceIntegTest.assertFalse((boolean)detail.isTransferPaymentIndicator());
    }

    public void testCreateAssetPaymentDocument_noFPData() throws Exception {
        AssetPaymentDocument document = (AssetPaymentDocument)this.glLineService.createAssetPaymentDocument(this.primary, Integer.valueOf(1));
        GlLineServiceIntegTest.assertNotNull((Object)document);
        List assetPaymentDetails = document.getSourceAccountingLines();
        GlLineServiceIntegTest.assertEquals((int)0, (int)assetPaymentDetails.size());
    }

    public void testCreateAssetPaymentDocument_FPData() throws Exception {
        CapitalAssetInformation assetInformation = new CapitalAssetInformation();
        assetInformation.getCapitalAssetAccountsGroupDetails().add(this.createNewCapitalAssetAccountsGroupDetails());
        assetInformation.setDocumentNumber("1001");
        assetInformation.setCapitalAssetNumber(Long.valueOf(1594L));
        assetInformation.setCapitalAssetLineAmount(new KualiDecimal(5200.5));
        assetInformation.setCapitalAssetLineNumber(Integer.valueOf(1));
        assetInformation.setCapitalAssetActionIndicator("C");
        this.businessObjectService.save((PersistableBusinessObject)assetInformation);
        AssetPaymentDocument document = (AssetPaymentDocument)this.glLineService.createAssetPaymentDocument(this.primary, Integer.valueOf(1));
        GlLineServiceIntegTest.assertNotNull((Object)document);
        List assetPaymentDetails = document.getSourceAccountingLines();
        GlLineServiceIntegTest.assertEquals((int)1, (int)assetPaymentDetails.size());
        this.assertAssetPaymentDetail((Document)document, (AssetPaymentDetail)assetPaymentDetails.get(0), "1031400", new KualiDecimal(5200.5), 1);
    }
}

