/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.lookup.AssetLookupableHelperServiceImpl;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentAuthorizerBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AssetLookupableHelperServiceImplTest {
    private static final String AUTHORIZED_PRINCIPAL_ID = "khuntley";
    private static final String UNAUTHORIZED_PRINCIPAL_ID = "rorenfro";
    private static final String CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE = "C2";
    @Spy
    private AssetLookupableHelperServiceImpl cutSpy;
    @Mock
    private AssetService assetSvcMock;
    @Mock
    private ConfigurationService configurationSvcMock;
    @Mock
    private DocumentDictionaryService documentDictionarySvcMock;
    @Mock
    private FinancialSystemTransactionalDocumentAuthorizerBase documentAuthorizerMock;
    @Mock
    private ParameterService parameterSvcMock;
    @Mock
    private PermissionService permissionSvcMock;
    private static final Asset moveableAsset = new Asset();
    private static final Asset nonMoveableAssetAuthorized;
    private static final Asset nonMoveableAssetNonAuthorized;
    private static final Asset unableToDetermineMoveableAsset;
    private static final Asset nonCapitalAssetNoPayments;
    private static final Asset nonCapitalAssetSubTypeShowLink;
    private static final Asset nonCapitalAssetSubTypeHideLink;

    AssetLookupableHelperServiceImplTest() {
    }

    @BeforeEach
    public void setUp() {
        ObjectCode objectCodeNonCapitalEquipmentObjectSubType = new ObjectCode();
        objectCodeNonCapitalEquipmentObjectSubType.setChartOfAccountsCode("BL");
        objectCodeNonCapitalEquipmentObjectSubType.setFinancialObjectCode("5200");
        FinancialSystemTransactionalDocumentAuthorizerBase.setPermissionService((PermissionService)this.permissionSvcMock);
        this.cutSpy.setAssetService(this.assetSvcMock);
        this.cutSpy.setDocumentDictionaryService(this.documentDictionarySvcMock);
        this.cutSpy.setParameterService(this.parameterSvcMock);
        this.cutSpy.setConfigurationService(this.configurationSvcMock);
    }

    @Test
    public void getTransferUrlUnableToDetermineMoveableAssetNonAuthorized() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "ASSET_STATUSES_EXCLUDED")).thenReturn(new ArrayList<String>(Arrays.asList("N;O".split(";"))));
        Mockito.when((Object)this.documentDictionarySvcMock.getDocumentAuthorizer("AT")).thenReturn((Object)this.documentAuthorizerMock);
        ((AssetLookupableHelperServiceImpl)Mockito.doReturn((Object)UNAUTHORIZED_PRINCIPAL_ID).when((Object)this.cutSpy)).determinePrincipalIdForCurrentUser();
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(unableToDetermineMoveableAsset);
        this.validateEmptyAnchorHtmlData(anchorHtmlData);
    }

    @Test
    public void getTransferUrlUnableToDetermineMoveableAssetAuthorized() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "ASSET_STATUSES_EXCLUDED")).thenReturn(new ArrayList<String>(Arrays.asList("N;O".split(";"))));
        Mockito.when((Object)this.documentDictionarySvcMock.getDocumentAuthorizer("AT")).thenReturn((Object)this.documentAuthorizerMock);
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("application.url")).thenReturn((Object)"baseUrl");
        ((AssetLookupableHelperServiceImpl)Mockito.doReturn((Object)AUTHORIZED_PRINCIPAL_ID).when((Object)this.cutSpy)).determinePrincipalIdForCurrentUser();
        Mockito.when((Object)this.documentAuthorizerMock.isAuthorized((BusinessObject)unableToDetermineMoveableAsset, "KFS-CAM", "Separate", AUTHORIZED_PRINCIPAL_ID)).thenReturn((Object)true);
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(unableToDetermineMoveableAsset);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, unableToDetermineMoveableAsset.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlMoveableAsset() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "ASSET_STATUSES_EXCLUDED")).thenReturn(new ArrayList<String>(Arrays.asList("N;O".split(";"))));
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("application.url")).thenReturn((Object)"baseUrl");
        Mockito.when((Object)this.assetSvcMock.isAssetMovableCheckByPayment(moveableAsset)).thenReturn((Object)true);
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(moveableAsset);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, moveableAsset.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlNonMoveableAssetAuthorized() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "ASSET_STATUSES_EXCLUDED")).thenReturn(new ArrayList<String>(Arrays.asList("N;O".split(";"))));
        Mockito.when((Object)this.documentDictionarySvcMock.getDocumentAuthorizer("AT")).thenReturn((Object)this.documentAuthorizerMock);
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("application.url")).thenReturn((Object)"baseUrl");
        ((AssetLookupableHelperServiceImpl)Mockito.doReturn((Object)AUTHORIZED_PRINCIPAL_ID).when((Object)this.cutSpy)).determinePrincipalIdForCurrentUser();
        Mockito.when((Object)this.documentAuthorizerMock.isAuthorized((BusinessObject)nonMoveableAssetAuthorized, "KFS-CAM", "Separate", AUTHORIZED_PRINCIPAL_ID)).thenReturn((Object)true);
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(nonMoveableAssetAuthorized);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, nonMoveableAssetAuthorized.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlNonMoveableAssetNonAuthorized() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "ASSET_STATUSES_EXCLUDED")).thenReturn(new ArrayList<String>(Arrays.asList("N;O".split(";"))));
        Mockito.when((Object)this.documentDictionarySvcMock.getDocumentAuthorizer("AT")).thenReturn((Object)this.documentAuthorizerMock);
        ((AssetLookupableHelperServiceImpl)Mockito.doReturn((Object)UNAUTHORIZED_PRINCIPAL_ID).when((Object)this.cutSpy)).determinePrincipalIdForCurrentUser();
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(nonMoveableAssetNonAuthorized);
        this.validateEmptyAnchorHtmlData(anchorHtmlData);
    }

    @Test
    public void getTransferUrlNonCapitalAssetNoPayments() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "ASSET_STATUSES_EXCLUDED")).thenReturn(new ArrayList<String>(Arrays.asList("N;O".split(";"))));
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("application.url")).thenReturn((Object)"baseUrl");
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(nonCapitalAssetNoPayments);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, nonCapitalAssetNoPayments.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlNonCapitalAssetSubTypeShouldHideLink() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "ASSET_STATUSES_EXCLUDED")).thenReturn(new ArrayList<String>(Arrays.asList("N;O".split(";"))));
        Mockito.when((Object)this.assetSvcMock.determineFinancialObjectSubTypeCode(nonCapitalAssetSubTypeHideLink)).thenReturn((Object)CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE);
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(nonCapitalAssetSubTypeHideLink);
        this.validateEmptyAnchorHtmlData(anchorHtmlData);
    }

    @Test
    public void getTransferUrlNonCapitalAssetSubTypeShouldShowLink() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "ASSET_STATUSES_EXCLUDED")).thenReturn(new ArrayList<String>(Arrays.asList("N;O".split(";"))));
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("application.url")).thenReturn((Object)"baseUrl");
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(nonCapitalAssetSubTypeShowLink);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, nonCapitalAssetSubTypeShowLink.getCapitalAssetNumber().toString());
    }

    private void validateEmptyAnchorHtmlData(HtmlData.AnchorHtmlData anchorHtmlData) {
        Assertions.assertEquals((Object)"", (Object)anchorHtmlData.getHref());
        Assertions.assertEquals((Object)"", (Object)anchorHtmlData.getMethodToCall());
        Assertions.assertEquals((Object)"", (Object)anchorHtmlData.getDisplayText());
    }

    private void validatePopulatedAnchorHtmlData(HtmlData.AnchorHtmlData anchorHtmlData, String capitalAssetNumber) {
        Assertions.assertEquals((Object)this.generateExpectedUrl(capitalAssetNumber), (Object)anchorHtmlData.getHref());
        Assertions.assertEquals((Object)"docHandler", (Object)anchorHtmlData.getMethodToCall());
        Assertions.assertEquals((Object)"transfer", (Object)anchorHtmlData.getDisplayText());
    }

    private String generateExpectedUrl(String capitalAssetNumber) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "docHandler");
        parameters.put("capitalAssetNumber", capitalAssetNumber);
        parameters.put("command", "initiate");
        parameters.put("docTypeName", "AT");
        return UrlFactory.parameterizeUrl((String)"baseUrl/camsAssetTransfer.do", parameters);
    }

    static {
        moveableAsset.setCapitalAssetNumber(Long.valueOf(0L));
        moveableAsset.setInventoryStatusCode("A");
        nonMoveableAssetAuthorized = new Asset();
        nonMoveableAssetAuthorized.setCapitalAssetNumber(Long.valueOf(1L));
        nonMoveableAssetAuthorized.setInventoryStatusCode("A");
        nonMoveableAssetNonAuthorized = new Asset();
        nonMoveableAssetNonAuthorized.setCapitalAssetNumber(Long.valueOf(2L));
        nonMoveableAssetNonAuthorized.setInventoryStatusCode("A");
        unableToDetermineMoveableAsset = new Asset();
        unableToDetermineMoveableAsset.setCapitalAssetNumber(Long.valueOf(3L));
        unableToDetermineMoveableAsset.setInventoryStatusCode("A");
        nonCapitalAssetNoPayments = new Asset();
        nonCapitalAssetNoPayments.setCapitalAssetNumber(Long.valueOf(4L));
        nonCapitalAssetNoPayments.setInventoryStatusCode("N");
        nonCapitalAssetSubTypeShowLink = new Asset();
        nonCapitalAssetSubTypeShowLink.setCapitalAssetNumber(Long.valueOf(5L));
        ArrayList assetPayments = new ArrayList();
        nonCapitalAssetSubTypeShowLink.setAssetPayments(assetPayments);
        nonCapitalAssetSubTypeShowLink.setInventoryStatusCode("N");
        nonCapitalAssetSubTypeHideLink = new Asset();
        nonCapitalAssetSubTypeHideLink.setCapitalAssetNumber(Long.valueOf(6L));
        assetPayments.clear();
        nonCapitalAssetSubTypeHideLink.setAssetPayments(assetPayments);
        nonCapitalAssetSubTypeHideLink.setInventoryStatusCode("N");
    }
}

