/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.test.util.ReflectionTestUtils;

@ExtendWith(value={MockitoExtension.class})
class AssetPaymentDocumentTest {
    public static final String ORG_PLANT_ACCOUNT_NUMBER = "797979";
    public static final String CAMPS_PLANT_ACCOUNT_NUMBER = "494949";
    public static final String COA_CD = "BL";
    public static final String OBJECT_SUB_TYPE_1 = "CM";
    public static final String OBJECT_SUB_TYPE_2 = "BD";
    private static final List<String> DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPES = List.of("C1", "C2", "CF", "CM", "ES", "NA", "UC", "UF");
    private static final List<String> DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPES = List.of("BD", "BF", "BI", "BR", "BX", "IF", "LE", "LF", "LI", "LR", "IA", "IC", "IO");
    @Mock
    AssetPayment assetPayment;
    AssetPaymentDocument assetPaymentDocument;
    GeneralLedgerPendingEntry entry;

    AssetPaymentDocumentTest() {
    }

    @BeforeEach
    public void setUp() {
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            this.assetPaymentDocument = new AssetPaymentDocument();
        }
        ReflectionTestUtils.setField((Object)this.assetPaymentDocument, (String)"apipAssetPaymentHelper", (Object)this.assetPayment);
        this.entry = new GeneralLedgerPendingEntry();
    }

    @Test
    void determinePlantFund1(@Mock(stubOnly=true) ParameterService parameterServiceMock, @Mock(stubOnly=true) Asset assetMock, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Organization organizationMock) {
        Mockito.when((Object)organizationMock.getOrganizationPlantAccountNumber()).thenReturn((Object)ORG_PLANT_ACCOUNT_NUMBER);
        Mockito.when((Object)organizationMock.getOrganizationPlantChartCode()).thenReturn((Object)COA_CD);
        Mockito.when((Object)accountMock.getOrganization()).thenReturn((Object)organizationMock);
        Mockito.when((Object)this.assetPayment.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)this.assetPayment.getAsset()).thenReturn((Object)assetMock);
        Mockito.when((Object)this.assetPayment.getAsset()).thenReturn((Object)assetMock);
        Mockito.when((Object)parameterServiceMock.parameterExists(AssetDepreciationStep.class, "ORGANIZATION_PLANT_FUND_SUB_TYPES")).thenReturn((Object)true);
        Mockito.when((Object)parameterServiceMock.parameterExists(AssetDepreciationStep.class, "CAMPUS_PLANT_FUND_SUB_TYPES")).thenReturn((Object)true);
        Mockito.when((Object)parameterServiceMock.getParameterValuesAsString(AssetDepreciationStep.class, "ORGANIZATION_PLANT_FUND_SUB_TYPES")).thenReturn(DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPES);
        Mockito.when((Object)parameterServiceMock.getParameterValuesAsString(AssetDepreciationStep.class, "CAMPUS_PLANT_FUND_SUB_TYPES")).thenReturn(DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPES);
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)parameterServiceMock);
            this.assetPaymentDocument.determinePlantFund(OBJECT_SUB_TYPE_1, this.entry);
        }
        Assertions.assertEquals((Object)ORG_PLANT_ACCOUNT_NUMBER, (Object)this.entry.getAccountNumber(), (String)"The accountMock number should be 797979 depending on the sub type CM.");
    }

    @Test
    void determinePlantFund2(@Mock(stubOnly=true) ParameterService parameterServiceMock, @Mock(stubOnly=true) Asset assetMock, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Organization organizationMock) {
        Mockito.when((Object)organizationMock.getCampusPlantAccountNumber()).thenReturn((Object)CAMPS_PLANT_ACCOUNT_NUMBER);
        Mockito.when((Object)organizationMock.getCampusPlantChartCode()).thenReturn((Object)COA_CD);
        Mockito.when((Object)accountMock.getOrganization()).thenReturn((Object)organizationMock);
        Mockito.when((Object)this.assetPayment.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)this.assetPayment.getAsset()).thenReturn((Object)assetMock);
        Mockito.when((Object)this.assetPayment.getAsset()).thenReturn((Object)assetMock);
        Mockito.when((Object)parameterServiceMock.parameterExists(AssetDepreciationStep.class, "ORGANIZATION_PLANT_FUND_SUB_TYPES")).thenReturn((Object)true);
        Mockito.when((Object)parameterServiceMock.parameterExists(AssetDepreciationStep.class, "CAMPUS_PLANT_FUND_SUB_TYPES")).thenReturn((Object)true);
        Mockito.when((Object)parameterServiceMock.getParameterValuesAsString(AssetDepreciationStep.class, "ORGANIZATION_PLANT_FUND_SUB_TYPES")).thenReturn(DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPES);
        Mockito.when((Object)parameterServiceMock.getParameterValuesAsString(AssetDepreciationStep.class, "CAMPUS_PLANT_FUND_SUB_TYPES")).thenReturn(DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPES);
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)parameterServiceMock);
            this.assetPaymentDocument.determinePlantFund(OBJECT_SUB_TYPE_2, this.entry);
        }
        Assertions.assertEquals((Object)CAMPS_PLANT_ACCOUNT_NUMBER, (Object)this.entry.getAccountNumber(), (String)"The accountMock number should be 494949 depending on the sub type BD.");
    }
}

