/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.List;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.document.gl.AssetRetirementGeneralLedgerPendingEntrySource;
import org.kuali.kfs.module.cam.document.gl.CamsGeneralLedgerPendingEntrySourceBase;
import org.kuali.kfs.module.cam.document.service.AssetRetirementService;
import org.kuali.kfs.module.cam.fixture.AssetRetirementGlobalMaintainableFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;

public class AssetRetirementServiceIntegTest
extends KualiIntegTestBase {
    private AssetRetirementService assetRetirementService;
    private UniversityDateService universityDateService;

    @ConfigureContext(session=UserNameFixture.bomiddle, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.assetRetirementService = (AssetRetirementService)SpringContext.getBean(AssetRetirementService.class);
        this.universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
    }

    @ConfigureContext(session=UserNameFixture.bomiddle, shouldCommitTransactions=false)
    public void testCreateGLPostables_Success() throws Exception {
        MaintenanceDocument document = (MaintenanceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument("ARG");
        AssetRetirementGlobal assetRetirementGlobal = AssetRetirementGlobalMaintainableFixture.RETIREMENT1.newAssetRetirement();
        AssetRetirementGeneralLedgerPendingEntrySource assetRetirementGlPoster = new AssetRetirementGeneralLedgerPendingEntrySource(document.getDocumentHeader());
        this.assetRetirementService.createGLPostables(assetRetirementGlobal, (CamsGeneralLedgerPendingEntrySourceBase)assetRetirementGlPoster);
        List postables = assetRetirementGlPoster.getPostables();
        AssetRetirementServiceIntegTest.assertFalse((boolean)postables.isEmpty());
        AssetRetirementServiceIntegTest.assertEquals((int)10, (int)postables.size());
        int i = 0;
        for (AssetRetirementGlobalDetail detail : assetRetirementGlobal.getAssetRetirementGlobalDetails()) {
            Asset asset = detail.getAsset();
            AssetPayment payment1 = (AssetPayment)asset.getAssetPayments().get(0);
            this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)postables.get(i++), asset.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccountChargeAmount(), "9520004", "Asset retirement cost reversal entry", "8610");
            this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)postables.get(i++), asset.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccumulatedPrimaryDepreciationAmount(), "9520004", "Asset retirement depreciation reversal", "8910");
            this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)postables.get(i++), asset.getOrganizationOwnerChartOfAccountsCode(), (KualiDecimal)payment1.getAccountChargeAmount().subtract((AbstractKualiDecimal)payment1.getAccumulatedPrimaryDepreciationAmount()), "9520004", "Asset retirement fund balance adjustment", "4998");
            AssetPayment payment2 = (AssetPayment)asset.getAssetPayments().get(1);
            this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)postables.get(i++), asset.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccountChargeAmount(), "9520004", "Asset retirement cost reversal entry", "8610");
            this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)postables.get(i++), asset.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccumulatedPrimaryDepreciationAmount(), "9520004", "Asset retirement depreciation reversal", "8910");
        }
    }

    private void assertGLPostable(GeneralLedgerPendingEntrySourceDetail glPostable, String chartOfAccountsCode, KualiDecimal amount, String plantAccount, String financialLineDesc, String financialObjectCode) {
        AssetRetirementServiceIntegTest.assertEquals((String)plantAccount, (String)glPostable.getAccountNumber());
        AssetRetirementServiceIntegTest.assertEquals((Object)amount, (Object)glPostable.getAmount());
        AssetRetirementServiceIntegTest.assertEquals((String)"AC", (String)glPostable.getBalanceTypeCode());
        AssetRetirementServiceIntegTest.assertEquals((String)chartOfAccountsCode, (String)glPostable.getChartOfAccountsCode());
        AssetRetirementServiceIntegTest.assertEquals((String)financialLineDesc, (String)glPostable.getFinancialDocumentLineDescription());
        AssetRetirementServiceIntegTest.assertEquals((String)financialObjectCode, (String)glPostable.getFinancialObjectCode());
        AssetRetirementServiceIntegTest.assertEquals((Object)this.universityDateService.getCurrentFiscalYear(), (Object)glPostable.getPostingYear());
        AssetRetirementServiceIntegTest.assertNull((Object)glPostable.getOrganizationReferenceId());
        AssetRetirementServiceIntegTest.assertNull((Object)glPostable.getProjectCode());
        AssetRetirementServiceIntegTest.assertNull((Object)glPostable.getReferenceNumber());
        AssetRetirementServiceIntegTest.assertNull((Object)glPostable.getReferenceOriginCode());
        AssetRetirementServiceIntegTest.assertNull((Object)glPostable.getReferenceTypeCode());
    }
}

