/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.time.Month;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.service.impl.AssetServiceImpl;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.kuali.kfs.sys.fixture.ObjectCodeFixture;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.util.ReflectionUtils;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class AssetServiceTest {
    private AssetServiceImpl cut;
    @Mock
    private ObjectCodeService objectCodeService;
    @Mock
    private ParameterService parameterService;
    private static final List<String> OBJECT_SUB_TYPE_GROUPS = List.of("BD,BF", "CM,CF,CO", "UC,UF,UO", "LI,LF");
    private static final List<String> MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES = List.of("CM", "CF", "C1", "C2", "UC", "UF", "CO", "UO", "ES");
    private static final List<String> NON_MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES = List.of("AM", "BD", "BF", "BI", "CP", "IF", "LA", "LE", "LI", "LF", "LR", "BR", "BY", "BX");

    AssetServiceTest() {
    }

    @BeforeEach
    public void setUp() {
        IntegTestUtils.setFiscalYearForTesting((Integer)AssetServiceTest.getFiscalYearForTesting());
        this.cut = new AssetServiceImpl();
        this.cut.setParameterService(this.parameterService);
        this.cut.setObjectCodeService(this.objectCodeService);
    }

    @AfterEach
    public void tearDown() {
        IntegTestUtils.setFiscalYearForTesting(null);
    }

    private static int getFiscalYearForTesting() {
        int year = YearMonth.now().getYear();
        int month = YearMonth.now().getMonthValue();
        if (month >= Month.JULY.getValue()) {
            ++year;
        }
        return year;
    }

    @Test
    void testIsObjectSubTypeCompatible_Success() {
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "OBJECT_SUB_TYPE_GROUPS")).thenReturn(OBJECT_SUB_TYPE_GROUPS);
        ArrayList<String> ls = new ArrayList<String>();
        ls.add("UC");
        ls.add("UF");
        ls.add("UO");
        Assertions.assertTrue((boolean)this.cut.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("LI");
        ls.add("LI");
        Assertions.assertTrue((boolean)this.cut.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("LI");
        Assertions.assertTrue((boolean)this.cut.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("IF");
        Assertions.assertTrue((boolean)this.cut.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("IF");
        ls.add("IF");
        Assertions.assertTrue((boolean)this.cut.isObjectSubTypeCompatible(ls));
    }

    @Test
    void testIsObjectSubTypeCompatible_Failure() {
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "OBJECT_SUB_TYPE_GROUPS")).thenReturn(OBJECT_SUB_TYPE_GROUPS);
        ArrayList<String> ls = new ArrayList<String>();
        ls.add("BD");
        ls.add("UF");
        ls.add("UO");
        Assertions.assertFalse((boolean)this.cut.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("UF");
        ls.add("LI");
        Assertions.assertFalse((boolean)this.cut.isObjectSubTypeCompatible(ls));
    }

    @Test
    void isAssetMovableCheckByPaymentNoPayments() {
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES);
        Asset asset = new Asset();
        asset.setFinancialObjectSubTypeCode("C2");
        Assertions.assertTrue((boolean)this.cut.isAssetMovableCheckByPayment(asset));
    }

    @Test
    void isAssetMovableCheckByPaymentOnePayment(@Mock(stubOnly=true) AssetPayment assetPaymentMock) {
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES);
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "NON_MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(NON_MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES);
        Mockito.when((Object)this.objectCodeService.getByPrimaryIdForCurrentYear("BL", "7100")).thenReturn((Object)ObjectCodeFixture.OBJECT_CODE_LIB_ACQUIS.createObjectCode());
        Asset asset = new Asset();
        asset.setFinancialObjectSubTypeCode("C2");
        ((AssetPayment)Mockito.doNothing().when((Object)assetPaymentMock)).refreshReferenceObject("financialObject");
        Mockito.when((Object)assetPaymentMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)assetPaymentMock.getFinancialObjectCode()).thenReturn((Object)"7100");
        asset.setAssetPayments(List.of(assetPaymentMock));
        Assertions.assertFalse((boolean)this.cut.isAssetMovableCheckByPayment(asset));
    }

    @Test
    void isAssetMovableCheckByPaymentTwoPayment(@Mock(stubOnly=true) AssetPayment assetPaymentMock1, @Mock(stubOnly=true) AssetPayment assetPaymentMock2) {
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES);
        Mockito.when((Object)this.objectCodeService.getByPrimaryIdForCurrentYear("BL", "7022")).thenReturn((Object)ObjectCodeFixture.OBJECT_CODE_CAP_LEASE.createObjectCode());
        Asset asset = new Asset();
        asset.setFinancialObjectSubTypeCode("LI");
        ((AssetPayment)Mockito.doNothing().when((Object)assetPaymentMock2)).refreshReferenceObject("financialObject");
        Mockito.when((Object)assetPaymentMock2.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)assetPaymentMock2.getFinancialObjectCode()).thenReturn((Object)"7022");
        asset.setAssetPayments(List.of(assetPaymentMock1, assetPaymentMock2));
        Assertions.assertTrue((boolean)this.cut.isAssetMovableCheckByPayment(asset));
    }

    @Test
    void isAssetMovableCheckByPaymentOutOfDatePayment(@Mock(stubOnly=true) AssetPayment assetPaymentMock) {
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES);
        Asset asset = new Asset();
        asset.setFinancialObjectSubTypeCode("C2");
        ((AssetPayment)Mockito.doNothing().when((Object)assetPaymentMock)).refreshReferenceObject("financialObject");
        Mockito.when((Object)assetPaymentMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)assetPaymentMock.getFinancialObjectCode()).thenReturn((Object)"7100");
        asset.setAssetPayments(List.of(assetPaymentMock));
        Assertions.assertTrue((boolean)this.cut.isAssetMovableCheckByPayment(asset));
    }

    @Test
    void testIsMovableFinancialObjectSubtypeCode_Success() {
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES);
        Assertions.assertTrue((boolean)this.cut.isAssetMovableCheckByPayment("C2"));
    }

    @Test
    void testIsMovableFinancialObjectSubtypeCode_Failure() {
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES);
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "NON_MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(NON_MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES);
        Assertions.assertFalse((boolean)this.cut.isAssetMovableCheckByPayment("LI"));
        boolean failedAsExpected = false;
        try {
            this.cut.isAssetMovableCheckByPayment("XY");
        }
        catch (ValidationException e) {
            failedAsExpected = true;
        }
        Assertions.assertTrue((boolean)failedAsExpected);
    }

    @Test
    void hasCapitalAssetChangedNoChanges() {
        Assertions.assertFalse((boolean)this.cut.hasCapitalAssetLocationDetailsChanged(new AssetLocationGlobalDetail()));
    }

    @Test
    void hasCapitalAssetChangedCampusCodeChanged(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureServiceMock) {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail(persistenceStructureServiceMock);
        assetLocationGlobalDetail.setCampusCode("BL");
        Assertions.assertTrue((boolean)this.cut.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    @Test
    void hasCapitalAssetChangedBuildingCodeChanged(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureServiceMock) {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail(persistenceStructureServiceMock);
        assetLocationGlobalDetail.setBuildingCode("0001C");
        Assertions.assertTrue((boolean)this.cut.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    @Test
    void hasCapitalAssetChangedBuildingRoomNumberChanged(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureServiceMock) {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail(persistenceStructureServiceMock);
        assetLocationGlobalDetail.setBuildingRoomNumber("001");
        Assertions.assertTrue((boolean)this.cut.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    @Test
    void hasCapitalAssetChangedBuildingSubRoomNumberChanged(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureServiceMock) {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail(persistenceStructureServiceMock);
        assetLocationGlobalDetail.setBuildingSubRoomNumber("C");
        Assertions.assertTrue((boolean)this.cut.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    @Test
    void hasCapitalAssetChangedCampusTagNumberChanged(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureServiceMock) {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail(persistenceStructureServiceMock);
        assetLocationGlobalDetail.setCampusTagNumber("ABC123");
        Assertions.assertTrue((boolean)this.cut.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    @Test
    void hasCapitalAssetChangedUpdateLastInventoryDateButtonClicked(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureServiceMock) {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail(persistenceStructureServiceMock);
        assetLocationGlobalDetail.setUpdateLastInventoryDate(true);
        Assertions.assertFalse((boolean)this.cut.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    public static AssetLocationGlobalDetail setupAssetLocationGlobalDetail(PersistenceStructureService persistenceStructureService) {
        AssetLocationGlobalDetail assetLocationGlobalDetail = new AssetLocationGlobalDetail();
        ReflectionUtils.doWithFields(AssetLocationGlobalDetail.class, field -> {
            field.setAccessible(true);
            field.set(assetLocationGlobalDetail, persistenceStructureService);
        }, field -> StringUtils.equals((CharSequence)field.getName(), (CharSequence)"persistenceStructureService"));
        assetLocationGlobalDetail.setAsset(new Asset());
        assetLocationGlobalDetail.setCapitalAssetNumber(Long.valueOf(12345L));
        return assetLocationGlobalDetail;
    }
}

