/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobalDetail;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.impl.AssetLocationServiceImpl;
import org.kuali.kfs.module.cam.document.service.impl.AssetServiceImpl;
import org.kuali.kfs.module.cam.document.validation.impl.AssetLocationGlobalRule;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.util.AutoPopulatingList;
import org.springframework.util.ReflectionUtils;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class AssetLocationGlobalRuleTest {
    private AssetLocationGlobalRule assetLocationGlobalRule;
    private AssetLocationGlobalDetail assetLocationGlobalDetail;
    private Asset asset;

    AssetLocationGlobalRuleTest() {
    }

    @BeforeEach
    public void setUp() {
        this.assetLocationGlobalRule = new AssetLocationGlobalRule();
        this.assetLocationGlobalRule.setAssetLocationService((AssetLocationService)new AssetLocationServiceImpl());
        this.assetLocationGlobalRule.setAssetService((AssetService)new AssetServiceImpl());
        this.assetLocationGlobalDetail = new AssetLocationGlobalDetail();
        this.assetLocationGlobalDetail.setCapitalAssetNumber(Long.valueOf(12345L));
        this.assetLocationGlobalDetail.setCampusCode("BL");
        this.assetLocationGlobalDetail.setBuildingCode("BL001");
        this.assetLocationGlobalDetail.setBuildingRoomNumber("001");
        this.asset = new Asset();
        this.assetLocationGlobalDetail.setAsset(this.asset);
    }

    @AfterEach
    public void tearDown() {
        AssetLocationGlobalRuleTest.teardownPersistenceStructureService(this.assetLocationGlobalDetail);
        this.assetLocationGlobalRule = null;
        this.assetLocationGlobalDetail = null;
        this.asset = null;
        GlobalVariables.getMessageMap().getWarningMessages().clear();
    }

    private static void teardownPersistenceStructureService(AssetLocationGlobalDetail assetLocationGlobalDetail) {
        ReflectionUtils.doWithFields(AssetLocationGlobalDetail.class, field -> {
            field.setAccessible(true);
            field.set(assetLocationGlobalDetail, null);
        }, field -> StringUtils.equals((CharSequence)field.getName(), (CharSequence)"persistenceStructureService"));
    }

    @Test
    void checkRequiredFieldsAfterAdd() {
        Assertions.assertTrue((boolean)this.assetLocationGlobalRule.checkRequiredFieldsAfterAdd(this.assetLocationGlobalDetail));
    }

    @Test
    void checkRequiredFieldsAfterAddEmptyBuildingFields() {
        this.assetLocationGlobalDetail.setBuildingCode(null);
        this.assetLocationGlobalDetail.setBuildingRoomNumber(null);
        Assertions.assertFalse((boolean)this.assetLocationGlobalRule.checkRequiredFieldsAfterAdd(this.assetLocationGlobalDetail));
    }

    @Test
    void checkRequiredFieldsAfterAddEmptyBuildingFieldsOffCampusLocation() {
        AssetLocation assetLocation = new AssetLocation();
        assetLocation.setAssetLocationTypeCode("O");
        assetLocation.setAssetLocationStreetAddress("123 Main St.");
        ArrayList<AssetLocation> assetLocations = new ArrayList<AssetLocation>();
        assetLocations.add(assetLocation);
        this.asset.setAssetLocations(assetLocations);
        this.assetLocationGlobalDetail.setBuildingCode(null);
        this.assetLocationGlobalDetail.setBuildingRoomNumber(null);
        Assertions.assertFalse((boolean)this.assetLocationGlobalRule.checkRequiredFieldsAfterAdd(this.assetLocationGlobalDetail));
    }

    @Test
    void checkRequiredFieldsAfterAddEmptyBuildingFieldsOffCampusLocationUpdateButtonClicked() {
        AssetLocation assetLocation = new AssetLocation();
        assetLocation.setAssetLocationTypeCode("O");
        assetLocation.setAssetLocationStreetAddress("123 Main St.");
        ArrayList<AssetLocation> assetLocations = new ArrayList<AssetLocation>();
        assetLocations.add(assetLocation);
        this.asset.setAssetLocations(assetLocations);
        this.assetLocationGlobalDetail.setBuildingCode(null);
        this.assetLocationGlobalDetail.setBuildingRoomNumber(null);
        this.assetLocationGlobalDetail.setUpdateLastInventoryDate(true);
        Assertions.assertTrue((boolean)this.assetLocationGlobalRule.checkRequiredFieldsAfterAdd(this.assetLocationGlobalDetail));
    }

    @Test
    void hasCapitalAssetChangedNoChanges(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureService) {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail(persistenceStructureService);
        Assertions.assertFalse((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getWarningCount());
        String warningMsg = ((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getWarningMessages().get("capitalAssetNumber")).get(0)).getErrorKey();
        Assertions.assertEquals((Object)"warning.asset.not.changed", (Object)warningMsg);
        Object[] expected = new String[]{"12345"};
        Object[] actual = ((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getWarningMessages().get("capitalAssetNumber")).get(0)).getMessageParameters();
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void hasCapitalAssetChangedCampusCodeChanged(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureService) {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail(persistenceStructureService);
        this.assetLocationGlobalDetail.setCampusCode("BL");
        Assertions.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getWarningCount());
    }

    @Test
    void hasCapitalAssetChangedBuildingCodeChanged(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureService) {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail(persistenceStructureService);
        this.assetLocationGlobalDetail.setBuildingCode("0001C");
        Assertions.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getWarningCount());
    }

    @Test
    void hasCapitalAssetChangedBuildingRoomNumberChanged(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureService) {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail(persistenceStructureService);
        this.assetLocationGlobalDetail.setBuildingRoomNumber("001");
        Assertions.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getWarningCount());
    }

    @Test
    void hasCapitalAssetChangedBuildingSubRoomNumberChanged(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureService) {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail(persistenceStructureService);
        this.assetLocationGlobalDetail.setBuildingSubRoomNumber("C");
        Assertions.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getWarningCount());
    }

    @Test
    void hasCapitalAssetChangedCampusTagNumberChanged(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureService) {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail(persistenceStructureService);
        this.assetLocationGlobalDetail.setCampusTagNumber("ABC123");
        Assertions.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getWarningCount());
    }

    @Test
    void hasCapitalAssetChangedUpdateLastInventoryDateButtonClicked(@Mock(stubOnly=true) PersistenceStructureService persistenceStructureService) {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail(persistenceStructureService);
        this.assetLocationGlobalDetail.setUpdateLastInventoryDate(true);
        Assertions.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getWarningCount());
    }

    public AssetLocationGlobalDetail setupAssetLocationGlobalDetail(PersistenceStructureService persistenceStructureService) {
        this.assetLocationGlobalDetail = new AssetLocationGlobalDetail();
        AssetLocationGlobalRuleTest.setupPersistenceStructureService(this.assetLocationGlobalDetail, persistenceStructureService);
        this.assetLocationGlobalDetail.setAsset(new Asset());
        this.assetLocationGlobalDetail.setCapitalAssetNumber(Long.valueOf(12345L));
        return this.assetLocationGlobalDetail;
    }

    private static void setupPersistenceStructureService(AssetLocationGlobalDetail assetLocationGlobalDetail, @Mock(stubOnly=true) PersistenceStructureService persistenceStructureService) {
        ReflectionUtils.doWithFields(AssetLocationGlobalDetail.class, field -> {
            field.setAccessible(true);
            field.set(assetLocationGlobalDetail, persistenceStructureService);
        }, field -> StringUtils.equals((CharSequence)field.getName(), (CharSequence)"persistenceStructureService"));
    }
}

