/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.utils;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.cam.util.KualiDecimalUtils;

@Execution(value=ExecutionMode.SAME_THREAD)
class KualiDecimalUtilsTest {
    KualiDecimalUtilsTest() {
    }

    @Test
    void allocateByQuantity_threeResults() {
        KualiDecimal[] allocationResults = KualiDecimalUtils.allocateByQuantity((KualiDecimal)new KualiDecimal(10.0), (int)3);
        Assertions.assertEquals((int)allocationResults.length, (int)3);
        Assertions.assertEquals((Object)allocationResults[0], (Object)new KualiDecimal(3.33));
        Assertions.assertEquals((Object)allocationResults[1], (Object)new KualiDecimal(3.33));
        Assertions.assertEquals((Object)allocationResults[2], (Object)new KualiDecimal(3.34));
    }

    @Test
    void allocateByQuantity_fifteenResults() {
        KualiDecimal[] allocationResults = KualiDecimalUtils.allocateByQuantity((KualiDecimal)new KualiDecimal(10.0), (int)15);
        Assertions.assertEquals((int)allocationResults.length, (int)15);
        Assertions.assertEquals((Object)allocationResults[0], (Object)new KualiDecimal(0.67));
        Assertions.assertEquals((Object)allocationResults[1], (Object)new KualiDecimal(0.67));
        Assertions.assertEquals((Object)allocationResults[2], (Object)new KualiDecimal(0.67));
        Assertions.assertEquals((Object)allocationResults[3], (Object)new KualiDecimal(0.67));
        Assertions.assertEquals((Object)allocationResults[4], (Object)new KualiDecimal(0.67));
        Assertions.assertEquals((Object)allocationResults[5], (Object)new KualiDecimal(0.67));
        Assertions.assertEquals((Object)allocationResults[6], (Object)new KualiDecimal(0.67));
        Assertions.assertEquals((Object)allocationResults[7], (Object)new KualiDecimal(0.67));
        Assertions.assertEquals((Object)allocationResults[8], (Object)new KualiDecimal(0.67));
        Assertions.assertEquals((Object)allocationResults[9], (Object)new KualiDecimal(0.67));
        Assertions.assertEquals((Object)allocationResults[10], (Object)new KualiDecimal(0.66));
        Assertions.assertEquals((Object)allocationResults[11], (Object)new KualiDecimal(0.66));
        Assertions.assertEquals((Object)allocationResults[12], (Object)new KualiDecimal(0.66));
        Assertions.assertEquals((Object)allocationResults[13], (Object)new KualiDecimal(0.66));
        Assertions.assertEquals((Object)allocationResults[14], (Object)new KualiDecimal(0.66));
    }

    @Test
    void allocateByQuantity_sevenResults() {
        KualiDecimal[] allocationResults = KualiDecimalUtils.allocateByQuantity((KualiDecimal)new KualiDecimal(5.0), (int)7);
        Assertions.assertEquals((int)allocationResults.length, (int)7);
        Assertions.assertEquals((Object)allocationResults[0], (Object)new KualiDecimal(0.71));
        Assertions.assertEquals((Object)allocationResults[1], (Object)new KualiDecimal(0.71));
        Assertions.assertEquals((Object)allocationResults[2], (Object)new KualiDecimal(0.71));
        Assertions.assertEquals((Object)allocationResults[3], (Object)new KualiDecimal(0.71));
        Assertions.assertEquals((Object)allocationResults[4], (Object)new KualiDecimal(0.72));
        Assertions.assertEquals((Object)allocationResults[5], (Object)new KualiDecimal(0.72));
        Assertions.assertEquals((Object)allocationResults[6], (Object)new KualiDecimal(0.72));
    }

    @Test
    void allocateByRatio_oneRatio() {
        KualiDecimal[] values = KualiDecimalUtils.allocateByRatio((KualiDecimal)new KualiDecimal(13), (double[])new double[]{0.533333});
        Assertions.assertNotNull((Object)values);
        Assertions.assertEquals((int)1, (int)values.length);
        Assertions.assertEquals((Object)new KualiDecimal(6.94), (Object)values[0]);
    }

    @Test
    void allocateByRatio_threeRatios() {
        KualiDecimal[] values = KualiDecimalUtils.allocateByRatio((KualiDecimal)new KualiDecimal(13), (double[])new double[]{0.2820512821, 0.333333333, 0.384615385});
        Assertions.assertNotNull((Object)values);
        Assertions.assertEquals((int)3, (int)values.length);
        Assertions.assertEquals((Object)new KualiDecimal(3.67), (Object)values[0]);
        Assertions.assertEquals((Object)new KualiDecimal(4.33), (Object)values[1]);
        Assertions.assertEquals((Object)new KualiDecimal(5), (Object)values[2]);
        Assertions.assertEquals((Object)new KualiDecimal(13), (Object)((KualiDecimal)values[2].add((AbstractKualiDecimal)values[1])).add((AbstractKualiDecimal)values[0]));
    }

    @Test
    void allocateByQuantity_largeAmount() {
        String input = "2956900.56";
        KualiDecimal originalAmount = new KualiDecimal("2956900.56");
        KualiDecimal allocatedAmount = KualiDecimalUtils.allocateByQuantity((KualiDecimal)originalAmount, (int)1)[0];
        Assertions.assertEquals((Object)originalAmount, (Object)allocatedAmount);
    }

    @Test
    void allocateByQuantity_largeDivisor_smallDividedAmount() {
        int i;
        KualiDecimal totalAmount = new KualiDecimal(99);
        int divisor = 10000;
        KualiDecimal[] allocationResults = KualiDecimalUtils.allocateByQuantity((KualiDecimal)totalAmount, (int)10000);
        KualiDecimal cent = new KualiDecimal(0.01);
        for (i = 0; i < 9900; ++i) {
            Assertions.assertEquals((Object)allocationResults[i], (Object)cent);
        }
        for (i = 9900; i < 10000; ++i) {
            Assertions.assertEquals((Object)allocationResults[i], (Object)KualiDecimal.ZERO);
        }
    }

    @Test
    void allocateByRatio_largeAmount() {
        int i;
        String input = "2956900.56";
        KualiDecimal originalAmount = new KualiDecimal("2956900.56");
        double[] ratio = new double[]{1.0};
        KualiDecimal allocatedAmount = KualiDecimalUtils.allocateByRatio((KualiDecimal)originalAmount, (double[])ratio)[0];
        Assertions.assertEquals((Object)originalAmount, (Object)allocatedAmount);
        KualiDecimal totalAmount = new KualiDecimal(99.0);
        double[] ratios = new double[10000];
        Arrays.fill(ratios, 1.0E-4);
        KualiDecimal[] allocationResults = KualiDecimalUtils.allocateByRatio((KualiDecimal)totalAmount, (double[])ratios);
        KualiDecimal cent = new KualiDecimal(0.01);
        for (i = 0; i < ratios.length - 100; ++i) {
            Assertions.assertEquals((Object)allocationResults[i], (Object)cent);
        }
        for (i = ratios.length - 100; i < ratios.length; ++i) {
            Assertions.assertEquals((Object)allocationResults[i], (Object)KualiDecimal.ZERO);
        }
    }

    @Test
    void allocateByRatio_largeNumberOfRations_smallAllocatedAmount() {
        int i;
        KualiDecimal totalAmount = new KualiDecimal(99.0);
        double[] ratios = new double[10000];
        Arrays.fill(ratios, 1.0E-4);
        KualiDecimal[] allocationResults = KualiDecimalUtils.allocateByRatio((KualiDecimal)totalAmount, (double[])ratios);
        KualiDecimal cent = new KualiDecimal(0.01);
        for (i = 0; i < ratios.length - 100; ++i) {
            Assertions.assertEquals((Object)allocationResults[i], (Object)cent);
        }
        for (i = ratios.length - 100; i < ratios.length; ++i) {
            Assertions.assertEquals((Object)allocationResults[i], (Object)KualiDecimal.ZERO);
        }
    }
}

