/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectSubType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.businessobject.FiscalYearBasedBusinessObject;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;

import java.util.List;

public class AssetObjectCode extends PersistableBusinessObjectBase implements MutableInactivatable,
        FiscalYearBasedBusinessObject {

    protected Integer universityFiscalYear;
    protected String chartOfAccountsCode;
    protected String financialObjectSubTypeCode;
    protected String capitalizationFinancialObjectCode;
    protected String accumulatedDepreciationFinancialObjectCode;
    protected String depreciationExpenseFinancialObjectCode;
    protected boolean active;

    protected transient SystemOptions universityFiscal;
    protected ObjectCode accumulatedDepreciationFinancialObject;
    protected ObjectCode capitalizationFinancialObject;
    protected ObjectCode depreciationExpenseFinancialObject;
    protected List<ObjectCode> objectCode;
    protected Chart chartOfAccounts;
    protected ObjectSubType financialObjectSubType;

    public AssetObjectCode() {

    }

    @Override
    public Integer getUniversityFiscalYear() {
        return universityFiscalYear;
    }

    @Override
    public void setUniversityFiscalYear(final Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getFinancialObjectSubTypeCode() {
        return financialObjectSubTypeCode;
    }

    public void setFinancialObjectSubTypeCode(final String financialObjectSubTypeCode) {
        this.financialObjectSubTypeCode = financialObjectSubTypeCode;
    }

    public String getCapitalizationFinancialObjectCode() {
        return capitalizationFinancialObjectCode;
    }

    public void setCapitalizationFinancialObjectCode(final String capitalizationFinancialObjectCode) {
        this.capitalizationFinancialObjectCode = capitalizationFinancialObjectCode;
    }

    public String getAccumulatedDepreciationFinancialObjectCode() {
        return accumulatedDepreciationFinancialObjectCode;
    }

    public void setAccumulatedDepreciationFinancialObjectCode(final String accumulatedDepreciationFinancialObjectCode) {
        this.accumulatedDepreciationFinancialObjectCode = accumulatedDepreciationFinancialObjectCode;
    }

    public String getDepreciationExpenseFinancialObjectCode() {
        return depreciationExpenseFinancialObjectCode;
    }

    public void setDepreciationExpenseFinancialObjectCode(final String depreciationExpenseFinancialObjectCode) {
        this.depreciationExpenseFinancialObjectCode = depreciationExpenseFinancialObjectCode;
    }

    public ObjectCode getAccumulatedDepreciationFinancialObject() {
        return accumulatedDepreciationFinancialObject;
    }

    /**
     * @deprecated
     */
    public void setAccumulatedDepreciationFinancialObject(final ObjectCode accumulatedDepreciationFinancialObject) {
        this.accumulatedDepreciationFinancialObject = accumulatedDepreciationFinancialObject;
    }

    public ObjectCode getCapitalizationFinancialObject() {
        return capitalizationFinancialObject;
    }

    /**
     * @deprecated
     */
    public void setCapitalizationFinancialObject(final ObjectCode capitalizationFinancialObject) {
        this.capitalizationFinancialObject = capitalizationFinancialObject;
    }

    public ObjectCode getDepreciationExpenseFinancialObject() {
        return depreciationExpenseFinancialObject;
    }

    /**
     * @deprecated
     */
    public void setDepreciationExpenseFinancialObject(final ObjectCode depreciationExpenseFinancialObject) {
        this.depreciationExpenseFinancialObject = depreciationExpenseFinancialObject;
    }

    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    /**
     * @deprecated
     */
    public void setChartOfAccounts(final Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public ObjectSubType getFinancialObjectSubType() {
        return financialObjectSubType;
    }

    /**
     * @deprecated
     */
    public void setFinancialObjectSubType(final ObjectSubType financialObjectSubType) {
        this.financialObjectSubType = financialObjectSubType;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(final boolean active) {
        this.active = active;
    }

    public SystemOptions getUniversityFiscal() {
        return universityFiscal;
    }

    public void setUniversityFiscal(final SystemOptions universityFiscal) {
        this.universityFiscal = universityFiscal;
    }

    public List<ObjectCode> getObjectCode() {
        return objectCode;
    }

    public void setObjectCode(final List<ObjectCode> objectCode) {
        this.objectCode = objectCode;
    }

}
