/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Campus;
import org.kuali.kfs.sys.businessobject.Room;

import java.sql.Timestamp;

/**
 * Class for the barcode inventory error detail
 */
public class BarcodeInventoryErrorDetail extends PersistableBusinessObjectBase {

    private String documentNumber;
    private Long uploadRowNumber;
    private String errorCorrectionStatusCode;
    private String correctorUniversalIdentifier;
    private Timestamp inventoryCorrectionTimestamp;
    private String assetTagNumber;
    private boolean uploadScanIndicator;
    private Timestamp uploadScanTimestamp;
    private String campusCode;
    private String buildingCode;
    private String buildingRoomNumber;
    private String buildingSubRoomNumber;
    private String assetConditionCode;

    // References
    private Campus campus;
    private Room buildingRoom;
    private Building building;
    private AssetCondition condition;

    // error description. This field is not being saved in any table.
    private String errorDescription;

    public BarcodeInventoryErrorDetail() {

    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(final String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getUploadRowNumber() {
        return uploadRowNumber;
    }

    public void setUploadRowNumber(final Long uploadRowNumber) {
        this.uploadRowNumber = uploadRowNumber;
    }

    public String getErrorCorrectionStatusCode() {
        return errorCorrectionStatusCode;
    }

    public void setErrorCorrectionStatusCode(final String errorCorrectionStatusCode) {
        this.errorCorrectionStatusCode = errorCorrectionStatusCode;
    }

    public String getCorrectorUniversalIdentifier() {
        return correctorUniversalIdentifier;
    }

    public void setCorrectorUniversalIdentifier(final String correctorUniversalIdentifier) {
        this.correctorUniversalIdentifier = correctorUniversalIdentifier;
    }

    public Timestamp getInventoryCorrectionTimestamp() {
        return inventoryCorrectionTimestamp;
    }

    public void setInventoryCorrectionTimestamp(final Timestamp inventoryCorrectionTimestamp) {
        this.inventoryCorrectionTimestamp = inventoryCorrectionTimestamp;
    }

    public String getAssetTagNumber() {
        return assetTagNumber;
    }

    public void setAssetTagNumber(final String assetTagNumber) {
        this.assetTagNumber = assetTagNumber;
    }

    public boolean isUploadScanIndicator() {
        return uploadScanIndicator;
    }

    public void setUploadScanIndicator(final boolean uploadScanIndicator) {
        this.uploadScanIndicator = uploadScanIndicator;
    }

    public Timestamp getUploadScanTimestamp() {
        return uploadScanTimestamp;
    }

    public void setUploadScanTimestamp(final Timestamp uploadScanTimestamp) {
        this.uploadScanTimestamp = uploadScanTimestamp;
    }

    public String getCampusCode() {
        return campusCode;
    }

    public void setCampusCode(final String campusCode) {
        this.campusCode = campusCode;
    }

    public String getBuildingCode() {
        return buildingCode;
    }

    public void setBuildingCode(final String buildingCode) {
        this.buildingCode = buildingCode;
    }

    public String getBuildingRoomNumber() {
        return buildingRoomNumber;
    }

    public void setBuildingRoomNumber(final String buildingRoomNumber) {
        this.buildingRoomNumber = buildingRoomNumber;
    }

    public String getBuildingSubRoomNumber() {
        return buildingSubRoomNumber;
    }

    public void setBuildingSubRoomNumber(final String buildingSubRoomNumber) {
        this.buildingSubRoomNumber = buildingSubRoomNumber;
    }

    public String getAssetConditionCode() {
        return assetConditionCode;
    }

    public void setAssetConditionCode(final String assetConditionCode) {
        this.assetConditionCode = assetConditionCode;
    }

    public Campus getCampus() {
        return campus;
    }

    public void setCampus(final Campus campus) {
        this.campus = campus;
    }

    public Room getBuildingRoom() {
        return buildingRoom;
    }

    public void setBuildingRoom(final Room buildingRoom) {
        this.buildingRoom = buildingRoom;
    }

    public Building getBuilding() {
        return building;
    }

    public void setBuilding(final Building building) {
        this.building = building;
    }

    public AssetCondition getCondition() {
        return condition;
    }

    public void setCondition(final AssetCondition condition) {
        this.condition = condition;
    }

    public String getErrorDescription() {
        return errorDescription;
    }

    public void setErrorDescription(final String errorDescription) {
        this.errorDescription = errorDescription;
    }
}
