/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

public class PurchasingAccountsPayableActionHistory extends PersistableBusinessObjectBase {

    private Long actionIdentifier;
    private String actionTypeCode;
    private String fromDocumentNumber;
    private Integer fromPurApLineItemIdentifier;
    private Integer fromCabLineNumber;
    private String toDocumentNumber;
    private Integer toPurApLineItemIdentifier;
    private Integer toCabLineNumber;
    private Long generalLedgerAccountIdentifier;
    private KualiDecimal itemAccountTotalAmount;
    private KualiDecimal accountsPayableItemQuantity;
    private boolean active;

    public PurchasingAccountsPayableActionHistory() {

    }

    public PurchasingAccountsPayableActionHistory(
            final PurchasingAccountsPayableItemAsset fromItem,
            final PurchasingAccountsPayableItemAsset toItem, final String actionType) {
        actionTypeCode = actionType;
        fromDocumentNumber = fromItem.getDocumentNumber();
        fromPurApLineItemIdentifier = fromItem.getAccountsPayableLineItemIdentifier();
        fromCabLineNumber = fromItem.getCapitalAssetBuilderLineNumber();
        if (toItem != null) {
            toDocumentNumber = toItem.getDocumentNumber();
            toPurApLineItemIdentifier = toItem.getAccountsPayableLineItemIdentifier();
            toCabLineNumber = toItem.getCapitalAssetBuilderLineNumber();
        }
        active = true;
    }

    public Long getActionIdentifier() {
        return actionIdentifier;
    }

    public void setActionIdentifier(final Long actionIdentifier) {
        this.actionIdentifier = actionIdentifier;
    }

    public String getActionTypeCode() {
        return actionTypeCode;
    }

    public void setActionTypeCode(final String actionTypeCode) {
        this.actionTypeCode = actionTypeCode;
    }

    public String getFromDocumentNumber() {
        return fromDocumentNumber;
    }

    public void setFromDocumentNumber(final String fromDocumentNumber) {
        this.fromDocumentNumber = fromDocumentNumber;
    }

    public Integer getFromPurApLineItemIdentifier() {
        return fromPurApLineItemIdentifier;
    }

    public void setFromPurApLineItemIdentifier(final Integer fromPurApLineItemIdentifier) {
        this.fromPurApLineItemIdentifier = fromPurApLineItemIdentifier;
    }

    public Integer getFromCabLineNumber() {
        return fromCabLineNumber;
    }

    public void setFromCabLineNumber(final Integer fromCabLineNumber) {
        this.fromCabLineNumber = fromCabLineNumber;
    }

    public String getToDocumentNumber() {
        return toDocumentNumber;
    }

    public void setToDocumentNumber(final String toDocumentNumber) {
        this.toDocumentNumber = toDocumentNumber;
    }

    public Integer getToPurApLineItemIdentifier() {
        return toPurApLineItemIdentifier;
    }

    public void setToPurApLineItemIdentifier(final Integer toPurApLineItemIdentifier) {
        this.toPurApLineItemIdentifier = toPurApLineItemIdentifier;
    }

    public Integer getToCabLineNumber() {
        return toCabLineNumber;
    }

    public void setToCabLineNumber(final Integer toCabLineNumber) {
        this.toCabLineNumber = toCabLineNumber;
    }

    public Long getGeneralLedgerAccountIdentifier() {
        return generalLedgerAccountIdentifier;
    }

    public void setGeneralLedgerAccountIdentifier(final Long generalLedgerAccountIdentifier) {
        this.generalLedgerAccountIdentifier = generalLedgerAccountIdentifier;
    }

    public KualiDecimal getItemAccountTotalAmount() {
        return itemAccountTotalAmount;
    }

    public void setItemAccountTotalAmount(final KualiDecimal itemAccountTotalAmount) {
        this.itemAccountTotalAmount = itemAccountTotalAmount;
    }

    public KualiDecimal getAccountsPayableItemQuantity() {
        return accountsPayableItemQuantity;
    }

    public void setAccountsPayableItemQuantity(final KualiDecimal accountsPayableItemQuantity) {
        this.accountsPayableItemQuantity = accountsPayableItemQuantity;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(final boolean active) {
        this.active = active;
    }

}
