/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service.impl;

import java.lang.constant.Constable;
import java.sql.Date;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.batch.AssetPaymentInfo;
import org.kuali.kfs.module.cam.batch.service.ReportService;
import org.kuali.kfs.module.cam.batch.service.impl.AssetDepreciationServiceImpl;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciableAssetsDao;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciationBatchDao;
import org.kuali.kfs.module.cam.document.dataaccess.impl.DepreciationBatchDaoJdbc;
import org.kuali.kfs.module.cam.document.service.AssetDateService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.fixture.AssetDepreciationServiceFixture;
import org.kuali.kfs.sys.batch.service.SchedulerService;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class AssetDepreciationServiceImplTest {
    @Spy
    private AssetDepreciationServiceImpl cutSpy;
    @Mock(stubOnly=true)
    private ConfigurationService kualiConfigSvcMock;
    @Mock(stubOnly=true)
    private BusinessObjectService boServiceMock;
    @Mock(stubOnly=true)
    private ParameterService paramSvcMock;
    @Mock(stubOnly=true)
    private DateTimeService dateTimeSvcMock;
    @Mock(stubOnly=true)
    private SchedulerService schedulerSvcMock;
    @Mock(stubOnly=true)
    private OptionsService optionsSvcMock;
    @Mock(stubOnly=true)
    private DepreciableAssetsDao depreciableAssetsDaoMock;
    @Mock(stubOnly=true)
    private ObjectCodeService objectCodeSvcMock;
    @Mock(stubOnly=true)
    private WorkflowDocumentService workflowDocSvcMock;
    @Mock(stubOnly=true)
    private AssetService assetSvcMock;
    @Mock(stubOnly=true)
    private AssetDateService assetDateSvcMock;
    @Mock(stubOnly=true)
    private UniversityDateService universityDateSvcMock;
    @Mock(stubOnly=true)
    private WorkflowDocument workflowDocMock;
    @Mock(stubOnly=true)
    private ReportService reportSvcMock;
    @Mock(stubOnly=true)
    private Person personMock;
    private DepreciationBatchDao depreciationBatchDaoMock;
    private List<AssetPaymentInfo> savedPaymentInfo;

    AssetDepreciationServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.depreciationBatchDaoMock = (DepreciationBatchDao)Mockito.mock(DepreciationBatchDao.class, (Answer)AdditionalAnswers.delegatesTo((Object)new DepreciationBatchDaoJdbc(){

            public void updateAssetPayments(List<AssetPaymentInfo> assetPayments, Integer fiscalPeriod) {
                AssetDepreciationServiceImplTest.this.savedPaymentInfo.addAll(assetPayments);
            }
        }));
        this.cutSpy.setDateTimeService(this.dateTimeSvcMock);
        this.cutSpy.setConfigurationService(this.kualiConfigSvcMock);
        this.cutSpy.setParameterService(this.paramSvcMock);
        this.cutSpy.setSchedulerService(this.schedulerSvcMock);
        this.cutSpy.setOptionsService(this.optionsSvcMock);
        this.cutSpy.setBusinessObjectService(this.boServiceMock);
        this.cutSpy.setDepreciableAssetsDao(this.depreciableAssetsDaoMock);
        this.cutSpy.setDepreciationBatchDao(this.depreciationBatchDaoMock);
        this.cutSpy.setObjectCodeService(this.objectCodeSvcMock);
        this.cutSpy.setWorkflowDocumentService(this.workflowDocSvcMock);
        this.cutSpy.setAssetService(this.assetSvcMock);
        this.cutSpy.setAssetDateService(this.assetDateSvcMock);
        this.cutSpy.setUniversityDateService(this.universityDateSvcMock);
        this.cutSpy.setCamsReportService(this.reportSvcMock);
        this.savedPaymentInfo = new ArrayList<AssetPaymentInfo>();
    }

    @Test
    void runDepreciation() throws Exception {
        List<AssetPayment> assetPayments = AssetDepreciationServiceFixture.DATA.getAssetPaymentsFromPropertiesFile();
        AssetDepreciationServiceImplTest.setupBusinessObjectServiceFindByPrimaryKeyMocking(assetPayments.get(1), this.boServiceMock);
        AssetDepreciationServiceImplTest.setupBusinessObjectServiceFindByPrimaryKeyMocking(assetPayments.get(2), this.boServiceMock);
        AssetDepreciationServiceImplTest.setupBusinessObjectServiceFindByPrimaryKeyMocking(assetPayments.get(3), this.boServiceMock);
        AssetDepreciationServiceImplTest.setupBusinessObjectServiceFindByPrimaryKeyMocking(assetPayments.get(4), this.boServiceMock);
        AssetDepreciationServiceImplTest.setupBusinessObjectServiceFindByPrimaryKeyMocking(assetPayments.get(5), this.boServiceMock);
        AssetDepreciationServiceImplTest.setupBusinessObjectServiceFindByPrimaryKeyMocking(assetPayments.get(6), this.boServiceMock);
        this.recordMocks();
        ((DepreciationBatchDao)Mockito.doNothing().when((Object)this.depreciationBatchDaoMock)).savePendingGLEntries((List)ArgumentMatchers.any());
        this.cutSpy.runDepreciation();
        List<AssetPaymentInfo> resultsMustGet = AssetDepreciationServiceFixture.DATA.getResultsFromPropertiesFile();
        Assertions.assertEquals((int)resultsMustGet.size(), (int)this.savedPaymentInfo.size());
        Assertions.assertTrue((boolean)AssetDepreciationServiceImplTest.isDepreciationOk(this.savedPaymentInfo, resultsMustGet));
    }

    private static void setupBusinessObjectServiceFindByPrimaryKeyMocking(AssetPayment assetPayment, BusinessObjectService businessObjectServiceMock) {
        Map<String, Integer> primaryKeys = Map.of("capitalAssetNumber", assetPayment.getCapitalAssetNumber(), "paymentSequenceNumber", assetPayment.getPaymentSequenceNumber());
        Mockito.when((Object)((AssetPayment)businessObjectServiceMock.findByPrimaryKey(AssetPayment.class, primaryKeys))).thenReturn((Object)assetPayment);
    }

    @Test
    void invalidFiscalMonth() throws Exception {
        this.recordInvalidFiscalMonthMocks();
        this.cutSpy.runDepreciation();
    }

    @Test
    void missingDepreciationDateParameter() {
        this.recordMissingDepreciationDateParameterMocks();
        this.cutSpy.runDepreciation();
    }

    private void recordMocks() throws Exception {
        java.util.Date date = new java.util.Date();
        java.util.Date depreciationDate = AssetDepreciationServiceFixture.DATA.getDepreciationDate();
        Calendar depreciationCalendar = Calendar.getInstance();
        depreciationCalendar.setTime(depreciationDate);
        LocalDate depreciationLocalDate = depreciationDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        List<AssetObjectCode> assetObjectCodes = AssetDepreciationServiceFixture.DATA.getAssetObjectCodes();
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentCalendar()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)this.kualiConfigSvcMock.getPropertyValueAsString("error.batch.depreciation.alreadyRan")).thenReturn((Object)"Already ran");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentDate()).thenReturn((Object)date);
        Mockito.when((Object)this.dateTimeSvcMock.getLocalDate((Calendar)ArgumentMatchers.any(Calendar.class))).thenReturn((Object)depreciationLocalDate);
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_BEGIN")).thenReturn(null);
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_END")).thenReturn(null);
        Mockito.when((Object)this.schedulerSvcMock.cronConditionMet(null)).thenReturn((Object)true);
        Mockito.when((Object)this.paramSvcMock.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_DATE")).thenReturn((Object)true);
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsString(AssetDepreciationStep.class, "DEPRECIATION_DATE")).thenReturn((Object)AssetDepreciationServiceFixture.DATA.getDepreciationDateString());
        Mockito.when((Object)((UniversityDate)this.boServiceMock.findBySinglePrimaryKey(UniversityDate.class, (Object)new Date(depreciationDate.getTime())))).thenReturn((Object)AssetDepreciationServiceFixture.DATA.getUniversityDate());
        HashMap<String, Constable> fields = new HashMap<String, Constable>();
        fields.put("universityFiscalYear", Integer.valueOf(2010));
        fields.put("active", Boolean.TRUE);
        Mockito.when((Object)this.boServiceMock.findMatching(AssetObjectCode.class, fields)).thenReturn(assetObjectCodes);
        Mockito.when((Object)this.depreciableAssetsDaoMock.generateStatistics(true, null, Integer.valueOf(2010), Integer.valueOf(1), depreciationLocalDate, "", assetObjectCodes, 1, "Already ran")).thenReturn(new ArrayList());
        ((DepreciationBatchDao)Mockito.doReturn(AssetDepreciationServiceFixture.DATA.getAssetPaymentInfo()).when((Object)this.depreciationBatchDaoMock)).getListOfDepreciableAssetPaymentInfo(Integer.valueOf(2010), Integer.valueOf(1), depreciationLocalDate);
        Mockito.when((Object)this.paramSvcMock.parameterExists(AssetDepreciationStep.class, "ORGANIZATION_PLANT_FUND_SUB_TYPES")).thenReturn((Object)true);
        Mockito.when((Object)this.paramSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "ORGANIZATION_PLANT_FUND_SUB_TYPES")).thenReturn(Arrays.asList("C1", "C2", "CF", "CM", "ES", "NA", "UC", "UF"));
        Mockito.when((Object)this.paramSvcMock.parameterExists(AssetDepreciationStep.class, "CAMPUS_PLANT_FUND_SUB_TYPES")).thenReturn((Object)true);
        Mockito.when((Object)this.paramSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "CAMPUS_PLANT_FUND_SUB_TYPES")).thenReturn(Arrays.asList("BD", "BF", "BI", "BR", "BX", "IF", "LE", "LF", "LI", "LR"));
        Mockito.when((Object)this.paramSvcMock.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_PERIOD")).thenReturn((Object)true);
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsString(AssetDepreciationStep.class, "DEPRECIATION_PERIOD")).thenReturn((Object)"1");
        ((DepreciationBatchDao)Mockito.doReturn(AssetDepreciationServiceFixture.DATA.getPrimaryDepreciationBaseAmountForSV()).when((Object)this.depreciationBatchDaoMock)).getPrimaryDepreciationBaseAmountForSV();
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2010), "BL", "8910")).thenReturn((Object)AssetDepreciationServiceImplTest.getObjectCode("8910"));
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2010), "BL", "5115")).thenReturn((Object)AssetDepreciationServiceImplTest.getObjectCode("5115"));
        ((AssetDepreciationServiceImpl)Mockito.doReturn((Object)this.personMock).when((Object)this.cutSpy)).getPerson();
        Mockito.when((Object)this.workflowDocSvcMock.createWorkflowDocument((String)ArgumentMatchers.eq((Object)"DEPR"), (Person)ArgumentMatchers.any(Person.class))).thenReturn((Object)this.workflowDocMock);
        Mockito.when((Object)this.workflowDocMock.getDocumentId()).thenReturn((Object)"12345");
        Mockito.when((Object)((DocumentHeader)this.boServiceMock.save((PersistableBusinessObject)((DocumentHeader)ArgumentMatchers.isA(DocumentHeader.class))))).thenReturn(null);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)AssetDepreciationServiceFixture.DATA.getSystemOptions());
        Mockito.when((Object)this.dateTimeSvcMock.toDateString(depreciationDate)).thenReturn((Object)"");
        Mockito.when((Object)this.depreciableAssetsDaoMock.generateStatistics(false, Collections.singletonList("12345"), Integer.valueOf(2010), Integer.valueOf(1), depreciationLocalDate, "", assetObjectCodes, 1, "Already ran")).thenReturn(new ArrayList());
    }

    private void recordInvalidFiscalMonthMocks() throws Exception {
        java.util.Date date = new java.util.Date();
        java.util.Date depreciationDate = AssetDepreciationServiceFixture.DATA.getDepreciationDate();
        Calendar depreciationCalendar = Calendar.getInstance();
        depreciationCalendar.setTime(depreciationDate);
        LocalDate depreciationLocalDate = depreciationDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        List<AssetObjectCode> assetObjectCodes = AssetDepreciationServiceFixture.DATA.getAssetObjectCodes();
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentCalendar()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)this.kualiConfigSvcMock.getPropertyValueAsString("error.batch.depreciation.alreadyRan")).thenReturn((Object)"Already ran");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentDate()).thenReturn((Object)date);
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_BEGIN")).thenReturn(null);
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_END")).thenReturn(null);
        Mockito.when((Object)this.schedulerSvcMock.cronConditionMet(null)).thenReturn((Object)true);
        Mockito.when((Object)this.paramSvcMock.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_DATE")).thenReturn((Object)true);
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsString(AssetDepreciationStep.class, "DEPRECIATION_DATE")).thenReturn((Object)AssetDepreciationServiceFixture.DATA.getDepreciationDateString());
        Mockito.when((Object)((UniversityDate)this.boServiceMock.findBySinglePrimaryKey(UniversityDate.class, (Object)new Date(depreciationDate.getTime())))).thenReturn((Object)AssetDepreciationServiceFixture.DATA.getUniversityDate());
        HashMap<String, Constable> fields = new HashMap<String, Constable>();
        fields.put("universityFiscalYear", Integer.valueOf(2010));
        fields.put("active", Boolean.TRUE);
        Mockito.when((Object)this.boServiceMock.findMatching(AssetObjectCode.class, fields)).thenReturn(assetObjectCodes);
        Mockito.when((Object)this.depreciableAssetsDaoMock.generateStatistics(true, null, Integer.valueOf(2010), Integer.valueOf(1), depreciationLocalDate, "", assetObjectCodes, 1, "Already ran")).thenReturn(new ArrayList());
        ((DepreciationBatchDao)Mockito.doReturn(AssetDepreciationServiceFixture.DATA.getAssetPaymentInfo()).when((Object)this.depreciationBatchDaoMock)).getListOfDepreciableAssetPaymentInfo(Integer.valueOf(2010), Integer.valueOf(1), depreciationLocalDate);
        Mockito.when((Object)this.paramSvcMock.parameterExists(AssetDepreciationStep.class, "ORGANIZATION_PLANT_FUND_SUB_TYPES")).thenReturn((Object)true);
        Mockito.when((Object)this.paramSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "ORGANIZATION_PLANT_FUND_SUB_TYPES")).thenReturn(Arrays.asList("C1", "C2", "CF", "CM", "ES", "NA", "UC", "UF"));
        Mockito.when((Object)this.paramSvcMock.parameterExists(AssetDepreciationStep.class, "CAMPUS_PLANT_FUND_SUB_TYPES")).thenReturn((Object)true);
        Mockito.when((Object)this.paramSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "CAMPUS_PLANT_FUND_SUB_TYPES")).thenReturn(Arrays.asList("BD", "BF", "BI", "BR", "BX", "IF", "LE", "LF", "LI", "LR"));
        Mockito.when((Object)this.paramSvcMock.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_PERIOD")).thenReturn((Object)true);
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsString(AssetDepreciationStep.class, "DEPRECIATION_PERIOD")).thenReturn((Object)"3");
        Mockito.when((Object)this.kualiConfigSvcMock.getPropertyValueAsString("error.batch.depreciation.fiscalMonthNotValid")).thenReturn((Object)"Fiscal month of depreciation date must be a multiple of the depreciation period.");
        Mockito.when((Object)this.kualiConfigSvcMock.getPropertyValueAsString("error.batch.depreciation.calculationError")).thenReturn((Object)"An error occurred when calculating assets depreciation.");
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)AssetDepreciationServiceFixture.DATA.getSystemOptions());
        Mockito.when((Object)this.dateTimeSvcMock.toDateString(depreciationDate)).thenReturn((Object)"");
    }

    private void recordMissingDepreciationDateParameterMocks() {
        Calendar depreciationCalendar = Calendar.getInstance();
        depreciationCalendar.set(11, 0);
        depreciationCalendar.set(12, 0);
        depreciationCalendar.set(13, 0);
        depreciationCalendar.set(14, 0);
        java.util.Date date = depreciationCalendar.getTime();
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentCalendar()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)this.kualiConfigSvcMock.getPropertyValueAsString("error.batch.depreciation.alreadyRan")).thenReturn((Object)"Already ran");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentDate()).thenReturn((Object)date);
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_BEGIN")).thenReturn(null);
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_END")).thenReturn(null);
        Mockito.when((Object)this.schedulerSvcMock.cronConditionMet(null)).thenReturn((Object)true);
        Mockito.when((Object)this.paramSvcMock.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_DATE")).thenReturn((Object)false);
        Mockito.when((Object)((UniversityDate)this.boServiceMock.findBySinglePrimaryKey(UniversityDate.class, (Object)new Date(date.getTime())))).thenReturn(null);
        Mockito.when((Object)this.kualiConfigSvcMock.getPropertyValueAsString("error.gl.UniversityDateNotFound")).thenReturn((Object)"");
    }

    private static ObjectCode getObjectCode(String code) {
        ObjectCode result = new ObjectCode();
        result.setActive(true);
        result.setChartOfAccountsCode("BL");
        result.setUniversityFiscalYear(Integer.valueOf(2010));
        result.setFinancialObjectCode(code);
        return result;
    }

    private static boolean isDepreciationOk(Collection<AssetPaymentInfo> savedPaymentInfo, Collection<AssetPaymentInfo> resultsMustGet) {
        Iterator<AssetPaymentInfo> resultsMustGetIterator = resultsMustGet.iterator();
        for (AssetPaymentInfo depreciatedAsset : savedPaymentInfo) {
            AssetPaymentInfo resultMustGet = resultsMustGetIterator.next();
            if (!resultMustGet.getAccumulatedPrimaryDepreciationAmount().equals((Object)depreciatedAsset.getAccumulatedPrimaryDepreciationAmount())) {
                return false;
            }
            if (!resultMustGet.getTransactionAmount().equals((Object)depreciatedAsset.getTransactionAmount())) {
                return false;
            }
            if (resultMustGet.getAccumulatedRoundingErrorInMillicents().equals(depreciatedAsset.getAccumulatedRoundingErrorInMillicents())) continue;
            return false;
        }
        return true;
    }

    @Test
    void resetPeriodValuesWhenFirstFiscalPeriod_success(@Mock(stubOnly=true) DepreciationBatchDao depreciationBatchDaoMock) {
        this.cutSpy.setDepreciationBatchDao(depreciationBatchDaoMock);
        Assertions.assertTrue((boolean)this.cutSpy.resetPeriodValuesWhenFirstFiscalPeriod());
    }

    @Test
    void resetPeriodValuesWhenFirstFiscalPeriod_failure() throws Exception {
        ((DepreciationBatchDao)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.depreciationBatchDaoMock)).resetPeriodValuesWhenFirstFiscalPeriod(Integer.valueOf(1));
        Assertions.assertFalse((boolean)this.cutSpy.resetPeriodValuesWhenFirstFiscalPeriod());
    }
}

