/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.batch;

import org.kuali.kfs.gl.businessobject.Entry;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExtractProcessLog {
    private Timestamp startTime;
    private Timestamp finishTime;
    private Timestamp lastExtractTime;
    private List<Entry> ignoredGLEntries;
    private List<Entry> duplicateGLEntries;
    private List<Entry> mismatchedGLEntries;
    private String errorMessage;
    private boolean success = true;
    private Integer totalGlCount = 0;
    private Integer nonPurApGlCount = 0;
    private Integer purApGlCount = 0;
    private String statusMessage;

    /**
     * Gets the ignoredGLEntries attribute.
     *
     * @return Returns the ignoredGLEntries.
     */
    public List<Entry> getIgnoredGLEntries() {
        return ignoredGLEntries;
    }

    /**
     * Sets the ignoredGLEntries attribute value.
     *
     * @param ignoredGLEntries The ignoredGLEntries to set.
     */
    public void setIgnoredGLEntries(final List<Entry> ignoredGLEntries) {
        this.ignoredGLEntries = ignoredGLEntries;
    }

    /**
     * Gets the duplicateGLEntries attribute.
     *
     * @return Returns the duplicateGLEntries.
     */
    public List<Entry> getDuplicateGLEntries() {
        return duplicateGLEntries;
    }

    /**
     * Sets the duplicateGLEntries attribute value.
     *
     * @param duplicateGLEntries The duplicateGLEntries to set.
     */
    public void setDuplicateGLEntries(final List<Entry> duplicateGLEntries) {
        this.duplicateGLEntries = duplicateGLEntries;
    }

    /**
     * Gets the mismatchedGLEntries attribute.
     *
     * @return Returns the mismatchedGLEntries.
     */
    public List<Entry> getMismatchedGLEntries() {
        return mismatchedGLEntries;
    }

    /**
     * Sets the mismatchedGLEntries attribute value.
     *
     * @param mismatchedGLEntries The mismatchedGLEntries to set.
     */
    public void setMismatchedGLEntries(final List<Entry> mismatchedGLEntries) {
        this.mismatchedGLEntries = mismatchedGLEntries;
    }

    /**
     * Adds a collection of entries to ignoredGLEntries
     *
     * @param add ignoredGLEntries
     */
    public void addIgnoredGLEntries(final Collection<Entry> add) {
        if (ignoredGLEntries == null) {
            ignoredGLEntries = new ArrayList<>();
        }
        ignoredGLEntries.addAll(add);
    }

    /**
     * Adds a collection of entries to duplicateGLEntries
     *
     * @param add duplicateGLEntries
     */
    public void addDuplicateGLEntries(final Collection<Entry> add) {
        if (duplicateGLEntries == null) {
            duplicateGLEntries = new ArrayList<>();
        }
        duplicateGLEntries.addAll(add);
    }

    /**
     * Adds a collection of entries to mismatchedGLEntries
     *
     * @param add mismatchedGLEntries
     */
    public void addMismatchedGLEntries(final Collection<Entry> add) {
        if (mismatchedGLEntries == null) {
            mismatchedGLEntries = new ArrayList<>();
        }
        mismatchedGLEntries.addAll(add);
    }

    /**
     * Add a GL entry to ignoredGLEntries
     *
     * @param add Entry
     */
    public void addIgnoredGLEntry(final Entry add) {
        if (ignoredGLEntries == null) {
            ignoredGLEntries = new ArrayList<>();
        }
        ignoredGLEntries.add(add);
    }

    /**
     * Add a GL entry to duplicateGLEntries
     *
     * @param add Entry
     */
    public void addDuplicateGLEntry(final Entry add) {
        if (duplicateGLEntries == null) {
            duplicateGLEntries = new ArrayList<>();
        }
        duplicateGLEntries.add(add);
    }

    /**
     * Add a GL entry to mismatchedGLEntries
     *
     * @param add Entry
     */
    public void addMismatchedGLEntry(final Entry add) {
        if (mismatchedGLEntries == null) {
            mismatchedGLEntries = new ArrayList<>();
        }
        mismatchedGLEntries.add(add);
    }

    public Timestamp getStartTime() {
        return startTime;
    }

    public void setStartTime(final Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getLastExtractTime() {
        return lastExtractTime;
    }

    public void setLastExtractTime(final Timestamp lastExtractTime) {
        this.lastExtractTime = lastExtractTime;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(final boolean success) {
        this.success = success;
    }

    public Timestamp getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(final Timestamp finishTime) {
        this.finishTime = finishTime;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(final String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Integer getTotalGlCount() {
        return totalGlCount;
    }

    public void setTotalGlCount(final Integer totalGlCount) {
        this.totalGlCount = totalGlCount;
    }

    public Integer getNonPurApGlCount() {
        return nonPurApGlCount;
    }

    public void setNonPurApGlCount(final Integer nonPurApGlCount) {
        this.nonPurApGlCount = nonPurApGlCount;
    }

    public Integer getPurApGlCount() {
        return purApGlCount;
    }

    public void setPurApGlCount(final Integer purApGlCount) {
        this.purApGlCount = purApGlCount;
    }

    public String getStatusMessage() {
        if (statusMessage == null) {
            return success ? "Success" : errorMessage == null ? "" : errorMessage;
        }
        return statusMessage;
    }

    public void setStatusMessage(final String statusMessage) {
        this.statusMessage = statusMessage;
    }

}
