/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.sql.Date;

public class AssetComponent extends PersistableBusinessObjectBase implements MutableInactivatable {

    private Long capitalAssetNumber;
    private Integer componentNumber;
    private String componentDescription;
    private String componentContactPhoneNumber;
    private String componentConditionCode;
    private Integer componentEstimatedLifetimeLimit;
    private String componentManufacturerName;
    private String componentManufacturerModelNumber;
    private String componentSerialNumber;
    private String componentOrganizationTagNumber;
    private String componentOrganizationText;
    private KualiDecimal componentReplacementAmount;
    private String componentVendorName;
    private String componentWarrantyNumber;
    private String componentWarrantyPhoneNumber;
    private String componentWarrantyContactName;
    private String componentWarrantyPurchaseOrderNumber;
    private Date componentWarrantyBeginningDate;
    private Date componentWarrantyEndingDate;
    private String componentWarrantyText;
    private String governmentTagNumber;
    private String nationalStockNumber;
    private boolean active;

    private Asset asset;
    private AssetCondition componentCondition;

    public AssetComponent() {
    }

    public Long getCapitalAssetNumber() {
        return capitalAssetNumber;
    }

    public void setCapitalAssetNumber(final Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public Integer getComponentNumber() {
        return componentNumber;
    }

    public void setComponentNumber(final Integer componentNumber) {
        this.componentNumber = componentNumber;
    }

    public String getComponentDescription() {
        return componentDescription;
    }

    public void setComponentDescription(final String componentDescription) {
        this.componentDescription = componentDescription;
    }

    public String getComponentContactPhoneNumber() {
        return componentContactPhoneNumber;
    }

    public void setComponentContactPhoneNumber(final String componentContactPhoneNumber) {
        this.componentContactPhoneNumber = componentContactPhoneNumber;
    }

    public String getComponentConditionCode() {
        return componentConditionCode;
    }

    public void setComponentConditionCode(final String componentConditionCode) {
        this.componentConditionCode = componentConditionCode;
    }

    public Integer getComponentEstimatedLifetimeLimit() {
        return componentEstimatedLifetimeLimit;
    }

    public void setComponentEstimatedLifetimeLimit(final Integer componentEstimatedLifetimeLimit) {
        this.componentEstimatedLifetimeLimit = componentEstimatedLifetimeLimit;
    }

    public String getComponentManufacturerName() {
        return componentManufacturerName;
    }

    public void setComponentManufacturerName(final String componentManufacturerName) {
        this.componentManufacturerName = componentManufacturerName;
    }

    public String getComponentManufacturerModelNumber() {
        return componentManufacturerModelNumber;
    }

    public void setComponentManufacturerModelNumber(final String componentManufacturerModelNumber) {
        this.componentManufacturerModelNumber = componentManufacturerModelNumber;
    }

    public String getComponentSerialNumber() {
        return componentSerialNumber;
    }

    public void setComponentSerialNumber(final String componentSerialNumber) {
        this.componentSerialNumber = componentSerialNumber;
    }

    public String getComponentOrganizationTagNumber() {
        return componentOrganizationTagNumber;
    }

    public void setComponentOrganizationTagNumber(final String componentOrganizationTagNumber) {
        this.componentOrganizationTagNumber = componentOrganizationTagNumber;
    }

    public String getComponentOrganizationText() {
        return componentOrganizationText;
    }

    public void setComponentOrganizationText(final String componentOrganizationText) {
        this.componentOrganizationText = componentOrganizationText;
    }

    public KualiDecimal getComponentReplacementAmount() {
        return componentReplacementAmount;
    }

    public void setComponentReplacementAmount(final KualiDecimal componentReplacementAmount) {
        this.componentReplacementAmount = componentReplacementAmount;
    }

    public String getComponentVendorName() {
        return componentVendorName;
    }

    public void setComponentVendorName(final String componentVendorName) {
        this.componentVendorName = componentVendorName;
    }

    public String getComponentWarrantyNumber() {
        return componentWarrantyNumber;
    }

    public void setComponentWarrantyNumber(final String componentWarrantyNumber) {
        this.componentWarrantyNumber = componentWarrantyNumber;
    }

    public String getComponentWarrantyPhoneNumber() {
        return componentWarrantyPhoneNumber;
    }

    public void setComponentWarrantyPhoneNumber(final String componentWarrantyPhoneNumber) {
        this.componentWarrantyPhoneNumber = componentWarrantyPhoneNumber;
    }

    public String getComponentWarrantyContactName() {
        return componentWarrantyContactName;
    }

    public void setComponentWarrantyContactName(final String componentWarrantyContactName) {
        this.componentWarrantyContactName = componentWarrantyContactName;
    }

    public String getComponentWarrantyPurchaseOrderNumber() {
        return componentWarrantyPurchaseOrderNumber;
    }

    public void setComponentWarrantyPurchaseOrderNumber(final String componentWarrantyPurchaseOrderNumber) {
        this.componentWarrantyPurchaseOrderNumber = componentWarrantyPurchaseOrderNumber;
    }

    public Date getComponentWarrantyBeginningDate() {
        return componentWarrantyBeginningDate;
    }

    public void setComponentWarrantyBeginningDate(final Date componentWarrantyBeginningDate) {
        this.componentWarrantyBeginningDate = componentWarrantyBeginningDate;
    }

    public Date getComponentWarrantyEndingDate() {
        return componentWarrantyEndingDate;
    }

    public void setComponentWarrantyEndingDate(final Date componentWarrantyEndingDate) {
        this.componentWarrantyEndingDate = componentWarrantyEndingDate;
    }

    public String getComponentWarrantyText() {
        return componentWarrantyText;
    }

    public void setComponentWarrantyText(final String componentWarrantyText) {
        this.componentWarrantyText = componentWarrantyText;
    }

    public String getGovernmentTagNumber() {
        return governmentTagNumber;
    }

    public void setGovernmentTagNumber(final String governmentTagNumber) {
        this.governmentTagNumber = governmentTagNumber;
    }

    public String getNationalStockNumber() {
        return nationalStockNumber;
    }

    public void setNationalStockNumber(final String nationalStockNumber) {
        this.nationalStockNumber = nationalStockNumber;
    }

    public Asset getAsset() {
        return asset;
    }

    /**
     * @deprecated
     */
    public void setAsset(final Asset asset) {
        this.asset = asset;
    }

    public AssetCondition getComponentCondition() {
        return componentCondition;
    }

    /**
     * @deprecated
     */
    public void setComponentCondition(final AssetCondition componentCondition) {
        this.componentCondition = componentCondition;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(final boolean active) {
        this.active = active;
    }

}
