/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

public class AssetGlpeSourceDetail extends PersistableBusinessObjectBase implements
        GeneralLedgerPendingEntrySourceDetail {

    private String accountNumber;
    private KualiDecimal amount;
    private String balanceTypeCode;
    private String chartOfAccountsCode;
    private String documentNumber;
    private String financialDocumentLineDescription;
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String organizationReferenceId;
    private Integer postingYear;
    private String projectCode;
    private String referenceNumber;
    private String referenceOriginCode;
    private String referenceTypeCode;
    private String subAccountNumber;
    private boolean source;
    private boolean expense;
    private boolean capitalization;
    private boolean accumulatedDepreciation;
    private boolean capitalizationOffset;
    private boolean payment;
    private boolean paymentOffset;
    private Account account;
    private ObjectCode objectCode;
    private int sequenceNumber;
    private String postingPeriodCode;

    @Override
    public Account getAccount() {
        return account;
    }

    public void setAccount(final Account account) {
        this.account = account;
    }

    @Override
    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
    }

    @Override
    public KualiDecimal getAmount() {
        return amount;
    }

    public void setAmount(final KualiDecimal amount) {
        this.amount = amount;
    }

    @Override
    public String getBalanceTypeCode() {
        return balanceTypeCode;
    }

    public void setBalanceTypeCode(final String balanceTypeCode) {
        this.balanceTypeCode = balanceTypeCode;
    }

    @Override
    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    @Override
    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(final String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Override
    public String getFinancialDocumentLineDescription() {
        return financialDocumentLineDescription;
    }

    public void setFinancialDocumentLineDescription(final String financialDocumentLineDescription) {
        this.financialDocumentLineDescription = financialDocumentLineDescription;
    }

    @Override
    public String getFinancialObjectCode() {
        return financialObjectCode;
    }

    public void setFinancialObjectCode(final String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    @Override
    public String getFinancialSubObjectCode() {
        return financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(final String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    @Override
    public ObjectCode getObjectCode() {
        return objectCode;
    }

    public void setObjectCode(final ObjectCode objectCode) {
        this.objectCode = objectCode;
    }

    @Override
    public String getOrganizationReferenceId() {
        return organizationReferenceId;
    }

    public void setOrganizationReferenceId(final String organizationReferenceId) {
        this.organizationReferenceId = organizationReferenceId;
    }

    @Override
    public Integer getPostingYear() {
        return postingYear;
    }

    public void setPostingYear(final Integer postingYear) {
        this.postingYear = postingYear;
    }

    @Override
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(final String projectCode) {
        this.projectCode = projectCode;
    }

    @Override
    public String getReferenceNumber() {
        return referenceNumber;
    }

    public void setReferenceNumber(final String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public String getReferenceOriginCode() {
        return referenceOriginCode;
    }

    public void setReferenceOriginCode(final String referenceOriginCode) {
        this.referenceOriginCode = referenceOriginCode;
    }

    @Override
    public String getReferenceTypeCode() {
        return referenceTypeCode;
    }

    public void setReferenceTypeCode(final String referenceTypeCode) {
        this.referenceTypeCode = referenceTypeCode;
    }

    @Override
    public String getSubAccountNumber() {
        return subAccountNumber;
    }

    public void setSubAccountNumber(final String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public boolean isSource() {
        return source;
    }

    public void setSource(final boolean source) {
        this.source = source;
    }

    public boolean isExpense() {
        return expense;
    }

    public void setExpense(final boolean expense) {
        this.expense = expense;
    }

    public boolean isCapitalization() {
        return capitalization;
    }

    public void setCapitalization(final boolean capitalization) {
        this.capitalization = capitalization;
    }

    public boolean isAccumulatedDepreciation() {
        return accumulatedDepreciation;
    }

    public void setAccumulatedDepreciation(final boolean accumulatedDepreciation) {
        this.accumulatedDepreciation = accumulatedDepreciation;
    }

    public void setCapitalizationOffset(final boolean b) {
        capitalizationOffset = b;

    }

    public boolean isCapitalizationOffset() {
        return capitalizationOffset;
    }

    public boolean isPayment() {
        return payment;
    }

    public void setPayment(final boolean payment) {
        this.payment = payment;
    }

    public boolean isPaymentOffset() {
        return paymentOffset;
    }

    public void setPaymentOffset(final boolean paymentOffset) {
        this.paymentOffset = paymentOffset;
    }

    /**
     * We have to return from this method directly since this is not a real persistent class and if we call super, it
     * will run into "Class not found in OJB repository" exception.
     */
    @Override
    public void refresh() {
        // prevent call to super
    }

    /**
     * We have to return from this method directly since this is not a real persistent class and if we call super, it
     * will run into "Class not found in OJB repository" exception.
     */
    @Override
    public void refreshNonUpdateableReferences() {
        // prevent call to super
    }

    /**
     * We have to return from this method directly since this is not a real persistent class and if we call super, it
     * will run into "Class not found in OJB repository" exception.
     */
    @Override
    public void refreshReferenceObject(final String referenceObjectName) {
        // prevent call to super
    }

    public int getSequenceNumber() {
        return sequenceNumber;
    }

    public void setSequenceNumber(final int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getPostingPeriodCode() {
        return postingPeriodCode;
    }

    public void setPostingPeriodCode(final String postingPeriodCode) {
        this.postingPeriodCode = postingPeriodCode;
    }

}
