/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.sys.businessobject.PostalCode;
import org.kuali.kfs.sys.businessobject.State;

public class AssetLocation extends PersistableBusinessObjectBase {

    protected Long capitalAssetNumber;
    protected String assetLocationTypeCode;
    protected String assetLocationContactName;
    protected String assetLocationContactIdentifier;
    protected String assetLocationInstitutionName;
    protected String assetLocationPhoneNumber;
    protected String assetLocationStreetAddress;
    protected String assetLocationCityName;
    protected String assetLocationStateCode;
    protected String assetLocationCountryCode;
    protected String assetLocationZipCode;

    protected Asset asset;

    protected Country assetLocationCountry;
    protected State assetLocationState;
    protected PostalCode postalZipCode;

    public AssetLocation() {

    }

    public AssetLocation(final Long assetNumber) {
        capitalAssetNumber = assetNumber;
    }

    public AssetLocation(final AssetLocation copiedLocation) {
        capitalAssetNumber = copiedLocation.getCapitalAssetNumber();
        assetLocationTypeCode = copiedLocation.getAssetLocationTypeCode();
        assetLocationContactName = copiedLocation.getAssetLocationContactName();
        assetLocationContactIdentifier = copiedLocation.getAssetLocationContactIdentifier();
        assetLocationInstitutionName = copiedLocation.getAssetLocationInstitutionName();
        assetLocationPhoneNumber = copiedLocation.getAssetLocationPhoneNumber();
        assetLocationStreetAddress = copiedLocation.getAssetLocationStreetAddress();
        assetLocationCityName = copiedLocation.getAssetLocationCityName();
        assetLocationStateCode = copiedLocation.getAssetLocationStateCode();
        assetLocationCountryCode = copiedLocation.getAssetLocationCountryCode();
        assetLocationZipCode = copiedLocation.getAssetLocationZipCode();
    }

    public Long getCapitalAssetNumber() {
        return capitalAssetNumber;
    }

    public void setCapitalAssetNumber(final Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public String getAssetLocationTypeCode() {
        return assetLocationTypeCode;
    }

    public void setAssetLocationTypeCode(final String assetLocationTypeCode) {
        this.assetLocationTypeCode = assetLocationTypeCode;
    }

    public String getAssetLocationContactName() {
        return assetLocationContactName;
    }

    public void setAssetLocationContactName(final String assetLocationContactName) {
        this.assetLocationContactName = assetLocationContactName;
    }

    public String getAssetLocationContactIdentifier() {
        return assetLocationContactIdentifier;
    }

    public void setAssetLocationContactIdentifier(final String assetLocationContactIdentifier) {
        this.assetLocationContactIdentifier = assetLocationContactIdentifier;
    }

    public String getAssetLocationInstitutionName() {
        return assetLocationInstitutionName;
    }

    public void setAssetLocationInstitutionName(final String assetLocationInstitutionName) {
        this.assetLocationInstitutionName = assetLocationInstitutionName;
    }

    public String getAssetLocationPhoneNumber() {
        return assetLocationPhoneNumber;
    }

    public void setAssetLocationPhoneNumber(final String assetLocationPhoneNumber) {
        this.assetLocationPhoneNumber = assetLocationPhoneNumber;
    }

    public String getAssetLocationStreetAddress() {
        return assetLocationStreetAddress;
    }

    public void setAssetLocationStreetAddress(final String assetLocationStreetAddress) {
        this.assetLocationStreetAddress = assetLocationStreetAddress;
    }

    public String getAssetLocationCityName() {
        return assetLocationCityName;
    }

    public void setAssetLocationCityName(final String assetLocationCityName) {
        this.assetLocationCityName = assetLocationCityName;
    }

    public String getAssetLocationStateCode() {
        return assetLocationStateCode;
    }

    public void setAssetLocationStateCode(final String assetLocationStateCode) {
        this.assetLocationStateCode = assetLocationStateCode;
    }

    public String getAssetLocationCountryCode() {
        return assetLocationCountryCode;
    }

    public void setAssetLocationCountryCode(final String assetLocationCountryCode) {
        this.assetLocationCountryCode = assetLocationCountryCode;
    }

    public String getAssetLocationZipCode() {
        return assetLocationZipCode;
    }

    public void setAssetLocationZipCode(final String assetLocationZipCode) {
        this.assetLocationZipCode = assetLocationZipCode;
    }

    public PostalCode getPostalZipCode() {
        return postalZipCode;
    }

    public void setPostalZipCode(final PostalCode postalZipCode) {
        this.postalZipCode = postalZipCode;
    }

    public Asset getAsset() {
        return asset;
    }

    /**
     * @deprecated
     */
    public void setAsset(final Asset asset) {
        this.asset = asset;
    }

    public Country getAssetLocationCountry() {
        return assetLocationCountry;
    }

    public void setAssetLocationCountry(final Country assetLocationCountry) {
        this.assetLocationCountry = assetLocationCountry;
    }

    public State getAssetLocationState() {
        return assetLocationState;
    }

    public void setAssetLocationState(final State assetLocationState) {
        this.assetLocationState = assetLocationState;
    }
}
