/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.integration.cam.CapitalAssetManagementAssetType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;

public class AssetType extends PersistableBusinessObjectBase implements CapitalAssetManagementAssetType,
        MutableInactivatable {

    private String capitalAssetTypeCode;
    private String capitalAssetTypeDescription;
    private Integer depreciableLifeLimit;
    private boolean movingIndicator;
    private boolean requiredBuildingIndicator;
    private boolean active;

    public AssetType() {

    }

    @Override
    public String getCapitalAssetTypeCode() {
        return capitalAssetTypeCode;
    }

    public void setCapitalAssetTypeCode(final String capitalAssetTypeCode) {
        this.capitalAssetTypeCode = capitalAssetTypeCode;
    }

    @Override
    public String getCapitalAssetTypeDescription() {
        return capitalAssetTypeDescription;
    }

    public void setCapitalAssetTypeDescription(final String capitalAssetTypeDescription) {
        this.capitalAssetTypeDescription = capitalAssetTypeDescription;
    }

    public Integer getDepreciableLifeLimit() {
        return depreciableLifeLimit;
    }

    public void setDepreciableLifeLimit(final Integer depreciableLifeLimit) {
        this.depreciableLifeLimit = depreciableLifeLimit;
    }

    public boolean isMovingIndicator() {
        return movingIndicator;
    }

    public void setMovingIndicator(final boolean movingIndicator) {
        this.movingIndicator = movingIndicator;
    }

    public boolean isRequiredBuildingIndicator() {
        return requiredBuildingIndicator;
    }

    public void setRequiredBuildingIndicator(final boolean requiredBuildingIndicator) {
        this.requiredBuildingIndicator = requiredBuildingIndicator;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(final boolean active) {
        this.active = active;
    }

}
