/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;

import java.sql.Date;

public class AssetWarranty extends PersistableBusinessObjectBase implements MutableInactivatable {

    private Long capitalAssetNumber;
    private String warrantyContactName;
    private String warrantyPhoneNumber;
    private Date warrantyBeginningDate;
    private Date warrantyEndingDate;
    private String warrantyNumber;
    private String warrantyPurchaseOrderNumber;
    private String warrantyText;
    private boolean active;

    private Asset asset;

    public AssetWarranty() {

    }

    public Long getCapitalAssetNumber() {
        return capitalAssetNumber;
    }

    public void setCapitalAssetNumber(final Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public String getWarrantyContactName() {
        return warrantyContactName;
    }

    public void setWarrantyContactName(final String warrantyContactName) {
        this.warrantyContactName = warrantyContactName;
    }

    public String getWarrantyPhoneNumber() {
        return warrantyPhoneNumber;
    }

    public void setWarrantyPhoneNumber(final String warrantyPhoneNumber) {
        this.warrantyPhoneNumber = warrantyPhoneNumber;
    }

    public Date getWarrantyBeginningDate() {
        return warrantyBeginningDate;
    }

    public void setWarrantyBeginningDate(final Date warrantyBeginningDate) {
        this.warrantyBeginningDate = warrantyBeginningDate;
    }

    public Date getWarrantyEndingDate() {
        return warrantyEndingDate;
    }

    public void setWarrantyEndingDate(final Date warrantyEndingDate) {
        this.warrantyEndingDate = warrantyEndingDate;
    }

    public String getWarrantyNumber() {
        return warrantyNumber;
    }

    public void setWarrantyNumber(final String warrantyNumber) {
        this.warrantyNumber = warrantyNumber;
    }

    public String getWarrantyPurchaseOrderNumber() {
        return warrantyPurchaseOrderNumber;
    }

    public void setWarrantyPurchaseOrderNumber(final String warrantyPurchaseOrderNumber) {
        this.warrantyPurchaseOrderNumber = warrantyPurchaseOrderNumber;
    }

    public String getWarrantyText() {
        return warrantyText;
    }

    public void setWarrantyText(final String warrantyText) {
        this.warrantyText = warrantyText;
    }

    public Asset getAsset() {
        return asset;
    }

    /**
     * @deprecated
     */
    public void setAsset(final Asset asset) {
        this.asset = asset;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(final boolean active) {
        this.active = active;
    }

}
