/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;

/**
 * Value object to carry the system parameters associated with CAB Batch
 */
public class BatchParameters {

    protected Timestamp lastRunTime;
    protected Date lastRunDate;
    protected Collection<String> excludedChartCodes;
    protected Collection<String> excludedSubFundCodes;
    protected Collection<String> includedFinancialBalanceTypeCodes;
    protected Collection<String> excludedFiscalPeriods;
    protected Collection<String> excludedDocTypeCodes;
    protected Collection<String> includedFinancialObjectSubTypeCodes;
    protected BigDecimal capitalizationLimitAmount;

    public Timestamp getLastRunTime() {
        return lastRunTime;
    }

    public void setLastRunTime(final Timestamp lastRunTime) {
        this.lastRunTime = lastRunTime;
    }

    public Collection<String> getExcludedChartCodes() {
        return excludedChartCodes;
    }

    public void setExcludedChartCodes(final Collection<String> excludedChartCodes) {
        this.excludedChartCodes = excludedChartCodes;
    }

    public Collection<String> getExcludedSubFundCodes() {
        return excludedSubFundCodes;
    }

    public void setExcludedSubFundCodes(final Collection<String> excludedSubFundCodes) {
        this.excludedSubFundCodes = excludedSubFundCodes;
    }

    public Collection<String> getIncludedFinancialBalanceTypeCodes() {
        return includedFinancialBalanceTypeCodes;
    }

    public void setIncludedFinancialBalanceTypeCodes(final Collection<String> includeFinancialBalanceTypeCodes) {
        includedFinancialBalanceTypeCodes = includeFinancialBalanceTypeCodes;
    }

    public Collection<String> getExcludedFiscalPeriods() {
        return excludedFiscalPeriods;
    }

    public void setExcludedFiscalPeriods(final Collection<String> excludeFiscalPeriods) {
        excludedFiscalPeriods = excludeFiscalPeriods;
    }

    public Collection<String> getExcludedDocTypeCodes() {
        return excludedDocTypeCodes;
    }

    public void setExcludedDocTypeCodes(final Collection<String> excludedDocTypeCodes) {
        this.excludedDocTypeCodes = excludedDocTypeCodes;
    }

    public Collection<String> getIncludedFinancialObjectSubTypeCodes() {
        return includedFinancialObjectSubTypeCodes;
    }

    public void setIncludedFinancialObjectSubTypeCodes(final Collection<String> includedFinancialObjectSubTypeCodes) {
        this.includedFinancialObjectSubTypeCodes = includedFinancialObjectSubTypeCodes;
    }

    public BigDecimal getCapitalizationLimitAmount() {
        return capitalizationLimitAmount;
    }

    public void setCapitalizationLimitAmount(final BigDecimal capitalizationLimitAmount) {
        this.capitalizationLimitAmount = capitalizationLimitAmount;
    }

    public Date getLastRunDate() {
        return lastRunDate;
    }

    public void setLastRunDate(final Date lastRunDate) {
        this.lastRunDate = lastRunDate;
    }
}
