/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Campus;
import org.kuali.kfs.sys.businessobject.Room;

import java.sql.Date;

public class PretagDetail extends PersistableBusinessObjectBase {

    private String purchaseOrderNumber;
    private Integer itemLineNumber;
    private String campusTagNumber;
    private String serialNumber;
    private String organizationTagNumber;
    private String campusCode;
    private String buildingCode;
    private String buildingRoomNumber;
    private String buildingSubRoomNumber;
    private Date pretagTagCreateDate;
    private String governmentTagNumber;
    private String nationalStockNumber;
    private boolean active;

    protected Campus campus;
    private Building building;
    private Room buildingRoom;

    public PretagDetail() {

    }

    public String getPurchaseOrderNumber() {
        return purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(final String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public Integer getItemLineNumber() {
        return itemLineNumber;
    }

    public void setItemLineNumber(final Integer itemLineNumber) {
        this.itemLineNumber = itemLineNumber;
    }

    public String getCampusTagNumber() {
        return campusTagNumber;
    }

    public void setCampusTagNumber(final String campusTagNumber) {
        this.campusTagNumber = campusTagNumber;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(final String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getOrganizationTagNumber() {
        return organizationTagNumber;
    }

    public void setOrganizationTagNumber(final String organizationTagNumber) {
        this.organizationTagNumber = organizationTagNumber;
    }

    public String getCampusCode() {
        return campusCode;
    }

    public void setCampusCode(final String campusCode) {
        this.campusCode = campusCode;
    }

    public String getBuildingCode() {
        return buildingCode;
    }

    public void setBuildingCode(final String buildingCode) {
        this.buildingCode = buildingCode;
    }

    public String getBuildingRoomNumber() {
        return buildingRoomNumber;
    }

    public void setBuildingRoomNumber(final String buildingRoomNumber) {
        this.buildingRoomNumber = buildingRoomNumber;
    }

    public String getBuildingSubRoomNumber() {
        return buildingSubRoomNumber;
    }

    public void setBuildingSubRoomNumber(final String buildingSubRoomNumber) {
        this.buildingSubRoomNumber = buildingSubRoomNumber;
    }

    public Date getPretagTagCreateDate() {
        return pretagTagCreateDate;
    }

    public void setPretagTagCreateDate(final Date pretagTagCreateDate) {
        this.pretagTagCreateDate = pretagTagCreateDate;
    }

    public String getGovernmentTagNumber() {
        return governmentTagNumber;
    }

    public void setGovernmentTagNumber(final String governmentTagNumber) {
        this.governmentTagNumber = governmentTagNumber;
    }

    public String getNationalStockNumber() {
        return nationalStockNumber;
    }

    public void setNationalStockNumber(final String nationalStockNumber) {
        this.nationalStockNumber = nationalStockNumber;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(final boolean active) {
        this.active = active;
    }

    public Campus getCampus() {
        return campus;
    }

    /**
     * @deprecated
     */
    public void setCampus(final Campus campus) {
        this.campus = campus;
    }

    public Building getBuilding() {
        return building;
    }

    /**
     * @deprecated
     */
    public void setBuilding(final Building building) {
        this.building = building;
    }

    public Room getBuildingRoom() {
        return buildingRoom;
    }

    /**
     * @deprecated
     */
    public void setBuildingRoom(final Room buildingRoom) {
        this.buildingRoom = buildingRoom;
    }

}
