/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.document;

import org.kuali.kfs.module.cam.CamsConstants;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;

import java.util.ArrayList;
import java.util.List;

public class BarcodeInventoryErrorDocument extends FinancialSystemTransactionalDocumentBase {

    protected String documentNumber;
    protected String uploaderUniversalIdentifier;

    //global replace - search fields
    //*** Old values **************
    protected String currentTagNumber;
    protected String currentScanCode;
    protected String currentCampusCode;
    protected String currentBuildingNumber;
    protected String currentRoom;
    protected String currentSubroom;
    protected String currentConditionCode;

    //*** New values **************
    protected String newTagNumber;
    protected String newScanCode;
    protected String newCampusCode;
    protected String newBuildingNumber;
    protected String newRoom;
    protected String newSubroom;
    protected String newConditionCode;

    protected List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetail;

    public BarcodeInventoryErrorDocument() {
        super();
        setBarcodeInventoryErrorDetail(new ArrayList<>());
    }

    @Override
    public String getDocumentNumber() {
        return documentNumber;
    }

    @Override
    public void setDocumentNumber(final String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getUploaderUniversalIdentifier() {
        return uploaderUniversalIdentifier;
    }

    public void setUploaderUniversalIdentifier(final String uploaderUniversalIdentifier) {
        this.uploaderUniversalIdentifier = uploaderUniversalIdentifier;
    }

    public List<BarcodeInventoryErrorDetail> getBarcodeInventoryErrorDetail() {
        return barcodeInventoryErrorDetail;
    }

    public void setBarcodeInventoryErrorDetail(final List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails) {
        barcodeInventoryErrorDetail = barcodeInventoryErrorDetails;
    }

    /**
     * Determines the document had all its records corrected
     *
     * @return boolean
     */
    public boolean isDocumentCorrected() {
        for (final BarcodeInventoryErrorDetail detail : getBarcodeInventoryErrorDetail()) {
            if (detail.getErrorCorrectionStatusCode().equals(CamsConstants.BarCodeInventoryError.STATUS_CODE_ERROR)) {
                return false;
            }
        }
        return true;
    }

    public String getCurrentTagNumber() {
        return currentTagNumber;
    }

    public void setCurrentTagNumber(final String currentTagNumber) {
        this.currentTagNumber = currentTagNumber;
    }

    public String getCurrentScanCode() {
        return currentScanCode;
    }

    public void setCurrentScanCode(final String currentScanCode) {
        this.currentScanCode = currentScanCode;
    }

    public String getCurrentCampusCode() {
        return currentCampusCode;
    }

    public void setCurrentCampusCode(final String currentCampusCode) {
        this.currentCampusCode = currentCampusCode;
    }

    public String getCurrentBuildingNumber() {
        return currentBuildingNumber;
    }

    public void setCurrentBuildingNumber(final String currentBuildingNumber) {
        this.currentBuildingNumber = currentBuildingNumber;
    }

    public String getCurrentRoom() {
        return currentRoom;
    }

    public void setCurrentRoom(final String currentRoom) {
        this.currentRoom = currentRoom;
    }

    public String getCurrentSubroom() {
        return currentSubroom;
    }

    public void setCurrentSubroom(final String currentSubroom) {
        this.currentSubroom = currentSubroom;
    }

    public String getCurrentConditionCode() {
        return currentConditionCode;
    }

    public void setCurrentConditionCode(final String currentConditionCode) {
        this.currentConditionCode = currentConditionCode;
    }

    public String getNewTagNumber() {
        return newTagNumber;
    }

    public void setNewTagNumber(final String newTagNumber) {
        this.newTagNumber = newTagNumber;
    }

    public String getNewScanCode() {
        return newScanCode;
    }

    public void setNewScanCode(final String newScanCode) {
        this.newScanCode = newScanCode;
    }

    public String getNewCampusCode() {
        return newCampusCode;
    }

    public void setNewCampusCode(final String newCampusCode) {
        this.newCampusCode = newCampusCode;
    }

    public String getNewBuildingNumber() {
        return newBuildingNumber;
    }

    public void setNewBuildingNumber(final String newBuildingNumber) {
        this.newBuildingNumber = newBuildingNumber;
    }

    public String getNewRoom() {
        return newRoom;
    }

    public void setNewRoom(final String newRoom) {
        this.newRoom = newRoom;
    }

    public String getNewSubroom() {
        return newSubroom;
    }

    public void setNewSubroom(final String newSubroom) {
        this.newSubroom = newSubroom;
    }

    public String getNewConditionCode() {
        return newConditionCode;
    }

    public void setNewConditionCode(final String newConditionCode) {
        this.newConditionCode = newConditionCode;
    }

    public void resetSearchFields() {
        currentTagNumber = "";
        currentScanCode = "";
        currentCampusCode = "";
        currentBuildingNumber = "";
        currentRoom = "";
        currentSubroom = "";
        currentConditionCode = "";
        newTagNumber = "";
        newScanCode = "";
        newCampusCode = "";
        newBuildingNumber = "";
        newRoom = "";
        newSubroom = "";
        newConditionCode = "";
    }
}
