/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.web.struts;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.KRADConstants;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.CamsConstants;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.document.service.GlAndPurApHelperService;
import org.kuali.kfs.module.cam.document.service.PurApInfoService;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.sys.context.SpringContext;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

public class PurApLineForm extends KualiForm {

    private Integer purchaseOrderIdentifier;
    private String purApContactEmailAddress;
    private String purApContactPhoneNumber;

    private List<PurchasingAccountsPayableDocument> purApDocs;
    private int actionPurApDocIndex;
    private int actionItemAssetIndex;

    private KualiDecimal mergeQty;
    private String mergeDesc;

    private Integer requisitionIdentifier;

    private String purchaseOrderInquiryUrl;

    private boolean selectAll;

    private String documentNumber;

    public PurApLineForm() {
        purApDocs = new ArrayList<>();
    }

    @Override
    public boolean shouldMethodToCallParameterBeUsed(final String methodToCallParameterName, final String methodToCallParameterValue, final HttpServletRequest request) {
        if (StringUtils.equals(methodToCallParameterName, KRADConstants.DISPATCH_REQUEST_PARAMETER) && StringUtils.equals(methodToCallParameterValue, CamsConstants.Actions.START)) {
            return true;
        }
        return super.shouldMethodToCallParameterBeUsed(methodToCallParameterName, methodToCallParameterValue, request);
    }

    @Override
    public void addRequiredNonEditableProperties() {
        super.addRequiredNonEditableProperties();
        registerRequiredNonEditableProperty(CamsPropertyConstants.PurchasingAccountsPayableDocument.PURCHASE_ORDER_IDENTIFIER);
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(final String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getRequisitionIdentifier() {
        return requisitionIdentifier;
    }

    public void setRequisitionIdentifier(final Integer requisitionIdentifier) {
        this.requisitionIdentifier = requisitionIdentifier;
    }

    public KualiDecimal getMergeQty() {
        return mergeQty;
    }

    public void setMergeQty(final KualiDecimal mergeQty) {
        this.mergeQty = mergeQty;
    }

    public String getMergeDesc() {
        return mergeDesc;
    }

    public void setMergeDesc(final String mergeDesc) {
        this.mergeDesc = mergeDesc;
    }

    public String getPurApContactEmailAddress() {
        return purApContactEmailAddress;
    }

    public void setPurApContactEmailAddress(final String purApContactEmailAddress) {
        this.purApContactEmailAddress = purApContactEmailAddress;
    }

    public String getPurApContactPhoneNumber() {
        return purApContactPhoneNumber;
    }

    public void setPurApContactPhoneNumber(final String purApContactPhoneNumber) {
        this.purApContactPhoneNumber = purApContactPhoneNumber;
    }

    public int getActionPurApDocIndex() {
        return actionPurApDocIndex;
    }

    public void setActionPurApDocIndex(final int actionPurApDocIndex) {
        this.actionPurApDocIndex = actionPurApDocIndex;
    }

    public int getActionItemAssetIndex() {
        return actionItemAssetIndex;
    }

    public void setActionItemAssetIndex(final int actionItemAssetIndex) {
        this.actionItemAssetIndex = actionItemAssetIndex;
    }

    public Integer getPurchaseOrderIdentifier() {
        return purchaseOrderIdentifier;
    }

    public void setPurchaseOrderIdentifier(final Integer purchaseOrderIdentifier) {
        this.purchaseOrderIdentifier = purchaseOrderIdentifier;
    }

    public List<PurchasingAccountsPayableDocument> getPurApDocs() {
        return purApDocs;
    }

    public void setPurApDocs(final List<PurchasingAccountsPayableDocument> purApDocs) {
        this.purApDocs = purApDocs;
    }

    public String getPurchaseOrderInquiryUrl() {
        return purchaseOrderInquiryUrl;
    }

    @Override
    public void populate(final HttpServletRequest request) {
        super.populate(request);

        final String parameterName = (String) request.getAttribute(KRADConstants.METHOD_TO_CALL_ATTRIBUTE);
        if (StringUtils.isNotBlank(parameterName)) {
            // populate collection index
            final String purApDocIndex = StringUtils.substringBetween(parameterName, CamsConstants.DOT_DOC, ".");
            if (StringUtils.isNotBlank(purApDocIndex)) {
                setActionPurApDocIndex(Integer.parseInt(purApDocIndex));
            }
            final String itemAssetIndex = StringUtils.substringBetween(parameterName, CamsConstants.DOT_LINE, ".");
            if (StringUtils.isNotBlank(itemAssetIndex)) {
                setActionItemAssetIndex(Integer.parseInt(itemAssetIndex));
            }
        }

        if (purchaseOrderIdentifier != null) {
            final PurchaseOrderDocument poDoc = getPurApInfoService().getCurrentDocumentForPurchaseOrderIdentifier(
                    purchaseOrderIdentifier);
            if (ObjectUtils.isNotNull(poDoc) && StringUtils.isNotBlank(poDoc.getDocumentNumber())) {
                purchaseOrderInquiryUrl = "purapPurchaseOrder.do?methodToCall=docHandler&docId=" + poDoc.getDocumentNumber() + "&command=displayDocSearchView";
            }
        }

        // clear up the documentNumber saved when submit CAMS doc
        setDocumentNumber(null);
    }

    private PurApInfoService getPurApInfoService() {
        return SpringContext.getBean(PurApInfoService.class);
    }

    public boolean isSelectAll() {
        return selectAll;
    }

    public void setSelectAll(final boolean selectAll) {
        this.selectAll = selectAll;
    }

    /**
     * Return Asset Global forwarding URL.
     *
     * @return
     */
    public String getDocHandlerForwardLink() {
        String docHandlerLink = "";
        if (StringUtils.isNotBlank(documentNumber)) {
            final String docTypeName = SpringContext.getBean(DocumentService.class).getByDocumentHeaderId(documentNumber).getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
            docHandlerLink = SpringContext.getBean(GlAndPurApHelperService.class).getDocHandlerUrl(documentNumber, docTypeName);
        }
        return docHandlerLink;
    }

    public PurchasingAccountsPayableDocument getPurApDoc(final int index) {
        int size = getPurApDocs().size();
        while (size <= index || getPurApDocs().get(index) == null) {
            getPurApDocs().add(size++, new PurchasingAccountsPayableDocument());
        }
        return getPurApDocs().get(index);

    }
}
