/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.batch;

import org.kuali.kfs.gl.businessobject.Entry;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExtractProcessLog {
    private Timestamp startTime;
    private Timestamp finishTime;
    private Timestamp lastExtractTime;
    private List<Entry> ignoredGLEntries;
    private List<Entry> duplicateGLEntries;
    private List<Entry> mismatchedGLEntries;
    private String errorMessage;
    private boolean success = true;
    private Integer totalGlCount = 0;
    private Integer nonPurApGlCount = 0;
    private Integer purApGlCount = 0;
    private String statusMessage;

    /**
     * Gets the ignoredGLEntries attribute.
     *
     * @return Returns the ignoredGLEntries.
     */
    public List<Entry> getIgnoredGLEntries() {
        return ignoredGLEntries;
    }

    /**
     * Sets the ignoredGLEntries attribute value.
     *
     * @param ignoredGLEntries The ignoredGLEntries to set.
     */
    public void setIgnoredGLEntries(List<Entry> ignoredGLEntries) {
        this.ignoredGLEntries = ignoredGLEntries;
    }

    /**
     * Gets the duplicateGLEntries attribute.
     *
     * @return Returns the duplicateGLEntries.
     */
    public List<Entry> getDuplicateGLEntries() {
        return duplicateGLEntries;
    }

    /**
     * Sets the duplicateGLEntries attribute value.
     *
     * @param duplicateGLEntries The duplicateGLEntries to set.
     */
    public void setDuplicateGLEntries(List<Entry> duplicateGLEntries) {
        this.duplicateGLEntries = duplicateGLEntries;
    }

    /**
     * Gets the mismatchedGLEntries attribute.
     *
     * @return Returns the mismatchedGLEntries.
     */
    public List<Entry> getMismatchedGLEntries() {
        return mismatchedGLEntries;
    }

    /**
     * Sets the mismatchedGLEntries attribute value.
     *
     * @param mismatchedGLEntries The mismatchedGLEntries to set.
     */
    public void setMismatchedGLEntries(List<Entry> mismatchedGLEntries) {
        this.mismatchedGLEntries = mismatchedGLEntries;
    }

    /**
     * Adds a collection of entries to ignoredGLEntries
     *
     * @param add ignoredGLEntries
     */
    public void addIgnoredGLEntries(Collection<Entry> add) {
        if (this.ignoredGLEntries == null) {
            this.ignoredGLEntries = new ArrayList<>();
        }
        this.ignoredGLEntries.addAll(add);
    }

    /**
     * Adds a collection of entries to duplicateGLEntries
     *
     * @param add duplicateGLEntries
     */
    public void addDuplicateGLEntries(Collection<Entry> add) {
        if (this.duplicateGLEntries == null) {
            this.duplicateGLEntries = new ArrayList<>();
        }
        this.duplicateGLEntries.addAll(add);
    }

    /**
     * Adds a collection of entries to mismatchedGLEntries
     *
     * @param add mismatchedGLEntries
     */
    public void addMismatchedGLEntries(Collection<Entry> add) {
        if (this.mismatchedGLEntries == null) {
            this.mismatchedGLEntries = new ArrayList<>();
        }
        this.mismatchedGLEntries.addAll(add);
    }

    /**
     * Add a GL entry to ignoredGLEntries
     *
     * @param add Entry
     */
    public void addIgnoredGLEntry(Entry add) {
        if (this.ignoredGLEntries == null) {
            this.ignoredGLEntries = new ArrayList<>();
        }
        this.ignoredGLEntries.add(add);
    }

    /**
     * Add a GL entry to duplicateGLEntries
     *
     * @param add Entry
     */
    public void addDuplicateGLEntry(Entry add) {
        if (this.duplicateGLEntries == null) {
            this.duplicateGLEntries = new ArrayList<>();
        }
        this.duplicateGLEntries.add(add);
    }

    /**
     * Add a GL entry to mismatchedGLEntries
     *
     * @param add Entry
     */
    public void addMismatchedGLEntry(Entry add) {
        if (this.mismatchedGLEntries == null) {
            this.mismatchedGLEntries = new ArrayList<>();
        }
        this.mismatchedGLEntries.add(add);
    }

    public Timestamp getStartTime() {
        return startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getLastExtractTime() {
        return lastExtractTime;
    }

    public void setLastExtractTime(Timestamp lastExtractTime) {
        this.lastExtractTime = lastExtractTime;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Timestamp getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Timestamp finishTime) {
        this.finishTime = finishTime;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Integer getTotalGlCount() {
        return totalGlCount;
    }

    public void setTotalGlCount(Integer totalGlCount) {
        this.totalGlCount = totalGlCount;
    }

    public Integer getNonPurApGlCount() {
        return nonPurApGlCount;
    }

    public void setNonPurApGlCount(Integer nonPurApGlCount) {
        this.nonPurApGlCount = nonPurApGlCount;
    }

    public Integer getPurApGlCount() {
        return purApGlCount;
    }

    public void setPurApGlCount(Integer purApGlCount) {
        this.purApGlCount = purApGlCount;
    }

    public String getStatusMessage() {
        if (this.statusMessage == null) {
            return success ? "Success" : this.errorMessage == null ? "" : this.errorMessage;
        }
        return statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

}
