/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.gl.service.impl.StringHelper;
import org.kuali.kfs.kew.api.exception.WorkflowException;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.batch.service.AssetBarcodeInventoryLoadService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.BarcodeInventoryErrorDocument;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.validation.event.ValidateBarcodeInventoryEvent;
import org.kuali.kfs.module.cam.document.web.struts.AssetBarCodeInventoryInputFileForm;

public class AssetBarcodeInventoryLoadServiceImpl
implements AssetBarcodeInventoryLoadService {
    private static final Logger LOG = LogManager.getLogger();
    public static final String MESSAGE_NO_DOCUMENT_CREATED = "NO barcode inventory error document was created.";
    public static final String DOCUMENTS_MSG = "The following barcode inventory error document were created";
    public static final String TOTAL_RECORDS_UPLOADED_MSG = "Total records uploaded";
    public static final String TOTAL_RECORDS_IN_ERROR_MSG = "Total records in error";
    protected static final int MAX_NUMBER_OF_COLUMNS = 8;
    protected static final String DOCUMENT_EXPLANATION = "BARCODE ERROR INVENTORY";
    protected BusinessObjectService businessObjectService;
    protected DataDictionaryService dataDictionaryService;
    protected KualiRuleService kualiRuleService;
    protected DocumentService documentService;
    protected ParameterService parameterService;
    protected DateTimeService dateTimeService;
    protected AssetService assetService;

    @Override
    public boolean isFullyProcessed(Document document) {
        LOG.debug("isFullyProcessed() started");
        BarcodeInventoryErrorDocument barcodeInventoryErrorDocument = (BarcodeInventoryErrorDocument)document;
        boolean result = true;
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = barcodeInventoryErrorDocument.getBarcodeInventoryErrorDetail();
        for (BarcodeInventoryErrorDetail detail : barcodeInventoryErrorDetails) {
            if (!detail.getErrorCorrectionStatusCode().equals("E")) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public boolean isCurrentUserInitiator(Document document) {
        LOG.debug("isCurrentUserInitiator() started");
        if (document != null) {
            return GlobalVariables.getUserSession().getPerson().getPrincipalId().equalsIgnoreCase(document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        }
        return false;
    }

    @Override
    public boolean isFileFormatValid(File file) {
        LOG.debug("isFileFormatValid(File file) - start");
        String fileName = file.getName();
        BufferedReader input = null;
        Integer campusTagNumberMaxLength = this.dataDictionaryService.getAttributeMaxLength(Asset.class, "campusTagNumber");
        int inventoryScannedCodeMaxLength = 1;
        Integer InventoryDateMaxLength = this.dataDictionaryService.getAttributeMaxLength(BarcodeInventoryErrorDetail.class, CamsPropertyConstants.BarcodeInventory.INVENTORY_DATE);
        Integer campusCodeMaxLength = this.dataDictionaryService.getAttributeMaxLength(Asset.class, "campusCode");
        Integer buildingCodeMaxLength = this.dataDictionaryService.getAttributeMaxLength(Asset.class, "buildingCode");
        Integer buildingRoomNumberMaxLength = this.dataDictionaryService.getAttributeMaxLength(Asset.class, "buildingRoomNumber");
        Integer buildingSubRoomNumberMaxLength = this.dataDictionaryService.getAttributeMaxLength(Asset.class, "buildingSubRoomNumber");
        Integer conditionCodeMaxLength = this.dataDictionaryService.getAttributeMaxLength(Asset.class, "conditionCode");
        String campusTagNumberLabel = this.dataDictionaryService.getAttributeLabel(Asset.class, "campusTagNumber");
        String inventoryScannedCodeLabel = this.dataDictionaryService.getAttributeLabel(Asset.class, CamsPropertyConstants.BarcodeInventory.UPLOAD_SCAN_INDICATOR);
        String InventoryDateLabel = this.dataDictionaryService.getAttributeLabel(BarcodeInventoryErrorDetail.class, CamsPropertyConstants.BarcodeInventory.INVENTORY_DATE);
        String campusCodeLabel = this.dataDictionaryService.getAttributeLabel(Asset.class, "campusCode");
        String buildingCodeLabel = this.dataDictionaryService.getAttributeLabel(Asset.class, "buildingCode");
        String buildingRoomNumberLabel = this.dataDictionaryService.getAttributeLabel(Asset.class, "buildingRoomNumber");
        String buildingSubRoomNumberLabel = this.dataDictionaryService.getAttributeLabel(Asset.class, "buildingSubRoomNumber");
        String conditionCodeLabel = this.dataDictionaryService.getAttributeLabel(Asset.class, "conditionCode");
        try {
            String line;
            int recordCount = 0;
            Object errorMessage = "";
            boolean proceed = true;
            String lengthError = "exceeds maximum length";
            input = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));
            while ((line = input.readLine()) != null) {
                ++recordCount;
                Object errorMsg = "";
                String[] column = (line = StringUtils.remove((String)line, (String)"\"")).split(",");
                if (8 < column.length) {
                    errorMsg = (String)errorMsg + "  Barcode inventory file has record(s) with more than 8 columns\n";
                    proceed = false;
                } else if (8 > column.length) {
                    errorMsg = (String)errorMsg + "  Barcode inventory file has record(s) with less than 8 columns\n";
                    proceed = false;
                } else {
                    if (column[0].length() > campusTagNumberMaxLength) {
                        errorMsg = (String)errorMsg + ", " + campusTagNumberLabel;
                    }
                    if (column[1].length() > inventoryScannedCodeMaxLength) {
                        errorMsg = (String)errorMsg + ", " + inventoryScannedCodeLabel;
                    }
                    if (column[2].length() > InventoryDateMaxLength) {
                        errorMsg = (String)errorMsg + ", " + InventoryDateLabel;
                    }
                    if (column[3].length() > campusCodeMaxLength) {
                        errorMsg = (String)errorMsg + ", " + campusCodeLabel;
                    }
                    if (column[4].length() > buildingCodeMaxLength) {
                        errorMsg = (String)errorMsg + ", " + buildingCodeLabel;
                    }
                    if (column[5].length() > buildingRoomNumberMaxLength) {
                        errorMsg = (String)errorMsg + ", " + buildingRoomNumberLabel;
                    }
                    if (column[6].length() > buildingSubRoomNumberMaxLength) {
                        errorMsg = (String)errorMsg + ", " + buildingSubRoomNumberLabel;
                    }
                    if (column[7].length() > conditionCodeMaxLength) {
                        errorMsg = (String)errorMsg + ", " + conditionCodeLabel;
                    }
                    if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                        errorMsg = (String)errorMsg + " " + lengthError;
                    }
                    if (!column[1].equals("1") && !column[1].equals("0")) {
                        errorMsg = (String)errorMsg + ", " + inventoryScannedCodeLabel + " is invalid";
                    }
                    if (!this.validateDate(column[2])) {
                        errorMsg = (String)errorMsg + ", " + InventoryDateLabel + " is invalid";
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                    errorMsg = "Error on record number " + recordCount + ": " + ((String)errorMsg).substring(2) + "\n";
                    GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.custom", new String[]{errorMsg});
                    errorMessage = (String)errorMessage + (String)errorMsg;
                    LOG.error((String)errorMsg);
                }
                if (proceed) continue;
                break;
            }
            boolean bl = StringUtils.isBlank((CharSequence)errorMessage);
            return bl;
        }
        catch (FileNotFoundException e1) {
            LOG.error("file to parse not found " + fileName, (Throwable)e1);
            throw new RuntimeException("Cannot find the file requested to be parsed " + fileName + " " + e1.getMessage(), e1);
        }
        catch (Exception e) {
            LOG.error("Error running file validation - File: " + fileName, (Throwable)e);
            throw new IllegalArgumentException("Error running file validation - File: " + fileName);
        }
        finally {
            LOG.debug("isFileFormatValid(File file) - end");
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                LOG.error("isFileFormatValid() error closing file.", (Throwable)ex);
            }
        }
    }

    @Override
    public boolean processFile(File file, AssetBarCodeInventoryInputFileForm form) {
        LOG.debug("processFile(File file) - start");
        this.removeDoneFile(file);
        BufferedReader input = null;
        String fileName = file.getName();
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", Locale.US);
        formatter.setLenient(false);
        ArrayList<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = new ArrayList<BarcodeInventoryErrorDetail>();
        try {
            String line;
            Long ln = 1L;
            input = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));
            while ((line = input.readLine()) != null) {
                line = StringUtils.remove((String)line, (String)"\"");
                String[] lineStrings = line.split(",");
                lineStrings[2] = StringUtils.rightPad((String)lineStrings[2].trim(), (int)14, (String)"0");
                String day = lineStrings[2].substring(0, 2);
                String month = lineStrings[2].substring(2, 4);
                String year = lineStrings[2].substring(4, 8);
                String hours = lineStrings[2].substring(8, 10);
                String minutes = lineStrings[2].substring(10, 12);
                String seconds = lineStrings[2].substring(12);
                String stringDate = month + "/" + day + "/" + year + " " + hours + ":" + minutes + ":" + seconds;
                Timestamp timestamp = null;
                try {
                    timestamp = new Timestamp(formatter.parse(stringDate).getTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lineStrings[2].equals(StringUtils.repeat((String)"0", (int)14))) {
                    timestamp = null;
                }
                BarcodeInventoryErrorDetail barcodeInventoryErrorDetail = new BarcodeInventoryErrorDetail();
                barcodeInventoryErrorDetail.setUploadRowNumber(ln);
                barcodeInventoryErrorDetail.setAssetTagNumber(lineStrings[0].trim());
                barcodeInventoryErrorDetail.setUploadScanIndicator(lineStrings[1].equals("1"));
                barcodeInventoryErrorDetail.setUploadScanTimestamp(timestamp);
                barcodeInventoryErrorDetail.setCampusCode(lineStrings[3].trim().toUpperCase(Locale.US));
                barcodeInventoryErrorDetail.setBuildingCode(lineStrings[4].trim().toUpperCase(Locale.US));
                barcodeInventoryErrorDetail.setBuildingRoomNumber(lineStrings[5].trim().toUpperCase(Locale.US));
                barcodeInventoryErrorDetail.setBuildingSubRoomNumber(lineStrings[6].trim().toUpperCase(Locale.US));
                barcodeInventoryErrorDetail.setAssetConditionCode(lineStrings[7].trim().toUpperCase(Locale.US));
                barcodeInventoryErrorDetail.setErrorCorrectionStatusCode("E");
                barcodeInventoryErrorDetail.setCorrectorUniversalIdentifier(GlobalVariables.getUserSession().getPerson().getPrincipalId());
                barcodeInventoryErrorDetails.add(barcodeInventoryErrorDetail);
                Long l = ln;
                Long l2 = ln = Long.valueOf(ln + 1L);
            }
            this.processBarcodeInventory(barcodeInventoryErrorDetails, form);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e1) {
            LOG.error("file to parse not found " + fileName, (Throwable)e1);
            throw new RuntimeException("Cannot find the file requested to be parsed " + fileName + " " + e1.getMessage(), e1);
        }
        catch (Exception ex) {
            LOG.error("Error reading file", (Throwable)ex);
            throw new IllegalArgumentException("Error reading file: " + ex.getMessage(), ex);
        }
        finally {
            LOG.debug("processFile(File file) - End");
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                LOG.error("loadFlatFile() error closing file.", (Throwable)ex);
            }
        }
    }

    protected void removeDoneFile(File file) {
        String filePath = file.getAbsolutePath();
        File doneFile = new File(StringUtils.substringBeforeLast((String)filePath, (String)".") + ".done");
        if (doneFile.exists()) {
            doneFile.delete();
        }
    }

    protected void processBarcodeInventory(List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails, AssetBarCodeInventoryInputFileForm form) throws Exception {
        long lineNumber = 0L;
        boolean docCreated = false;
        int errorRecCount = 0;
        int totalRecCount = 0;
        BarcodeInventoryErrorDocument barcodeInventoryErrorDocument = this.createInvalidBarcodeInventoryDocument(barcodeInventoryErrorDetails, form.getUploadDescription());
        this.kualiRuleService.applyRules((KualiDocumentEvent)new ValidateBarcodeInventoryEvent("", (Document)barcodeInventoryErrorDocument, true));
        ArrayList<BarcodeInventoryErrorDetail> tmpBarcodeInventoryErrorDetails = new ArrayList<BarcodeInventoryErrorDetail>();
        for (BarcodeInventoryErrorDetail barcodeInventoryErrorDetail : barcodeInventoryErrorDetails) {
            ++totalRecCount;
            if (!barcodeInventoryErrorDetail.getErrorCorrectionStatusCode().equals("E")) {
                this.updateAssetInformation(barcodeInventoryErrorDetail, true);
                continue;
            }
            ++errorRecCount;
            barcodeInventoryErrorDetail.setUploadRowNumber(++lineNumber);
            tmpBarcodeInventoryErrorDetails.add(barcodeInventoryErrorDetail);
        }
        String documentsCreated = "";
        if (!tmpBarcodeInventoryErrorDetails.isEmpty()) {
            documentsCreated = this.createBarcodeInventoryErrorDocuments(tmpBarcodeInventoryErrorDetails, barcodeInventoryErrorDocument, form);
            docCreated = true;
        }
        if (!docCreated) {
            form.getMessages().add(MESSAGE_NO_DOCUMENT_CREATED);
        } else {
            form.getMessages().add("The following barcode inventory error document were created: " + documentsCreated.substring(2));
        }
        form.getMessages().add("Total records uploaded: " + StringUtils.rightPad((String)Integer.toString(totalRecCount), (int)5, (String)" "));
        form.getMessages().add("Total records in error: " + StringUtils.rightPad((String)Integer.toString(errorRecCount), (int)5, (String)" "));
    }

    protected String createBarcodeInventoryErrorDocuments(List<BarcodeInventoryErrorDetail> bcies, BarcodeInventoryErrorDocument barcodeInventoryErrorDocument, AssetBarCodeInventoryInputFileForm form) {
        ArrayList<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = new ArrayList<BarcodeInventoryErrorDetail>();
        boolean isFirstDocument = true;
        int ln = 0;
        int bcieCount = 0;
        Object documentsCreated = "";
        int maxNumberRecordsPerDocument = 300;
        try {
            if (this.parameterService.parameterExists(BarcodeInventoryErrorDocument.class, "MAX_NUMBER_OF_RECORDS_PER_DOCUMENT").booleanValue()) {
                maxNumberRecordsPerDocument = new Integer(this.parameterService.getParameterValueAsString(BarcodeInventoryErrorDocument.class, "MAX_NUMBER_OF_RECORDS_PER_DOCUMENT"));
            }
            while (true) {
                if (ln > maxNumberRecordsPerDocument || bcieCount >= bcies.size()) {
                    if (!isFirstDocument) {
                        barcodeInventoryErrorDocument = this.createInvalidBarcodeInventoryDocument(barcodeInventoryErrorDetails, form.getUploadDescription());
                    }
                    documentsCreated = (String)documentsCreated + ", " + barcodeInventoryErrorDocument.getDocumentNumber();
                    barcodeInventoryErrorDocument.setBarcodeInventoryErrorDetail(barcodeInventoryErrorDetails);
                    this.saveInvalidBarcodeInventoryDocument(barcodeInventoryErrorDocument);
                    barcodeInventoryErrorDetails = new ArrayList();
                    if (bcieCount >= bcies.size()) break;
                    ln = 0;
                    isFirstDocument = false;
                }
                BarcodeInventoryErrorDetail barcodeInventoryErrorDetail = bcies.get(bcieCount);
                barcodeInventoryErrorDetail.setUploadRowNumber(Long.valueOf(ln + 1));
                barcodeInventoryErrorDetails.add(barcodeInventoryErrorDetail);
                ++ln;
                ++bcieCount;
            }
        }
        catch (Exception e) {
            LOG.error("Error creating BCIE documents", (Throwable)e);
            throw new IllegalArgumentException("Error creating BCIE documents: " + e.getMessage(), e);
        }
        return documentsCreated;
    }

    @Override
    public void updateAssetInformation(BarcodeInventoryErrorDetail barcodeInventoryErrorDetail, boolean updateWithDateAssetWasScanned) {
        LOG.debug("updateAssetInformation() started");
        Asset asset = this.assetService.findActiveAssetsMatchingTagNumber(barcodeInventoryErrorDetail.getAssetTagNumber()).get(0);
        asset.setInventoryScannedCode(barcodeInventoryErrorDetail.isUploadScanIndicator() ? "1" : "0");
        asset.setBuildingCode(barcodeInventoryErrorDetail.getBuildingCode());
        asset.setBuildingRoomNumber(barcodeInventoryErrorDetail.getBuildingRoomNumber());
        asset.setBuildingSubRoomNumber(barcodeInventoryErrorDetail.getBuildingSubRoomNumber());
        asset.setCampusCode(barcodeInventoryErrorDetail.getCampusCode());
        asset.setConditionCode(barcodeInventoryErrorDetail.getAssetConditionCode());
        if (StringUtils.isEmpty((CharSequence)asset.getBuildingCode())) {
            asset.setBuildingCode(null);
            asset.setBuilding(null);
        }
        if (StringUtils.isEmpty((CharSequence)asset.getBuildingRoomNumber())) {
            asset.setBuildingRoomNumber(null);
            asset.setBuildingRoom(null);
        }
        if (updateWithDateAssetWasScanned) {
            asset.setLastInventoryDate(barcodeInventoryErrorDetail.getUploadScanTimestamp());
        } else {
            asset.setLastInventoryDate(new Timestamp(this.dateTimeService.getCurrentSqlDate().getTime()));
        }
        List<AssetLocation> assetLocations = asset.getAssetLocations();
        for (AssetLocation assetLocation : assetLocations) {
            if (!"O".equals(assetLocation.getAssetLocationTypeCode())) continue;
            assetLocations.remove((Object)assetLocation);
            break;
        }
        this.updateAssetPreSave(barcodeInventoryErrorDetail, asset);
        this.businessObjectService.save((PersistableBusinessObject)asset);
    }

    @Override
    public void updateAssetPreSave(BarcodeInventoryErrorDetail barcodeInventoryErrorDetail, Asset asset) {
        LOG.debug("updateAssetPreSave() started");
    }

    protected BarcodeInventoryErrorDocument createInvalidBarcodeInventoryDocument(List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails, String uploadDescription) throws WorkflowException {
        BarcodeInventoryErrorDocument document = (BarcodeInventoryErrorDocument)this.documentService.getNewDocument(BarcodeInventoryErrorDocument.class);
        document.getDocumentHeader().setExplanation(DOCUMENT_EXPLANATION);
        document.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(KualiDecimal.ZERO);
        document.getDocumentHeader().setDocumentDescription(uploadDescription);
        document.setUploaderUniversalIdentifier(GlobalVariables.getUserSession().getPerson().getPrincipalId());
        document.setBarcodeInventoryErrorDetail(barcodeInventoryErrorDetails);
        return document;
    }

    protected void saveInvalidBarcodeInventoryDocument(BarcodeInventoryErrorDocument document) {
        try {
            GlobalVariables.clear();
            ArrayList adHocRouteRecipients = new ArrayList();
            this.documentService.routeDocument((Document)document, "Routed Update Barcode Inventory Document", adHocRouteRecipients);
        }
        catch (Exception e) {
            LOG.error("Error persisting document # " + document.getDocumentHeader().getDocumentNumber() + " " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Error persisting document # " + document.getDocumentHeader().getDocumentNumber() + " " + e.getMessage(), e);
        }
    }

    private boolean validateDate(String date) {
        boolean valid = true;
        if (StringHelper.isEmpty((String)date)) {
            valid = false;
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss", Locale.US);
            date = StringUtils.rightPad((String)date.trim(), (int)14, (String)"0");
            String day = date.substring(0, 2);
            String month = date.substring(2, 4);
            String year = date.substring(4, 8);
            String hours = date.substring(8, 10);
            String minutes = date.substring(10, 12);
            String seconds = date.substring(12);
            String stringDate = month + "/" + day + "/" + year + " " + hours + ":" + minutes + ":" + seconds;
            try {
                new Timestamp(formatter.parse(stringDate).getTime());
            }
            catch (Exception e) {
                valid = false;
            }
        }
        return valid;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setKualiRuleService(KualiRuleService ruleService) {
        this.kualiRuleService = ruleService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }
}

