/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.document.EquipmentLoanOrReturnDocument;
import org.kuali.kfs.module.cam.document.service.EquipmentLoanOrReturnService;

public class EquipmentLoanOrReturnServiceImpl
implements EquipmentLoanOrReturnService {
    private BusinessObjectService businessObjectService;
    protected DateTimeService dateTimeService;

    @Override
    public void processApprovedEquipmentLoanOrReturn(EquipmentLoanOrReturnDocument document) {
        Asset updateAsset = new Asset();
        updateAsset.setCapitalAssetNumber(document.getCapitalAssetNumber());
        updateAsset = (Asset)this.getBusinessObjectService().retrieve((PersistableBusinessObject)updateAsset);
        updateAsset.setExpectedReturnDate(document.getExpectedReturnDate());
        updateAsset.setLoanDate(document.getLoanDate());
        updateAsset.setLoanReturnDate(document.getLoanReturnDate());
        this.updateBorrowerLocation(document, updateAsset);
        this.updateStoreAtLocation(document, updateAsset);
        updateAsset.setLastInventoryDate(new Timestamp(this.dateTimeService.getCurrentSqlDate().getTime()));
        this.getBusinessObjectService().save((PersistableBusinessObject)updateAsset);
    }

    @Override
    public void setEquipmentLoanInfo(Asset asset) {
        if (asset.getExpectedReturnDate() != null && asset.getLoanReturnDate() == null) {
            asset.refreshReferenceObject("assetLocations");
            List<AssetLocation> assetLocations = asset.getAssetLocations();
            if (ObjectUtils.isNotNull(assetLocations)) {
                for (AssetLocation assetLocation : assetLocations) {
                    if ("B".equals(assetLocation.getAssetLocationTypeCode())) {
                        asset.setBorrowerLocation(assetLocation);
                    }
                    if (!"BS".equals(assetLocation.getAssetLocationTypeCode())) continue;
                    asset.setBorrowerStorageLocation(assetLocation);
                }
            }
        }
    }

    protected void updateBorrowerLocation(EquipmentLoanOrReturnDocument document, Asset updateAsset) {
        AssetLocation borrowerLocation = new AssetLocation();
        borrowerLocation.setCapitalAssetNumber(updateAsset.getCapitalAssetNumber());
        borrowerLocation.setAssetLocationTypeCode("B");
        borrowerLocation = (AssetLocation)this.getBusinessObjectService().retrieve((PersistableBusinessObject)borrowerLocation);
        if (ObjectUtils.isNull((Object)document.getLoanReturnDate())) {
            if (borrowerLocation == null) {
                borrowerLocation = new AssetLocation();
                borrowerLocation.setCapitalAssetNumber(updateAsset.getCapitalAssetNumber());
                borrowerLocation.setAssetLocationTypeCode("B");
                updateAsset.getAssetLocations().add(borrowerLocation);
            }
            borrowerLocation.setAssetLocationContactName(document.getBorrowerPerson().getPrincipalName());
            borrowerLocation.setAssetLocationContactIdentifier(document.getBorrowerUniversalIdentifier());
            borrowerLocation.setAssetLocationInstitutionName(document.getBorrowerPerson().getPrimaryDepartmentCode());
            borrowerLocation.setAssetLocationPhoneNumber(document.getBorrowerPhoneNumber());
            borrowerLocation.setAssetLocationStreetAddress(document.getBorrowerAddress());
            borrowerLocation.setAssetLocationCityName(document.getBorrowerCityName());
            borrowerLocation.setAssetLocationStateCode(document.getBorrowerStateCode());
            borrowerLocation.setAssetLocationCountryCode(document.getBorrowerCountryCode());
            borrowerLocation.setAssetLocationZipCode(document.getBorrowerZipCode());
            this.getBusinessObjectService().save((PersistableBusinessObject)borrowerLocation);
        } else if (borrowerLocation != null) {
            updateAsset.getAssetLocations().remove((Object)borrowerLocation);
            this.getBusinessObjectService().delete((PersistableBusinessObject)borrowerLocation);
        }
    }

    protected void updateStoreAtLocation(EquipmentLoanOrReturnDocument document, Asset updateAsset) {
        AssetLocation storeAtLocation = new AssetLocation();
        storeAtLocation.setCapitalAssetNumber(updateAsset.getCapitalAssetNumber());
        storeAtLocation.setAssetLocationTypeCode("BS");
        storeAtLocation = (AssetLocation)this.getBusinessObjectService().retrieve((PersistableBusinessObject)storeAtLocation);
        if (ObjectUtils.isNull((Object)document.getLoanReturnDate()) && StringUtils.isNotBlank((CharSequence)document.getBorrowerStorageAddress())) {
            if (storeAtLocation == null) {
                storeAtLocation = new AssetLocation();
                storeAtLocation.setCapitalAssetNumber(updateAsset.getCapitalAssetNumber());
                storeAtLocation.setAssetLocationTypeCode("BS");
                updateAsset.getAssetLocations().add(storeAtLocation);
            }
            storeAtLocation.setAssetLocationContactName(document.getBorrowerPerson().getPrincipalName());
            storeAtLocation.setAssetLocationContactIdentifier(document.getBorrowerUniversalIdentifier());
            storeAtLocation.setAssetLocationInstitutionName(document.getBorrowerPerson().getPrimaryDepartmentCode());
            storeAtLocation.setAssetLocationPhoneNumber(document.getBorrowerStoragePhoneNumber());
            storeAtLocation.setAssetLocationStreetAddress(document.getBorrowerStorageAddress());
            storeAtLocation.setAssetLocationCityName(document.getBorrowerStorageCityName());
            storeAtLocation.setAssetLocationStateCode(document.getBorrowerStorageStateCode());
            storeAtLocation.setAssetLocationCountryCode(document.getBorrowerStorageCountryCode());
            storeAtLocation.setAssetLocationZipCode(document.getBorrowerStorageZipCode());
            this.getBusinessObjectService().save((PersistableBusinessObject)storeAtLocation);
        } else if (storeAtLocation != null) {
            updateAsset.getAssetLocations().remove((Object)storeAtLocation);
            this.getBusinessObjectService().delete((PersistableBusinessObject)storeAtLocation);
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

