/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam;

/**
 * Holds constants for CAB business parameters.
 */
public final class CamsParameterConstants {

    public static final String ACCUMULATED_DEPRECIATION_LINE_DESCRIPTION = "ACCUMULATED_DEPRECIATION_LINE_DESCRIPTION";
    public static final String BALANCE_TYPES = "BALANCE_TYPES";
    public static final String BAR_CODE_ERROR_DOCUMENT_IGNORES_LOCKS = "IGNORES_LOCKS_IND";
    public static final String BLANK_OUT_NOTIFICATION_EMAIL_ADDRESSES = "BLANK_OUT_NOTIFICATION_EMAIL_ADDRESSES";
    public static final String BLANK_OUT_PERIOD_BEGIN = "BLANK_OUT_PERIOD_BEGIN";
    public static final String BLANK_OUT_PERIOD_END = "BLANK_OUT_PERIOD_END";
    public static final String BLANK_OUT_PERIOD_RUN_DATE = "BLANK_OUT_PERIOD_RUN_DATE";
    public static final String CAPITAL_ASSET_STATUS_CODES = "CAPITAL_ASSET_STATUS_CODES";
    public static final String CAPITAL_ASSET_OBJECT_LEVELS = "PURCHASING_ACCOUNTS_PAYABLE_OBJECT_LEVELS";
    public static final String CAPITAL_OBJECT_ACQUISITION_CODE_PARAM = "CAPITAL_OBJECT_ACQUISITION_CODES";
    public static final String CAPITAL_OBJECT_SUB_TYPES = "CAPITAL_OBJECT_SUB_TYPES";
    public static final String CAPITALIZATION_LIMIT_AMOUNT = "CAPITALIZATION_LIMIT_AMOUNT";
    public static final String CAPITALIZATION_LINE_DESCRIPTION = "CAPITALIZATION_LINE_DESCRIPTION";
    public static final String CHARTS = "CHARTS";
    public static final String DEFAULT_FABRICATION_ASSET_MANUFACTURER = "DEFAULT_FABRICATION_ASSET_MANUFACTURER";
    public static final String DEFAULT_FABRICATION_ASSET_TYPE_CODE = "DEFAULT_FABRICATION_ASSET_TYPE";
    public static final String DEFAULT_GAIN_LOSS_DISPOSITION_OBJECT_CODE = "DEFAULT_GAIN_LOSS_DISPOSITION_OBJECT_CODE";
    public static final String DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPES = "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE";
    public static final String DEPRECIATION_DATE_PARAMETER = "DEPRECIATION_DATE";
    public static final String DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPE = "DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPE";
    public static final String DEPRECIATION_PERIOD = "DEPRECIATION_PERIOD";
    public static final String DETAIL_TYPE_BATCH = "Batch";
    public static final String DETAIL_TYPE_DOCUMENT = "Document";
    public static final String DETAIL_TYPE_PRE_ASSET_TAGGING_STEP = "PreAssetTaggingStep";
    public static final String DOCUMENT_TYPES = "DOCUMENT_TYPES";
    public static final String EDITABLE_FIELDS_WHEN_TAGGED_PRIOR_FISCAL_YEAR = "EDITABLE_FIELDS_WHEN_TAGGED_PRIOR_FISCAL_YEAR";
    public static final String FABRICATED_ACQUISITION_CODE = "FABRICATED_ACQUISITION_CODE";
    public static final String FEDERAL_CONTRIBUTIONS_OBJECT_SUB_TYPES = "FEDERAL_CONTRIBUTIONS_OBJECT_SUB_TYPES";
    public static final String FEDERAL_OWNED_OBJECT_SUB_TYPES = "FEDERAL_OWNED_OBJECT_SUB_TYPES";
    public static final String FINANCIAL_PROCESSING_CAPITAL_OBJECT_SUB_TYPES = "FINANCIAL_PROCESSING_CAPITAL_OBJECT_SUB_TYPES";
    public static final String FISCAL_PERIODS = "FISCAL_PERIODS";
    public static final String FISCAL_YEAR_END_MONTH_AND_DAY = "FISCAL_YEAR_END_MONTH_AND_DAY";
    public static final String INVALID_ASSET_STATUSES_BY_ACQUISITION_TYPE = "INVALID_ASSET_STATUSES_BY_ACQUISITION_TYPE";
    public static final String INVALID_OBJECT_SUB_TYPES_BY_ACQUISITION_TYPE = "INVALID_OBJECT_SUB_TYPES_BY_ACQUISITION_TYPE";
    public static final String INVALID_INVENTORY_STATUS_CODE_CHANGE = "INVALID_ASSET_STATUS_BY_PRIOR_ASSET_STATUS";
    public static final String LAST_EXTRACT_DATE = "LAST_EXTRACT_DATE";
    public static final String LAST_EXTRACT_TIME = "LAST_EXTRACT_TIME";
    public static final String MANUFACTURER_REQUIRED_FOR_NON_MOVABLE_ASSET_IND = "MANUFACTURER_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND";
    public static final String MAX_NUMBER_OF_RECORDS_PER_DOCUMENT = "MAX_NUMBER_OF_RECORDS_PER_DOCUMENT";
    public static final String MERGE_SEPARATE_RETIREMENT_REASONS = "MERGE_SEPARATE_RETIREMENT_REASONS";
    public static final String MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES = "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES";
    public static final String NAMESPACE = "KFS-CAM";
    public static final String NEW_ACQUISITION_CODE_PARAM = "NEW_ACQUISITION_CODE";
    public static final String NEW_IN_SERVICE_ASSET_DEPRECIATION_START_DATE = "NEW_IN_SERVICE_ASSET_DEPRECIATION_START_DATE";
    public static final String NON_CAPITAL_EQUIPMENT_OBJECT_SUB_TYPES = "NON_CAPITAL_EQUIPMENT_OBJECT_SUB_TYPES";
    public static final String NON_DEPRECIABLE_FEDERALLY_OWNED_OBJECT_SUB_TYPES = "NON_DEPRECIABLE_FEDERALLY_OWNED_OBJECT_SUB_TYPES";
    public static final String NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES = "NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES";
    public static final String NON_MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES = "NON_MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES";
    public static final String NON_NEW_ACQUISITION_GROUP_PARAM = "NON_NEW_ACQUISITION_CODES";
    public static final String OBJECT_SUB_TYPE_GROUPS = "OBJECT_SUB_TYPE_GROUPS";
    public static final String OBJECT_SUB_TYPES = "OBJECT_SUB_TYPES";
    public static final String OFFSET_AMOUNT_LINE_DESCRIPTION = "OFFSET_AMOUNT_LINE_DESCRIPTION";
    public static final String PRE_TAGGING_ACQUISITION_CODE = "PRE_TAGGING_ACQUISITION_CODE";
    public static final String POSSIBLE_CAPITAL_ASSET_OBJECT_LEVELS = "PURCHASING_ACCOUNTS_PAYABLE_POSSIBLE_OBJECT_LEVELS";
    public static final String PURCHASING_ASSET_TRANSACTION_TYPES_ALLOWING_ASSET_NUMBERS = "PURCHASING_ASSET_TRANSACTION_TYPES_ALLOWING_ASSET_NUMBERS";
    public static final String RAZE_RETIREMENT_REASONS = "RAZE_RETIREMENT_REASONS";
    public static final String RECURRING_CAMS_TRAN_TYPES = "PURCHASING_ASSET_TRANSACTION_TYPES_REQUIRING_RECURRING_PAYMENT_TERMS";
    public static final String RETIRED_STATUS_CODES = "RETIRED_STATUS_CODES";
    public static final String SUB_FUND_GROUPS = "SUB_FUND_GROUPS";
    public static final String VALID_ASSET_STATUSES_BY_ACQUISITION_TYPE = "VALID_ASSET_STATUSES_BY_ACQUISITION_TYPE";
    public static final String VALID_INVENTORY_STATUS_CODE_CHANGE = "VALID_ASSET_STATUS_BY_PRIOR_ASSET_STATUS";
    public static final String VALID_OBJECT_SUB_TYPES_BY_ACQUISITION_TYPE = "VALID_OBJECT_SUB_TYPES_BY_ACQUISITION_TYPE";
    public static final String VENDOR_REQUIRED_FOR_NON_MOVABLE_ASSET_IND = "VENDOR_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND";

    /**
     * Private Constructor since this is a constants class that should never be instantiated.
     */
    private CamsParameterConstants() {
    }

}
