/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kim.api.identity.Person;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class Pretag extends PersistableBusinessObjectBase implements MutableInactivatable {

    private String purchaseOrderNumber;
    private Integer itemLineNumber;
    private KualiDecimal quantityInvoiced;
    private String capitalAssetTypeCode;
    private String manufacturerName;
    private String manufacturerModelNumber;
    private String vendorName;
    private String assetTopsDescription;
    private String organizationText;
    private String organizationInventoryName;
    private String representativeUniversalIdentifier;
    private String chartOfAccountsCode;
    private Date pretagCreateDate;
    private String organizationCode;
    private boolean active;

    private Chart chartOfAccounts;
    private Organization organization;
    private AssetType capitalAssetType;
    private Person personUniversal;

    private List<String> campusTagNumbers;
    private List<String> serialNumbers;

    private List<PretagDetail> pretagDetails;

    public Pretag() {
        pretagDetails = new ArrayList<>();
    }

    public String getPurchaseOrderNumber() {
        return purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public Integer getItemLineNumber() {
        return itemLineNumber;
    }

    public void setItemLineNumber(Integer itemLineNumber) {
        this.itemLineNumber = itemLineNumber;
    }

    public KualiDecimal getQuantityInvoiced() {
        return quantityInvoiced;
    }

    public void setQuantityInvoiced(KualiDecimal quantityInvoiced) {
        this.quantityInvoiced = quantityInvoiced;
    }

    public String getCapitalAssetTypeCode() {
        return capitalAssetTypeCode;
    }

    public void setCapitalAssetTypeCode(String capitalAssetTypeCode) {
        this.capitalAssetTypeCode = capitalAssetTypeCode;
    }

    public String getManufacturerName() {
        return manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public String getManufacturerModelNumber() {
        return manufacturerModelNumber;
    }

    public void setManufacturerModelNumber(String manufacturerModelNumber) {
        this.manufacturerModelNumber = manufacturerModelNumber;
    }

    public String getVendorName() {
        return vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getAssetTopsDescription() {
        return assetTopsDescription;
    }

    public void setAssetTopsDescription(String assetTopsDescription) {
        this.assetTopsDescription = assetTopsDescription;
    }

    public String getOrganizationText() {
        return organizationText;
    }

    public void setOrganizationText(String organizationText) {
        this.organizationText = organizationText;
    }

    public String getOrganizationInventoryName() {
        return organizationInventoryName;
    }

    public void setOrganizationInventoryName(String organizationInventoryName) {
        this.organizationInventoryName = organizationInventoryName;
    }

    public Person getPersonUniversal() {
        personUniversal = SpringContext.getBean(org.kuali.kfs.kim.api.identity.PersonService.class)
                .updatePersonIfNecessary(representativeUniversalIdentifier, personUniversal);
        return personUniversal;
    }

    public void setPersonUniversal(Person personUniversal) {
        this.personUniversal = personUniversal;
    }

    public String getRepresentativeUniversalIdentifier() {
        return representativeUniversalIdentifier;
    }

    public void setRepresentativeUniversalIdentifier(String representativeUniversalIdentifier) {
        this.representativeUniversalIdentifier = representativeUniversalIdentifier;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public Date getPretagCreateDate() {
        return pretagCreateDate;
    }

    public void setPretagCreateDate(Date pretagCreateDate) {
        this.pretagCreateDate = pretagCreateDate;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    /**
     * @deprecated
     */
    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public Organization getOrganization() {
        return organization;
    }

    /**
     * @deprecated
     */
    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public List<PretagDetail> getPretagDetails() {
        return pretagDetails;
    }

    public void setPretagDetails(List<PretagDetail> pretagDetails) {
        this.pretagDetails = pretagDetails;
    }

    public AssetType getCapitalAssetType() {
        return capitalAssetType;
    }

    /**
     * @deprecated
     */
    public void setCapitalAssetType(AssetType capitalAssetType) {
        this.capitalAssetType = capitalAssetType;
    }

    public List<String> getCampusTagNumbers() {
        List<String> campusTagNumbers = new ArrayList<>();
        if (pretagDetails != null) {
            for (PretagDetail pretagDetail : pretagDetails) {
                campusTagNumbers.add(pretagDetail.getCampusTagNumber());
            }
        }
        return campusTagNumbers;
    }

    /**
     * @deprecated
     */
    public void setCampusTagNumbers(List<String> campusTagNumbers) {
        this.campusTagNumbers = campusTagNumbers;
    }

    public List<String> getSerialNumbers() {
        List<String> serialNumbers = new ArrayList<>();
        if (pretagDetails != null) {
            for (PretagDetail pretagDetail : pretagDetails) {
                serialNumbers.add(pretagDetail.getSerialNumber());
            }
        }
        return serialNumbers;
    }

    /**
     * @deprecated
     */
    public void setSerialNumbers(List<String> serialNumbers) {
        this.serialNumbers = serialNumbers;
    }

}
