/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam;

import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.module.cam.PurApAccountLineGroupTest;
import org.kuali.kfs.module.cam.businessobject.GlAccountLineGroup;
import org.kuali.kfs.module.cam.businessobject.PurApAccountLineGroup;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.mockito.Mockito;

@Execution(value=ExecutionMode.SAME_THREAD)
public class AccountLineGroupTest {
    @Test
    public void equals_all_match() {
        GlAccountLineGroup first = this.createAccountLineGroup("BL", "--", "--------", null, "D");
        GlAccountLineGroup second = this.createAccountLineGroup("BL", "------", null, null, "C");
        PurApAccountLineGroup third = this.createPurApAccountLineGroup("BL", "---", "7000", "----", new KualiDecimal(100));
        Assert.assertEquals((Object)first, (Object)first);
        Assert.assertEquals((Object)first, (Object)second);
        Assert.assertEquals((Object)second, (Object)first);
        Assert.assertEquals((Object)second, (Object)third);
        Assert.assertEquals((Object)third, (Object)second);
        Assert.assertEquals((Object)first, (Object)third);
        Assert.assertEquals((Object)third, (Object)first);
    }

    @Test
    public void equals_first_and_third_match() {
        GlAccountLineGroup first = this.createAccountLineGroup("BA", "--", null, null, "C");
        GlAccountLineGroup second = this.createAccountLineGroup("BL", "--", null, null, "D");
        PurApAccountLineGroup third = this.createPurApAccountLineGroup("BA", "--", "7000", null, new KualiDecimal(100));
        Assert.assertNotEquals((Object)first, (Object)second);
        Assert.assertNotEquals((Object)second, (Object)first);
        Assert.assertNotEquals((Object)second, (Object)third);
        Assert.assertNotEquals((Object)third, (Object)second);
        Assert.assertEquals((Object)first, (Object)third);
        Assert.assertEquals((Object)third, (Object)first);
    }

    @Test
    public void equals_none_match() {
        GlAccountLineGroup first = this.createAccountLineGroup("BA", "X", null, null, "C");
        GlAccountLineGroup second = this.createAccountLineGroup("BA", "XXX", null, null, "D");
        PurApAccountLineGroup third = this.createPurApAccountLineGroup("BL", "X", "7001", null, new KualiDecimal(100));
        Assert.assertNotEquals((Object)first, (Object)second);
        Assert.assertNotEquals((Object)second, (Object)first);
        Assert.assertNotEquals((Object)second, (Object)third);
        Assert.assertNotEquals((Object)third, (Object)second);
        Assert.assertNotEquals((Object)first, (Object)third);
        Assert.assertNotEquals((Object)third, (Object)first);
        Assert.assertNotNull((Object)first);
        Assert.assertNotNull((Object)second);
        Assert.assertNotNull((Object)third);
    }

    @Test
    public void hashCode_Matches() {
        GlAccountLineGroup first = this.createAccountLineGroup("BL", "--", "12121", "A", "C");
        GlAccountLineGroup second = this.createAccountLineGroup("BL", "--", "12121", "A", "C");
        GlAccountLineGroup third = this.createAccountLineGroup("BL", "", "12121", "A", "D");
        Assert.assertEquals((long)first.hashCode(), (long)second.hashCode());
        Assert.assertEquals((long)second.hashCode(), (long)third.hashCode());
        Assert.assertEquals((long)first.hashCode(), (long)third.hashCode());
    }

    private GlAccountLineGroup createAccountLineGroup(String chartCode, String subAcctNum, String subObjCd, String refDocNum, String dbtCrdtCode) {
        Entry entry = new Entry();
        entry.setUniversityFiscalYear(Integer.valueOf(2008));
        entry.setChartOfAccountsCode(chartCode);
        entry.setAccountNumber("BL002323");
        entry.setSubAccountNumber(subAcctNum);
        entry.setFinancialObjectCode("7000");
        entry.setFinancialSubObjectCode(subObjCd);
        entry.setUniversityFiscalPeriodCode("01");
        entry.setDocumentNumber("1001");
        entry.setReferenceFinancialDocumentNumber(refDocNum);
        entry.setTransactionDebitCreditCode(dbtCrdtCode);
        entry.setTransactionLedgerEntryAmount(KualiDecimal.ZERO);
        return new GlAccountLineGroup(entry);
    }

    private PurApAccountLineGroup createPurApAccountLineGroup(String chartCode, String subAcctNum, String objCd, String refDocNum, KualiDecimal amount) {
        PaymentRequestAccountRevision entryMock = (PaymentRequestAccountRevision)Mockito.mock(PaymentRequestAccountRevision.class);
        Mockito.when((Object)entryMock.getPostingYear()).thenReturn((Object)2008);
        Mockito.when((Object)entryMock.getChartOfAccountsCode()).thenReturn((Object)chartCode);
        Mockito.when((Object)entryMock.getAccountNumber()).thenReturn((Object)"BL002323");
        Mockito.when((Object)entryMock.getSubAccountNumber()).thenReturn((Object)subAcctNum);
        Mockito.when((Object)entryMock.getFinancialObjectCode()).thenReturn((Object)objCd);
        Mockito.when((Object)entryMock.getFinancialSubObjectCode()).thenReturn(null);
        Mockito.when((Object)entryMock.getPostingPeriodCode()).thenReturn((Object)"01");
        Mockito.when((Object)entryMock.getDocumentNumber()).thenReturn((Object)"1001");
        Mockito.when((Object)entryMock.getAmount()).thenReturn((Object)amount);
        return new PurApAccountLineGroupTest.PurApAccountLineGroupTestable((PurApAccountingLineBase)entryMock, "1001", refDocNum);
    }
}

