/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;

public class AssetAcquisitionType extends PersistableBusinessObjectBase implements MutableInactivatable {

    private String acquisitionTypeCode;
    private String acquisitionTypeName;
    private String incomeAssetObjectCode;
    private boolean active;

    public AssetAcquisitionType() {
    }

    public String getAcquisitionTypeCode() {
        return acquisitionTypeCode;
    }

    public void setAcquisitionTypeCode(String acquisitionTypeCode) {
        this.acquisitionTypeCode = acquisitionTypeCode;
    }

    public String getAcquisitionTypeName() {
        return acquisitionTypeName;
    }

    public void setAcquisitionTypeName(String acquisitionTypeName) {
        this.acquisitionTypeName = acquisitionTypeName;
    }

    public String getIncomeAssetObjectCode() {
        return incomeAssetObjectCode;
    }

    public void setIncomeAssetObjectCode(String incomeAssetObjectCode) {
        this.incomeAssetObjectCode = incomeAssetObjectCode;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

}
