/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.report.service.impl;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.report.ContractsGrantsReportDataHolder;
import org.kuali.kfs.module.cg.report.service.ContractsGrantsAwardBalancesReportService;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;

public class ContractsGrantsAwardBalancesReportServiceImpl
implements ContractsGrantsAwardBalancesReportService {
    protected ReportGenerationService reportGenerationService;
    private ReportInfo contractsGrantsAwardBalancesReportInfo;

    @Override
    public String generateReport(ContractsGrantsReportDataHolder reportDataHolder, ByteArrayOutputStream baos) {
        return this.generateReport(reportDataHolder, this.contractsGrantsAwardBalancesReportInfo, baos);
    }

    @Override
    public String generateReport(ContractsGrantsReportDataHolder reportDataHolder, ReportInfo reportInfo, ByteArrayOutputStream baos) {
        Date runDate = new Date();
        String reportFileName = reportInfo.getReportFileName();
        String reportDirectory = reportInfo.getReportsDirectory();
        String reportTemplateClassPath = reportInfo.getReportTemplateClassPath();
        String reportTemplateName = reportInfo.getReportTemplateName();
        ResourceBundle resourceBundle = reportInfo.getResourceBundle();
        String subReportTemplateClassPath = reportInfo.getSubReportTemplateClassPath();
        Map subReports = reportInfo.getSubReports();
        Map<String, Object> reportData = reportDataHolder.getReportData();
        if (ObjectUtils.isNull((Object)reportData.get("reportTitle"))) {
            reportData.put("reportTitle", reportInfo.getReportTitle());
        }
        reportData.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
        reportData.put("SUBREPORT_DIR", subReportTemplateClassPath);
        reportData.put("SUBREPORT_TEMPLATE_NAMES", subReports);
        String template = reportTemplateClassPath + reportTemplateName;
        String fullReportFileName = this.reportGenerationService.buildFullFileName(runDate, reportDirectory, reportFileName, "");
        List<String> data = Arrays.asList("");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(data);
        this.reportGenerationService.generateReportToOutputStream(reportData, (Object)dataSource, template, baos);
        return reportFileName;
    }

    public ReportGenerationService getReportGenerationService() {
        return this.reportGenerationService;
    }

    public void setReportGenerationService(ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }

    public ReportInfo getContractsGrantsAwardBalancesReportInfo() {
        return this.contractsGrantsAwardBalancesReportInfo;
    }

    public void setContractsGrantsAwardBalancesReportInfo(ReportInfo contractsGrantsInvoiceReportInfo) {
        this.contractsGrantsAwardBalancesReportInfo = contractsGrantsInvoiceReportInfo;
    }
}

