/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Proposal;
import org.kuali.kfs.module.cg.businessobject.ProposalProjectDirector;
import org.kuali.kfs.module.cg.businessobject.ProposalResearchRisk;
import org.kuali.kfs.module.cg.businessobject.ProposalSubcontractor;
import org.kuali.kfs.module.cg.businessobject.ResearchRiskType;
import org.kuali.kfs.module.cg.businessobject.defaultvalue.NextProposalNumberFinder;
import org.kuali.kfs.module.cg.document.service.RoutingFormResearchRiskService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class ProposalMaintainableImpl
extends FinancialSystemMaintainable {
    public ProposalMaintainableImpl() {
    }

    public ProposalMaintainableImpl(Proposal proposal) {
        super((PersistableBusinessObject)proposal);
        this.setBoClass(((Object)((Object)proposal)).getClass());
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        this.getProposal().setProposalNumber(NextProposalNumberFinder.getLongValue());
        this.getProposal().setProposalClosingDate(null);
        super.processAfterCopy(document, parameters);
    }

    public void processAfterRetrieve() {
        this.refreshProposal(false);
        super.processAfterRetrieve();
    }

    public void prepareForSave() {
        List<ProposalSubcontractor> proposalSubcontractors;
        this.refreshProposal(false);
        List<ProposalProjectDirector> directors = this.getProposal().getProposalProjectDirectors();
        if (directors.size() == 1) {
            directors.get(0).setProposalPrimaryProjectDirectorIndicator(true);
        }
        if ((proposalSubcontractors = this.getProposal().getProposalSubcontractors()) != null && !proposalSubcontractors.isEmpty()) {
            int i = 0;
            for (ProposalSubcontractor proposalSubcontractor : proposalSubcontractors) {
                ++i;
                if (!StringUtils.isBlank((String)proposalSubcontractor.getProposalSubcontractorNumber())) continue;
                proposalSubcontractor.setProposalSubcontractorNumber("" + i);
            }
        }
        super.prepareForSave();
    }

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        this.refreshProposal("cf.kualiLookupable".equals(fieldValues.get("refreshCaller")));
        super.refresh(refreshCaller, fieldValues, document);
    }

    public void setGenerateDefaultValues(String docTypeName) {
        this.initResearchRiskTypes();
        super.setGenerateDefaultValues(docTypeName);
    }

    private void initResearchRiskTypes() {
        List<ProposalResearchRisk> risks = this.getProposal().getProposalResearchRisks();
        String[] riskTypeCodesToExclude = new String[]{};
        List<ResearchRiskType> researchRiskTypes = ((RoutingFormResearchRiskService)SpringContext.getBean(RoutingFormResearchRiskService.class)).getResearchRiskTypes(riskTypeCodesToExclude);
        for (ResearchRiskType type : researchRiskTypes) {
            ProposalResearchRisk ppr = new ProposalResearchRisk();
            ppr.setResearchRiskTypeCode(type.getResearchRiskTypeCode());
            ppr.setResearchRiskType(type);
            risks.add(ppr);
        }
    }

    private void refreshProposal(boolean refreshFromLookup) {
        this.getProposal().refreshNonUpdateableReferences();
        this.getNewCollectionLine("proposalSubcontractors").refreshNonUpdateableReferences();
        ProposalMaintainableImpl.refreshNonUpdateableReferences(this.getProposal().getProposalOrganizations());
        ProposalMaintainableImpl.refreshNonUpdateableReferences(this.getProposal().getProposalSubcontractors());
        ProposalMaintainableImpl.refreshNonUpdateableReferences(this.getProposal().getProposalResearchRisks());
        this.refreshProposalProjectDirectors(refreshFromLookup);
    }

    private void refreshProposalProjectDirectors(boolean refreshFromLookup) {
        if (refreshFromLookup) {
            this.getNewCollectionLine("proposalProjectDirectors").refreshNonUpdateableReferences();
            ProposalMaintainableImpl.refreshNonUpdateableReferences(this.getProposal().getProposalProjectDirectors());
        } else {
            ProposalMaintainableImpl.refreshWithSecondaryKey((ProposalProjectDirector)this.getNewCollectionLine("proposalProjectDirectors"));
            for (ProposalProjectDirector ppd : this.getProposal().getProposalProjectDirectors()) {
                ProposalMaintainableImpl.refreshWithSecondaryKey(ppd);
            }
        }
    }

    private static void refreshNonUpdateableReferences(Collection<? extends PersistableBusinessObject> collection) {
        for (PersistableBusinessObject persistableBusinessObject : collection) {
            persistableBusinessObject.refreshNonUpdateableReferences();
        }
    }

    private static void refreshWithSecondaryKey(ProposalProjectDirector ppd) {
        Principal person;
        String secondaryKey = null;
        if (ObjectUtils.isNotNull((Object)ppd.getProjectDirector())) {
            secondaryKey = ppd.getProjectDirector().getPrincipalName();
        }
        if (StringUtils.isNotBlank(secondaryKey)) {
            Principal dir = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(secondaryKey);
            ppd.setPrincipalId(dir == null ? null : dir.getPrincipalId());
        }
        if (StringUtils.isNotBlank((String)ppd.getPrincipalId()) && (person = KimApiServiceLocator.getIdentityService().getPrincipal(ppd.getPrincipalId())) != null) {
            ppd.refreshNonUpdateableReferences();
        }
    }

    public Proposal getProposal() {
        return (Proposal)this.getBusinessObject();
    }

    public void addNewLineToCollection(String collectionName) {
        this.refreshProposal(false);
        super.addNewLineToCollection(collectionName);
    }
}

