/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.businessobject;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.integration.ar.AccountsReceivableMilestoneSchedule;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.ar.AccountsReceivablePredeterminedBillingSchedule;
import org.kuali.kfs.integration.cg.CGIntegrationConstants;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsLetterOfCreditFund;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.businessobject.AwardOrganization;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.cg.businessobject.AwardStatus;
import org.kuali.kfs.module.cg.businessobject.AwardSubcontractor;
import org.kuali.kfs.module.cg.businessobject.BillingFrequency;
import org.kuali.kfs.module.cg.businessobject.GrantDescription;
import org.kuali.kfs.module.cg.businessobject.Proposal;
import org.kuali.kfs.module.cg.businessobject.ProposalAwardType;
import org.kuali.kfs.module.cg.businessobject.ProposalOrganization;
import org.kuali.kfs.module.cg.businessobject.ProposalProjectDirector;
import org.kuali.kfs.module.cg.businessobject.ProposalPurpose;
import org.kuali.kfs.module.cg.businessobject.ProposalSubcontractor;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class Award
extends PersistableBusinessObjectBase
implements MutableInactivatable,
ContractsAndGrantsBillingAward {
    private static final String AWARD_INQUIRY_TITLE_PROPERTY = "message.inquiry.award.title";
    private String proposalNumber;
    private Date awardBeginningDate;
    private Date awardEndingDate;
    private Date lastBilledDate;
    protected KualiDecimal awardTotalAmount;
    private String awardAddendumNumber;
    private KualiDecimal awardAllocatedUniversityComputingServicesAmount;
    private KualiDecimal federalPassThroughFundedAmount;
    private Date awardEntryDate;
    private KualiDecimal agencyFuture1Amount;
    private KualiDecimal agencyFuture2Amount;
    private KualiDecimal agencyFuture3Amount;
    private String awardDocumentNumber;
    private Timestamp awardLastUpdateDate;
    private boolean federalPassThroughIndicator;
    private String oldProposalNumber;
    private KualiDecimal awardDirectCostAmount;
    private KualiDecimal awardIndirectCostAmount;
    private KualiDecimal federalFundedAmount;
    private Timestamp awardCreateTimestamp;
    private Date awardClosingDate;
    private String proposalAwardTypeCode;
    private String awardStatusCode;
    private String letterOfCreditFundCode;
    private String grantDescriptionCode;
    private String agencyNumber;
    private String federalPassThroughAgencyNumber;
    private String agencyAnalystName;
    private String analystTelephoneNumber;
    private String billingFrequencyCode;
    private BillingFrequency billingFrequency;
    private String awardProjectTitle;
    private String awardPurposeCode;
    private boolean active;
    private String kimGroupNames;
    private List<AwardProjectDirector> awardProjectDirectors;
    private AwardProjectDirector awardPrimaryProjectDirector;
    private List<AwardFundManager> awardFundManagers;
    private AwardFundManager awardPrimaryFundManager;
    private List<AwardAccount> awardAccounts;
    private List<AwardSubcontractor> awardSubcontractors;
    private List<AwardOrganization> awardOrganizations;
    private Proposal proposal;
    private ProposalAwardType proposalAwardType;
    private AwardStatus awardStatus;
    protected ContractsAndGrantsLetterOfCreditFund letterOfCreditFund;
    private GrantDescription grantDescription;
    private Agency agency;
    private Agency federalPassThroughAgency;
    private ProposalPurpose awardPurpose;
    private AwardOrganization primaryAwardOrganization;
    private String routingOrg;
    private String routingChart;
    private boolean stateTransferIndicator;
    private boolean excludedFromInvoicing;
    private boolean additionalFormsRequiredIndicator;
    private String additionalFormsDescription;
    private String excludedFromInvoicingReason;
    private String instrumentTypeCode;
    private String invoicingOptionCode;
    private KualiDecimal minInvoiceAmount = KualiDecimal.ZERO;
    private boolean autoApproveIndicator;
    private AccountsReceivableMilestoneSchedule milestoneSchedule;
    private AccountsReceivablePredeterminedBillingSchedule predeterminedBillingSchedule;
    private Date fundingExpirationDate;
    private String dunningCampaign;
    private boolean stopWorkIndicator;
    private String stopWorkReason;
    private List<Note> boNotes;
    private transient String lookupPersonUniversalIdentifier;
    private transient Person lookupPerson;
    private final String userLookupRoleNamespaceCode = "KFS-SYS";
    private final String userLookupRoleName = "Contracts & Grants Project Director";
    private transient String lookupFundMgrPersonUniversalIdentifier;
    private transient Person lookupFundMgrPerson;

    public Award() {
        this.awardProjectDirectors = new ArrayList<AwardProjectDirector>();
        this.awardFundManagers = new ArrayList<AwardFundManager>();
        this.awardAccounts = new ArrayList<AwardAccount>();
        this.awardSubcontractors = new ArrayList<AwardSubcontractor>();
        this.awardOrganizations = new ArrayList<AwardOrganization>();
    }

    public String getExcludedFromInvoicingReason() {
        return this.excludedFromInvoicingReason;
    }

    public boolean isStateTransferIndicator() {
        return this.stateTransferIndicator;
    }

    public void setStateTransferIndicator(boolean stateTransferIndicator) {
        this.stateTransferIndicator = stateTransferIndicator;
    }

    public void setExcludedFromInvoicingReason(String excludedFromInvoicingReason) {
        this.excludedFromInvoicingReason = excludedFromInvoicingReason;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(ObjectUtils.isNull(this.getAwardAccounts()) ? new ArrayList() : new ArrayList<AwardAccount>(this.getAwardAccounts()));
        managedLists.add(ObjectUtils.isNull(this.getAwardOrganizations()) ? new ArrayList() : new ArrayList<AwardOrganization>(this.getAwardOrganizations()));
        managedLists.add(ObjectUtils.isNull(this.getAwardProjectDirectors()) ? new ArrayList() : new ArrayList<AwardProjectDirector>(this.getAwardProjectDirectors()));
        managedLists.add(ObjectUtils.isNull(this.getAwardFundManagers()) ? new ArrayList() : new ArrayList<AwardFundManager>(this.getAwardFundManagers()));
        managedLists.add(ObjectUtils.isNull(this.getAwardSubcontractors()) ? new ArrayList() : new ArrayList<AwardSubcontractor>(this.getAwardSubcontractors()));
        return managedLists;
    }

    public Award(Proposal proposal) {
        this();
        this.populateFromProposal(proposal);
    }

    public void populateFromProposal(Proposal proposal) {
        if (ObjectUtils.isNotNull((Object)((Object)proposal))) {
            this.setProposalNumber(proposal.getProposalNumber());
            this.setAgencyNumber(proposal.getAgencyNumber());
            this.setAwardProjectTitle(proposal.getProposalProjectTitle());
            this.setAwardDirectCostAmount(proposal.getProposalDirectCostAmount());
            this.setAwardIndirectCostAmount(proposal.getProposalIndirectCostAmount());
            this.setProposalAwardTypeCode(proposal.getProposalAwardTypeCode());
            this.setFederalPassThroughIndicator(proposal.getProposalFederalPassThroughIndicator());
            this.setFederalPassThroughAgencyNumber(proposal.getFederalPassThroughAgencyNumber());
            this.setAwardPurposeCode(proposal.getProposalPurposeCode());
            this.getAwardOrganizations().clear();
            for (ProposalOrganization pOrg : proposal.getProposalOrganizations()) {
                AwardOrganization awardOrg = new AwardOrganization();
                awardOrg.setNewCollectionRecord(true);
                awardOrg.setProposalNumber(pOrg.getProposalNumber().toString());
                awardOrg.setChartOfAccountsCode(pOrg.getChartOfAccountsCode());
                awardOrg.setOrganizationCode(pOrg.getOrganizationCode());
                awardOrg.setAwardPrimaryOrganizationIndicator(pOrg.isProposalPrimaryOrganizationIndicator());
                awardOrg.setActive(pOrg.isActive());
                this.getAwardOrganizations().add(awardOrg);
            }
            this.getAwardSubcontractors().clear();
            int awardSubcontractAmendment = 1;
            for (ProposalSubcontractor pSubcontractor : proposal.getProposalSubcontractors()) {
                AwardSubcontractor awardSubcontractor = new AwardSubcontractor();
                awardSubcontractor.setNewCollectionRecord(true);
                awardSubcontractor.setProposalNumber(pSubcontractor.getProposalNumber());
                awardSubcontractor.setAwardSubcontractorNumber(pSubcontractor.getProposalSubcontractorNumber());
                awardSubcontractor.setAwardSubcontractorAmendmentNumber(String.valueOf(awardSubcontractAmendment++));
                awardSubcontractor.setSubcontractorAmount(pSubcontractor.getProposalSubcontractorAmount());
                awardSubcontractor.setAwardSubcontractorDescription(pSubcontractor.getProposalSubcontractorDescription());
                awardSubcontractor.setSubcontractorNumber(pSubcontractor.getSubcontractorNumber());
                awardSubcontractor.setActive(pSubcontractor.isActive());
                this.getAwardSubcontractors().add(awardSubcontractor);
            }
            this.getAwardProjectDirectors().clear();
            for (ProposalProjectDirector pDirector : proposal.getProposalProjectDirectors()) {
                AwardProjectDirector awardDirector = new AwardProjectDirector();
                awardDirector.setNewCollectionRecord(true);
                awardDirector.setProposalNumber(pDirector.getProposalNumber());
                awardDirector.setAwardPrimaryProjectDirectorIndicator(pDirector.isProposalPrimaryProjectDirectorIndicator());
                awardDirector.setAwardProjectDirectorProjectTitle(pDirector.getProposalProjectDirectorProjectTitle());
                awardDirector.setPrincipalId(pDirector.getPrincipalId());
                awardDirector.setActive(pDirector.isActive());
                this.getAwardProjectDirectors().add(awardDirector);
            }
        }
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public Date getAwardBeginningDate() {
        return this.awardBeginningDate;
    }

    public void setAwardBeginningDate(Date awardBeginningDate) {
        this.awardBeginningDate = awardBeginningDate;
    }

    public Date getAwardEndingDate() {
        return this.awardEndingDate;
    }

    public String getKimGroupNames() {
        return this.kimGroupNames;
    }

    public void setKimGroupNames(String kimGroupNames) {
        this.kimGroupNames = kimGroupNames;
    }

    public void setAwardEndingDate(Date awardEndingDate) {
        this.awardEndingDate = awardEndingDate;
    }

    public Date getLastBilledDate() {
        return ((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).getLastBilledDate((ContractsAndGrantsBillingAward)this);
    }

    public KualiDecimal getAwardTotalAmount() {
        KualiDecimal direct = this.getAwardDirectCostAmount();
        KualiDecimal indirect = this.getAwardIndirectCostAmount();
        return ObjectUtils.isNull((Object)direct) || ObjectUtils.isNull((Object)indirect) ? null : (KualiDecimal)direct.add((AbstractKualiDecimal)indirect);
    }

    @Deprecated
    public void setAwardTotalAmount(KualiDecimal awardTotalAmount) {
    }

    protected void prePersist() {
        super.prePersist();
        this.awardTotalAmount = this.getAwardTotalAmount();
    }

    protected void preUpdate() {
        super.preUpdate();
        this.awardTotalAmount = this.getAwardTotalAmount();
    }

    public String getAwardAddendumNumber() {
        return this.awardAddendumNumber;
    }

    public void setAwardAddendumNumber(String awardAddendumNumber) {
        this.awardAddendumNumber = awardAddendumNumber;
    }

    public KualiDecimal getAwardAllocatedUniversityComputingServicesAmount() {
        return this.awardAllocatedUniversityComputingServicesAmount;
    }

    public void setAwardAllocatedUniversityComputingServicesAmount(KualiDecimal awardAllocatedUniversityComputingServicesAmount) {
        this.awardAllocatedUniversityComputingServicesAmount = awardAllocatedUniversityComputingServicesAmount;
    }

    public KualiDecimal getFederalPassThroughFundedAmount() {
        return this.federalPassThroughFundedAmount;
    }

    public void setFederalPassThroughFundedAmount(KualiDecimal federalPassThroughFundedAmount) {
        this.federalPassThroughFundedAmount = federalPassThroughFundedAmount;
    }

    public Date getAwardEntryDate() {
        return this.awardEntryDate;
    }

    public void setAwardEntryDate(Date awardEntryDate) {
        this.awardEntryDate = awardEntryDate;
    }

    public KualiDecimal getAgencyFuture1Amount() {
        return this.agencyFuture1Amount;
    }

    public void setAgencyFuture1Amount(KualiDecimal agencyFuture1Amount) {
        this.agencyFuture1Amount = agencyFuture1Amount;
    }

    public KualiDecimal getAgencyFuture2Amount() {
        return this.agencyFuture2Amount;
    }

    public void setAgencyFuture2Amount(KualiDecimal agencyFuture2Amount) {
        this.agencyFuture2Amount = agencyFuture2Amount;
    }

    public KualiDecimal getAgencyFuture3Amount() {
        return this.agencyFuture3Amount;
    }

    public void setAgencyFuture3Amount(KualiDecimal agencyFuture3Amount) {
        this.agencyFuture3Amount = agencyFuture3Amount;
    }

    public String getAwardDocumentNumber() {
        return this.awardDocumentNumber;
    }

    public void setAwardDocumentNumber(String awardDocumentNumber) {
        this.awardDocumentNumber = awardDocumentNumber;
    }

    public Timestamp getAwardLastUpdateDate() {
        return this.awardLastUpdateDate;
    }

    public void setAwardLastUpdateDate(Timestamp awardLastUpdateDate) {
        this.awardLastUpdateDate = awardLastUpdateDate;
    }

    public boolean getFederalPassThroughIndicator() {
        return this.federalPassThroughIndicator;
    }

    public void setFederalPassThroughIndicator(boolean federalPassThroughIndicator) {
        this.federalPassThroughIndicator = federalPassThroughIndicator;
    }

    public String getOldProposalNumber() {
        return this.oldProposalNumber;
    }

    public void setOldProposalNumber(String oldProposalNumber) {
        this.oldProposalNumber = oldProposalNumber;
    }

    public KualiDecimal getAwardDirectCostAmount() {
        return this.awardDirectCostAmount;
    }

    public void setAwardDirectCostAmount(KualiDecimal awardDirectCostAmount) {
        this.awardDirectCostAmount = awardDirectCostAmount;
    }

    public KualiDecimal getAwardIndirectCostAmount() {
        return this.awardIndirectCostAmount;
    }

    public void setAwardIndirectCostAmount(KualiDecimal awardIndirectCostAmount) {
        this.awardIndirectCostAmount = awardIndirectCostAmount;
    }

    public KualiDecimal getFederalFundedAmount() {
        return this.federalFundedAmount;
    }

    public void setFederalFundedAmount(KualiDecimal federalFundedAmount) {
        this.federalFundedAmount = federalFundedAmount;
    }

    public Timestamp getAwardCreateTimestamp() {
        return this.awardCreateTimestamp;
    }

    public void setAwardCreateTimestamp(Timestamp awardCreateTimestamp) {
        this.awardCreateTimestamp = awardCreateTimestamp;
    }

    public Date getAwardClosingDate() {
        return this.awardClosingDate;
    }

    public void setAwardClosingDate(Date awardClosingDate) {
        this.awardClosingDate = awardClosingDate;
    }

    public String getProposalAwardTypeCode() {
        return this.proposalAwardTypeCode;
    }

    public void setProposalAwardTypeCode(String proposalAwardTypeCode) {
        this.proposalAwardTypeCode = proposalAwardTypeCode;
    }

    public String getAwardStatusCode() {
        return this.awardStatusCode;
    }

    public void setAwardStatusCode(String awardStatusCode) {
        this.awardStatusCode = awardStatusCode;
    }

    public String getLetterOfCreditFundCode() {
        return this.letterOfCreditFundCode;
    }

    public void setLetterOfCreditFundCode(String letterOfCreditFundCode) {
        this.letterOfCreditFundCode = letterOfCreditFundCode;
    }

    public String getGrantDescriptionCode() {
        return this.grantDescriptionCode;
    }

    public void setGrantDescriptionCode(String grantDescriptionCode) {
        this.grantDescriptionCode = grantDescriptionCode;
    }

    public String getAgencyNumber() {
        return this.agencyNumber;
    }

    public void setAgencyNumber(String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public String getFederalPassThroughAgencyNumber() {
        return this.federalPassThroughAgencyNumber;
    }

    public void setFederalPassThroughAgencyNumber(String federalPassThroughAgencyNumber) {
        this.federalPassThroughAgencyNumber = federalPassThroughAgencyNumber;
    }

    public String getAgencyAnalystName() {
        return this.agencyAnalystName;
    }

    public void setAgencyAnalystName(String agencyAnalystName) {
        this.agencyAnalystName = agencyAnalystName;
    }

    public String getAnalystTelephoneNumber() {
        return this.analystTelephoneNumber;
    }

    public void setAnalystTelephoneNumber(String analystTelephoneNumber) {
        this.analystTelephoneNumber = analystTelephoneNumber;
    }

    public String getAwardProjectTitle() {
        return this.awardProjectTitle;
    }

    public void setAwardProjectTitle(String awardProjectTitle) {
        this.awardProjectTitle = awardProjectTitle;
    }

    public String getAwardPurposeCode() {
        return this.awardPurposeCode;
    }

    public void setAwardPurposeCode(String awardPurposeCode) {
        this.awardPurposeCode = awardPurposeCode;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Proposal getProposal() {
        return this.proposal;
    }

    @Deprecated
    public void setProposal(Proposal proposal) {
        this.proposal = proposal;
    }

    public ProposalAwardType getProposalAwardType() {
        return this.proposalAwardType;
    }

    @Deprecated
    public void setProposalAwardType(ProposalAwardType proposalAwardType) {
        this.proposalAwardType = proposalAwardType;
    }

    public AwardStatus getAwardStatus() {
        return this.awardStatus;
    }

    @Deprecated
    public void setAwardStatus(AwardStatus awardStatus) {
        this.awardStatus = awardStatus;
    }

    public ContractsAndGrantsLetterOfCreditFund getLetterOfCreditFund() {
        return this.letterOfCreditFund;
    }

    @Deprecated
    public void setLetterOfCreditFund(ContractsAndGrantsLetterOfCreditFund letterOfCreditFund) {
        this.letterOfCreditFund = letterOfCreditFund;
    }

    public GrantDescription getGrantDescription() {
        return this.grantDescription;
    }

    @Deprecated
    public void setGrantDescription(GrantDescription grantDescription) {
        this.grantDescription = grantDescription;
    }

    public Agency getAgency() {
        return this.agency;
    }

    @Deprecated
    public void setAgency(Agency agency) {
        this.agency = agency;
    }

    public Agency getFederalPassThroughAgency() {
        return this.federalPassThroughAgency;
    }

    @Deprecated
    public void setFederalPassThroughAgency(Agency federalPassThroughAgency) {
        this.federalPassThroughAgency = federalPassThroughAgency;
    }

    public ProposalPurpose getAwardPurpose() {
        return this.awardPurpose;
    }

    @Deprecated
    public void setAwardPurpose(ProposalPurpose awardPurpose) {
        this.awardPurpose = awardPurpose;
    }

    public List<AwardProjectDirector> getAwardProjectDirectors() {
        return this.awardProjectDirectors;
    }

    public void setAwardProjectDirectors(List<AwardProjectDirector> awardProjectDirectors) {
        this.awardProjectDirectors = awardProjectDirectors;
    }

    public List<AwardFundManager> getAwardFundManagers() {
        return this.awardFundManagers;
    }

    public void setAwardFundManagers(List<AwardFundManager> awardFundManagers) {
        this.awardFundManagers = awardFundManagers;
    }

    public List<AwardAccount> getAwardAccounts() {
        return this.awardAccounts;
    }

    public List<ContractsAndGrantsBillingAwardAccount> getActiveAwardAccounts() {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        for (AwardAccount awardAccount : this.awardAccounts) {
            if (!awardAccount.isActive()) continue;
            activeAwardAccounts.add(awardAccount);
        }
        return activeAwardAccounts;
    }

    public void setAwardAccounts(List<AwardAccount> awardAccounts) {
        this.awardAccounts = awardAccounts;
    }

    public List<AwardOrganization> getAwardOrganizations() {
        return this.awardOrganizations;
    }

    public void setAwardOrganizations(List<AwardOrganization> awardOrganizations) {
        this.awardOrganizations = awardOrganizations;
    }

    public List<AwardSubcontractor> getAwardSubcontractors() {
        return this.awardSubcontractors;
    }

    public void setAwardSubcontractors(List<AwardSubcontractor> awardSubcontractors) {
        this.awardSubcontractors = awardSubcontractors;
    }

    public AwardOrganization getPrimaryAwardOrganization() {
        for (AwardOrganization ao : this.awardOrganizations) {
            if (ao == null || !ao.isAwardPrimaryOrganizationIndicator()) continue;
            this.setPrimaryAwardOrganization(ao);
            break;
        }
        return this.primaryAwardOrganization;
    }

    public void setPrimaryAwardOrganization(AwardOrganization primaryAwardOrganization) {
        this.primaryAwardOrganization = primaryAwardOrganization;
        this.routingChart = primaryAwardOrganization.getChartOfAccountsCode();
        this.routingOrg = primaryAwardOrganization.getOrganizationCode();
    }

    public KualiDecimal getAwardSubcontractorsTotalAmount() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (AwardSubcontractor subcontractor : this.getAwardSubcontractors()) {
            KualiDecimal amount = subcontractor.getSubcontractorAmount();
            if (!ObjectUtils.isNotNull((Object)amount)) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)amount);
        }
        return total;
    }

    public String getRoutingChart() {
        return this.routingChart;
    }

    public void setRoutingChart(String routingChart) {
        this.routingChart = routingChart;
    }

    public String getRoutingOrg() {
        return this.routingOrg;
    }

    public void setRoutingOrg(String routingOrg) {
        this.routingOrg = routingOrg;
    }

    public Person getLookupPerson() {
        return this.lookupPerson;
    }

    public void setLookupPerson(Person lookupPerson) {
        this.lookupPerson = lookupPerson;
    }

    public String getLookupPersonUniversalIdentifier() {
        this.lookupPerson = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.lookupPersonUniversalIdentifier, this.lookupPerson);
        return this.lookupPersonUniversalIdentifier;
    }

    public void setLookupPersonUniversalIdentifier(String lookupPersonId) {
        this.lookupPersonUniversalIdentifier = lookupPersonId;
    }

    public String getUserLookupRoleNamespaceCode() {
        return "KFS-SYS";
    }

    public String getUserLookupRoleName() {
        return "Contracts & Grants Project Director";
    }

    public String getAwardInquiryTitle() {
        return ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString(AWARD_INQUIRY_TITLE_PROPERTY);
    }

    public void setAwardInquiryTitle(String inquiryTitle) {
    }

    public String getBillingFrequencyCode() {
        return this.billingFrequencyCode;
    }

    public void setBillingFrequencyCode(String billingFrequencyCode) {
        this.billingFrequencyCode = billingFrequencyCode;
    }

    public boolean isExcludedFromInvoicing() {
        return this.excludedFromInvoicing;
    }

    public void setExcludedFromInvoicing(boolean excludedFromInvoicing) {
        this.excludedFromInvoicing = excludedFromInvoicing;
    }

    public boolean isAdditionalFormsRequiredIndicator() {
        return this.additionalFormsRequiredIndicator;
    }

    public void setAdditionalFormsRequiredIndicator(boolean additionalFormsRequiredIndicator) {
        this.additionalFormsRequiredIndicator = additionalFormsRequiredIndicator;
    }

    public String getAdditionalFormsDescription() {
        return this.additionalFormsDescription;
    }

    public void setAdditionalFormsDescription(String additionalFormsDescription) {
        this.additionalFormsDescription = additionalFormsDescription;
    }

    public String getInstrumentTypeCode() {
        return this.instrumentTypeCode;
    }

    public void setInstrumentTypeCode(String instrumentTypeCode) {
        this.instrumentTypeCode = instrumentTypeCode;
    }

    public BillingFrequency getBillingFrequency() {
        return this.billingFrequency;
    }

    public void setBillingFrequency(BillingFrequency billingFrequency) {
        this.billingFrequency = billingFrequency;
    }

    public boolean getAutoApproveIndicator() {
        return this.autoApproveIndicator;
    }

    public void setAutoApproveIndicator(boolean autoApproveIndicator) {
        this.autoApproveIndicator = autoApproveIndicator;
    }

    public KualiDecimal getMinInvoiceAmount() {
        return this.minInvoiceAmount;
    }

    public void setMinInvoiceAmount(KualiDecimal minInvoiceAmount) {
        this.minInvoiceAmount = minInvoiceAmount;
    }

    public String getInvoicingOptionCode() {
        return this.invoicingOptionCode;
    }

    public String getInvoicingOptionDescription() {
        return CGIntegrationConstants.AwardInvoicingOption.Types.get((String)this.invoicingOptionCode);
    }

    public void setInvoicingOptionCode(String invoicingOptionCode) {
        this.invoicingOptionCode = invoicingOptionCode;
    }

    public AccountsReceivableMilestoneSchedule getMilestoneSchedule() {
        return this.milestoneSchedule;
    }

    public void setMilestoneSchedule(AccountsReceivableMilestoneSchedule milestoneSchedule) {
        this.milestoneSchedule = milestoneSchedule;
    }

    public AccountsReceivablePredeterminedBillingSchedule getPredeterminedBillingSchedule() {
        return this.predeterminedBillingSchedule;
    }

    public void setPredeterminedBillingSchedule(AccountsReceivablePredeterminedBillingSchedule predeterminedBillingSchedule) {
        this.predeterminedBillingSchedule = predeterminedBillingSchedule;
    }

    public AwardProjectDirector getAwardPrimaryProjectDirector() {
        for (AwardProjectDirector awdProjMgr : this.awardProjectDirectors) {
            if (awdProjMgr == null || !awdProjMgr.isAwardPrimaryProjectDirectorIndicator()) continue;
            return awdProjMgr;
        }
        return null;
    }

    public void setAwardPrimaryProjectDirector(AwardProjectDirector awardPrimaryProjectDirector) {
        this.awardPrimaryProjectDirector = awardPrimaryProjectDirector;
    }

    public AwardFundManager getAwardPrimaryFundManager() {
        for (AwardFundManager awdFundMgr : this.awardFundManagers) {
            if (awdFundMgr == null || !awdFundMgr.isPrimaryFundManagerIndicator()) continue;
            return awdFundMgr;
        }
        return this.awardPrimaryFundManager;
    }

    public void setAwardPrimaryFundManager(AwardFundManager awardPrimaryFundManager) {
        this.awardPrimaryFundManager = awardPrimaryFundManager;
    }

    public String getLookupFundMgrPersonUniversalIdentifier() {
        return this.lookupFundMgrPersonUniversalIdentifier;
    }

    public void setLookupFundMgrPersonUniversalIdentifier(String lookupFundMgrPersonUniversalIdentifier) {
        this.lookupFundMgrPersonUniversalIdentifier = lookupFundMgrPersonUniversalIdentifier;
    }

    public Person getLookupFundMgrPerson() {
        return this.lookupFundMgrPerson;
    }

    public void setLookupFundMgrPerson(Person lookupFundMgrPerson) {
        this.lookupFundMgrPerson = lookupFundMgrPerson;
    }

    public Date getFundingExpirationDate() {
        return this.fundingExpirationDate;
    }

    public void setFundingExpirationDate(Date fundingExpirationDate) {
        this.fundingExpirationDate = fundingExpirationDate;
    }

    public String getDunningCampaign() {
        return this.dunningCampaign;
    }

    public void setDunningCampaign(String dunningCampaign) {
        this.dunningCampaign = dunningCampaign;
    }

    public boolean isStopWorkIndicator() {
        return this.stopWorkIndicator;
    }

    public void setStopWorkIndicator(boolean stopWorkIndicator) {
        this.stopWorkIndicator = stopWorkIndicator;
    }

    public String getStopWorkReason() {
        return this.stopWorkReason;
    }

    public void setStopWorkReason(String stopWorkReason) {
        this.stopWorkReason = stopWorkReason;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (ObjectUtils.isNotNull((Object)this.proposalNumber)) {
            m.put("proposalNumber", this.proposalNumber.toString());
        }
        return m;
    }

    public List<Note> getBoNotes() {
        List<Object> boNotes = new ArrayList<Note>();
        if (StringUtils.isNotBlank((String)this.getObjectId())) {
            boNotes = ((NoteService)SpringContext.getBean(NoteService.class)).getByRemoteObjectId(this.getObjectId());
        }
        return boNotes;
    }

    public void setBoNotes(List boNotes) {
        this.boNotes = boNotes;
    }
}

