/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.AgencyAddress;
import org.kuali.kfs.module.cg.document.validation.impl.AgencyRule;
import org.kuali.kfs.module.cg.fixture.AgencyFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.MaintenanceRuleTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class AgencyRuleTest
extends MaintenanceRuleTestBase {
    private AgencyRule rule;
    private Agency agency;
    private AgencyAddress agencyAddress;
    private BusinessObjectService boService;
    private Long agencyNumber;
    private static final String AGENCY_ADDRESS_NAME = "Address Name";
    private static final String AGENCY_ADDRESS_COUNTRY_CODE_US = "US";
    private static final String AGENCY_ADDRESS_COUNTRY_CODE_RO = "RO";
    private static final String AGENCY_ADDRESS_STATE_CODE = "NY";
    private static final String AGENCY_ADDRESS_ZIP_CODE = "14850";
    private static final String AGENCY_ADDRESS_PROVINCE = "Iasi";

    public void setUp() throws Exception {
        super.setUp();
        this.agencyNumber = new Long(12500L);
        this.boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.agency = new Agency();
        this.agencyAddress = new AgencyAddress();
        this.rule = (AgencyRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.agency), AgencyRule.class);
    }

    public void testCheckAgencyReportsTo_True() {
        this.agency = (Agency)this.boService.findBySinglePrimaryKey(Agency.class, (Object)this.agencyNumber);
        AgencyRuleTest.assertTrue((boolean)this.rule.checkAgencyReportsTo(this.newMaintDoc((PersistableBusinessObject)this.agency)));
    }

    public void testValidateAgencyType_True() {
        this.rule.newAgency = this.agency = AgencyFixture.CG_AGENCY1.createAgency();
        AgencyRuleTest.assertTrue((boolean)this.rule.validateAgencyType(this.newMaintDoc((PersistableBusinessObject)this.agency)));
    }

    public void testValidateAgencyReportingName_True() {
        this.rule.newAgency = this.agency = AgencyFixture.CG_AGENCY1.createAgency();
        AgencyRuleTest.assertTrue((boolean)this.rule.validateAgencyReportingName(this.newMaintDoc((PersistableBusinessObject)this.agency)));
    }

    public void testCheckAddressIsValid_CountryUS_False() {
        this.agencyAddress.setAgencyAddressName(AGENCY_ADDRESS_NAME);
        this.agencyAddress.setAgencyCountryCode(AGENCY_ADDRESS_COUNTRY_CODE_US);
        this.agencyAddress.setAgencyStateCode("");
        this.agencyAddress.setAgencyZipCode("");
        this.agency.setCustomerCreationOptionCode("C");
        this.rule.newAgency = this.agency;
        AgencyRule rule = (AgencyRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.agency), AgencyRule.class);
        boolean result = rule.checkAddressIsValid(this.agencyAddress);
        AgencyRuleTest.assertEquals((String)"When agency address has country code US and state code and zip code are empty checkAddressIsValid should return false. ", (boolean)false, (boolean)result);
    }

    public void testCheckAddressIsValid_CountryNonUS_False() {
        this.agencyAddress.setAgencyAddressName(AGENCY_ADDRESS_NAME);
        this.agencyAddress.setAgencyCountryCode(AGENCY_ADDRESS_COUNTRY_CODE_RO);
        this.agencyAddress.setAgencyAddressInternationalProvinceName("");
        this.agencyAddress.setAgencyZipCode("");
        this.agency.setCustomerCreationOptionCode("C");
        this.rule.newAgency = this.agency;
        AgencyRule rule = (AgencyRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.agency), AgencyRule.class);
        boolean result = rule.checkAddressIsValid(this.agencyAddress);
        AgencyRuleTest.assertEquals((String)"When agency address has country code RO and province and International Mail Code are empty checkAddressIsValid should return false. ", (boolean)false, (boolean)result);
    }
}

