/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableBillingFrequency;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.businessobject.AwardOrganization;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.cg.businessobject.AwardSubcontractor;
import org.kuali.kfs.module.cg.document.validation.impl.AwardRuleUtil;
import org.kuali.kfs.module.cg.document.validation.impl.CGMaintenanceDocumentRuleBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class AwardRule
extends CGMaintenanceDocumentRuleBase {
    protected static Logger LOG = Logger.getLogger(AwardRule.class);
    protected Award newAwardCopy;
    protected Award oldAwardCopy;

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug((Object)"Entering AwardRule.processCustomSaveDocumentBusinessRules");
        this.processCustomRouteDocumentBusinessRules(document);
        LOG.info((Object)"Leaving AwardRule.processCustomSaveDocumentBusinessRules");
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug((Object)"Entering AwardRule.processCustomRouteDocumentBusinessRules");
        boolean success = true;
        success &= this.checkProposal();
        success &= this.checkEndAfterBegin(this.newAwardCopy.getAwardBeginningDate(), this.newAwardCopy.getAwardEndingDate(), "awardEndingDate");
        success &= this.checkPrimary(this.newAwardCopy.getAwardOrganizations(), AwardOrganization.class, "awardOrganizations", Award.class);
        success &= this.checkPrimary(this.newAwardCopy.getAwardProjectDirectors(), AwardProjectDirector.class, "awardProjectDirectors", Award.class);
        success &= this.checkForDuplicateAccoutnts();
        success &= this.checkForDuplicateAwardProjectDirector();
        success &= this.checkForDuplicateAwardOrganization();
        success &= this.checkAccounts();
        success &= this.checkProjectDirectorsExist(this.newAwardCopy.getAwardProjectDirectors(), AwardProjectDirector.class, "awardProjectDirectors");
        success &= this.checkFundManagersExist(this.newAwardCopy.getAwardFundManagers(), "awardFundManagers");
        success &= this.checkProjectDirectorsExist(this.newAwardCopy.getAwardAccounts(), AwardAccount.class, "awardAccounts");
        success &= this.checkProjectDirectorsStatuses(this.newAwardCopy.getAwardProjectDirectors(), AwardProjectDirector.class, "awardProjectDirectors");
        success &= this.checkFederalPassThrough();
        success &= this.checkExcludedFromInvoicing();
        success &= this.checkAgencyNotEqualToFederalPassThroughAgency(this.newAwardCopy.getAgency(), this.newAwardCopy.getFederalPassThroughAgency(), "agencyNumber", "federalPassThroughAgencyNumber");
        success &= this.checkStopWorkReason();
        if (this.contractsGrantsBillingEnhancementActive) {
            success &= this.checkPrimary(this.newAwardCopy.getAwardFundManagers(), AwardFundManager.class, "awardFundManagers", Award.class);
            success &= this.checkInvoicingOption();
            success &= this.checkNumberOfAccountsForBillingFrequency();
            success &= this.checkBillingFrequency();
        }
        LOG.info((Object)"Leaving AwardRule.processCustomRouteDocumentBusinessRules");
        return success;
    }

    protected boolean checkExcludedFromInvoicing() {
        if (this.newAwardCopy.isExcludedFromInvoicing()) {
            if (ObjectUtils.isNotNull((Object)this.newAwardCopy.getExcludedFromInvoicingReason())) {
                return true;
            }
            this.putFieldError("excludedFromInvoicingReason", "error.cg.excludedFromInvoicingReasonRequired");
            return false;
        }
        return true;
    }

    protected boolean checkAccounts() {
        boolean success = true;
        List<AwardAccount> awardAccounts = this.newAwardCopy.getAwardAccounts();
        if (ObjectUtils.isNull(awardAccounts) || awardAccounts.isEmpty()) {
            String elementLabel = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getCollectionElementLabel(Award.class.getName(), "awardAccounts", AwardAccount.class);
            this.putFieldError("awardAccounts", "error.cg.oneRequired", elementLabel);
            success = false;
        }
        return success;
    }

    protected boolean checkProposal() {
        boolean success = true;
        if (AwardRuleUtil.isProposalAwarded(this.newAwardCopy)) {
            this.putFieldError("proposalNumber", "error.cg.award.proposal.awarded", this.newAwardCopy.getProposalNumber().toString());
            success = false;
        }
        return success;
    }

    protected boolean checkFederalPassThrough() {
        boolean success = true;
        success = super.checkFederalPassThrough(this.newAwardCopy.getFederalPassThroughIndicator(), this.newAwardCopy.getAgency(), this.newAwardCopy.getFederalPassThroughAgencyNumber(), Award.class, "federalPassThroughIndicator");
        if (this.newAwardCopy.getFederalPassThroughIndicator()) {
            String indicatorLabel = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeErrorLabel(Award.class, "federalPassThroughIndicator");
            if (StringUtils.isBlank((String)this.newAwardCopy.getFederalPassThroughAgencyNumber())) {
                this.putFieldError("federalPassThroughAgencyNumber", "error.cg.federalPassThroughAgencyIndicatorIsChecked");
                success = false;
            }
        }
        return success;
    }

    public void setupConvenienceObjects() {
        this.newAwardCopy = (Award)((Object)super.getNewBo());
        this.oldAwardCopy = (Award)((Object)super.getOldBo());
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject bo) {
        boolean success = true;
        if (bo instanceof AwardProjectDirector) {
            AwardProjectDirector awardProjectDirector = (AwardProjectDirector)bo;
            success = this.checkAwardProjectDirector(awardProjectDirector);
        } else if (bo instanceof AwardFundManager) {
            AwardFundManager awardFundManager = (AwardFundManager)bo;
            success = this.checkAwardFundManager(awardFundManager);
        } else if (bo instanceof AwardAccount) {
            AwardAccount awardAccount = (AwardAccount)bo;
            success = this.checkAwardAccount(awardAccount);
        } else if (bo instanceof AwardSubcontractor) {
            AwardSubcontractor awardSubcontractor = (AwardSubcontractor)bo;
            success = this.checkAwardSubcontractor(awardSubcontractor);
        } else if (bo instanceof AwardOrganization) {
            AwardOrganization awardOrganization = (AwardOrganization)bo;
            success = this.checkAwardOrganization(awardOrganization);
        }
        return success;
    }

    public boolean processAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        if (line instanceof AwardFundManager) {
            AwardFundManager newAwardFundManager = (AwardFundManager)line;
            if (collectionName.equals("awardFundManagers")) {
                this.newAwardCopy = (Award)document.getNewMaintainableObject().getBusinessObject();
                List<AwardFundManager> awardFundManagers = this.newAwardCopy.getAwardFundManagers();
                int count = 0;
                for (AwardFundManager awardFundManager : awardFundManagers) {
                    if (!awardFundManager.isPrimary()) continue;
                    ++count;
                    if (!newAwardFundManager.isPrimary()) continue;
                    String elementLabel = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getCollectionElementLabel(Award.class.getName(), collectionName, AwardFundManager.class);
                    this.putFieldError(collectionName, "error.cg.multiplePrimary", elementLabel);
                    return false;
                }
                if (count > 1) {
                    String elementLabel = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getCollectionElementLabel(Award.class.getName(), collectionName, AwardFundManager.class);
                    this.putFieldError(collectionName, "error.cg.multiplePrimary", elementLabel);
                    return false;
                }
            }
        }
        return super.processAddCollectionLineBusinessRules(document, collectionName, line);
    }

    protected boolean checkAwardOrganization(AwardOrganization awardOrganization) {
        boolean success = true;
        int originalErrorCount = GlobalVariables.getMessageMap().getErrorCount();
        String errorPathPrefix = "add.awardOrganizations.";
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)awardOrganization);
        if (StringUtils.isNotBlank((String)awardOrganization.getOrganizationCode()) && StringUtils.isNotBlank((String)awardOrganization.getChartOfAccountsCode())) {
            awardOrganization.refreshReferenceObject("organization");
            if (ObjectUtils.isNull((Object)awardOrganization.getOrganization())) {
                String label = this.getDataDictionaryService().getAttributeLabel(AwardOrganization.class, "organizationCode");
                String message = label + "(" + awardOrganization.getOrganizationCode() + ")";
                this.putFieldError(errorPathPrefix + "organizationCode", "error.existence", message);
            }
        }
        return success &= GlobalVariables.getMessageMap().getErrorCount() == originalErrorCount;
    }

    protected boolean checkAwardSubcontractor(AwardSubcontractor awardSubcontractor) {
        boolean success = true;
        int originalErrorCount = GlobalVariables.getMessageMap().getErrorCount();
        String errorPathPrefix = "add.awardSubcontractors.";
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)awardSubcontractor);
        if (StringUtils.isNotBlank((String)awardSubcontractor.getSubcontractorNumber())) {
            awardSubcontractor.refreshReferenceObject("subcontractor");
            if (ObjectUtils.isNull((Object)((Object)awardSubcontractor.getSubcontractor()))) {
                String label = this.getDataDictionaryService().getAttributeLabel(AwardSubcontractor.class, "subcontractorNumber");
                String message = label + "(" + awardSubcontractor.getSubcontractorNumber() + ")";
                this.putFieldError(errorPathPrefix + "subcontractorNumber", "error.existence", message);
            }
        }
        return success &= GlobalVariables.getMessageMap().getErrorCount() == originalErrorCount;
    }

    protected boolean checkAwardAccount(AwardAccount awardAccount) {
        boolean success = true;
        int originalErrorCount = GlobalVariables.getMessageMap().getErrorCount();
        String errorPathPrefix = "add.awardAccounts.";
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)awardAccount);
        if (StringUtils.isNotBlank((String)awardAccount.getAccountNumber()) && StringUtils.isNotBlank((String)awardAccount.getChartOfAccountsCode())) {
            awardAccount.refreshReferenceObject("account");
            if (ObjectUtils.isNull((Object)awardAccount.getAccount())) {
                String label = this.getDataDictionaryService().getAttributeLabel(AwardAccount.class, "accountNumber");
                String message = label + "(" + awardAccount.getChartOfAccountsCode() + "-" + awardAccount.getAccountNumber() + ")";
                this.putFieldError(errorPathPrefix + "accountNumber", "error.existence", message);
            }
        }
        Person projectDirector = awardAccount.getProjectDirector();
        if (StringUtils.isBlank((String)awardAccount.getPrincipalId()) || ObjectUtils.isNull((Object)projectDirector)) {
            String label = this.getDataDictionaryService().getAttributeLabel(AwardAccount.class, "projectDirector.principalName");
            String message = label + "(" + awardAccount.getPrincipalId() + ")";
            this.putFieldError(errorPathPrefix + "projectDirector.principalName", "error.existence", message);
        }
        return success &= GlobalVariables.getMessageMap().getErrorCount() == originalErrorCount;
    }

    protected boolean checkAwardProjectDirector(AwardProjectDirector awardProjectDirector) {
        boolean success = true;
        Person projectDirector = awardProjectDirector.getProjectDirector();
        if (StringUtils.isBlank((String)awardProjectDirector.getPrincipalId()) || ObjectUtils.isNull((Object)projectDirector)) {
            String errorPath = "add.awardProjectDirectors.projectDirector.principalName";
            String label = this.getDataDictionaryService().getAttributeLabel(AwardProjectDirector.class, "projectDirector.principalName");
            String message = label + "(" + awardProjectDirector.getPrincipalId() + ")";
            this.putFieldError(errorPath, "error.existence", message);
            success &= false;
        }
        return success;
    }

    protected boolean checkForDuplicateAccoutnts() {
        boolean success = true;
        List<AwardAccount> awardAccounts = this.newAwardCopy.getAwardAccounts();
        HashSet<String> accountHash = new HashSet<String>();
        for (AwardAccount account : awardAccounts) {
            if (account == null || !StringUtils.isNotEmpty((String)account.getAccountNumber())) continue;
            String accountNumber = account.getAccountNumber();
            String accountChart = account.getChartOfAccountsCode();
            if (accountHash.add(accountChart + accountNumber)) continue;
            this.putFieldError("awardAccounts", "error.cg.duplicate.awardAccount", accountChart + "-" + accountNumber);
            return false;
        }
        return success;
    }

    protected boolean checkForDuplicateAwardProjectDirector() {
        boolean success = true;
        List<AwardProjectDirector> awardProjectDirectors = this.newAwardCopy.getAwardProjectDirectors();
        HashSet<String> principalIdHash = new HashSet<String>();
        for (AwardProjectDirector projectDirector : awardProjectDirectors) {
            String principalId;
            if (projectDirector == null || !StringUtils.isNotEmpty((String)projectDirector.getPrincipalId()) || principalIdHash.add(principalId = projectDirector.getPrincipalId())) continue;
            this.putFieldError("awardProjectDirectors", "error.cg.duplicate.awardProjectDirector", principalId);
            return false;
        }
        return success;
    }

    protected boolean checkForDuplicateAwardOrganization() {
        boolean success = true;
        List<AwardOrganization> awardOrganizations = this.newAwardCopy.getAwardOrganizations();
        HashSet<String> orgaizationHash = new HashSet<String>();
        for (AwardOrganization awardOrganization : awardOrganizations) {
            if (awardOrganization == null || !StringUtils.isNotEmpty((String)awardOrganization.getOrganizationCode())) continue;
            String organizationCode = awardOrganization.getOrganizationCode();
            String organizationChart = awardOrganization.getChartOfAccountsCode();
            if (orgaizationHash.add(organizationChart + organizationCode)) continue;
            this.putFieldError("awardOrganizations", "error.cg.duplicate.awardOrganization", organizationChart + "-" + organizationCode);
            return false;
        }
        return success;
    }

    protected boolean checkAwardFundManager(AwardFundManager awardFundManager) {
        boolean success = true;
        Person fundManager = awardFundManager.getFundManager();
        if (this.contractsGrantsBillingEnhancementActive && (StringUtils.isBlank((String)awardFundManager.getPrincipalId()) || ObjectUtils.isNull((Object)fundManager))) {
            String errorPath = "add.awardFundManagers.fundManager.principalName";
            String label = this.getDataDictionaryService().getAttributeLabel(AwardFundManager.class, "fundManager.principalName");
            String message = label + "(" + awardFundManager.getPrincipalId() + ")";
            this.putFieldError(errorPath, "error.existence", message);
            success &= false;
        }
        return success;
    }

    protected boolean checkInvoicingOption() {
        boolean success = true;
        List errorString = ((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).checkAwardContractControlAccounts((ContractsAndGrantsBillingAward)this.newAwardCopy);
        if (CollectionUtils.isNotEmpty((Collection)errorString) && errorString.size() > 1) {
            success = false;
            this.putFieldError("invoicingOptionCode", (String)errorString.get(0), (String)errorString.get(1));
        }
        return success;
    }

    protected boolean checkNumberOfAccountsForBillingFrequency() {
        String billingFrequencyCode;
        boolean success = true;
        int numberOfActiveAccounts = 0;
        AccountsReceivableBillingFrequency billingFrequency = this.newAwardCopy.getBillingFrequency();
        if (ObjectUtils.isNotNull((Object)billingFrequency) && ObjectUtils.isNotNull((Object)(billingFrequencyCode = billingFrequency.getFrequency())) && ("MILE".equalsIgnoreCase(billingFrequencyCode) || "PDBS".equalsIgnoreCase(billingFrequencyCode))) {
            List<AwardAccount> awardAccounts = this.newAwardCopy.getAwardAccounts();
            for (AwardAccount account : awardAccounts) {
                if (account.isActive()) {
                    ++numberOfActiveAccounts;
                }
                if (numberOfActiveAccounts <= 1) continue;
                this.putFieldError("awardAccounts", "error.cg.award.milestone.and.predetermined.billingFrequency.must.have.one.account");
                return false;
            }
        }
        return success;
    }

    protected boolean checkStopWorkReason() {
        boolean success = true;
        if (this.newAwardCopy.isStopWorkIndicator() && StringUtils.isBlank((String)this.newAwardCopy.getStopWorkReason())) {
            success = false;
            this.putFieldError("stopWorkReason", "error.stop.work.reason.required");
        }
        return success;
    }

    protected boolean checkBillingFrequency() {
        String oldBillingFrequencyCode;
        boolean success = true;
        String newBillingFrequencyCode = this.newAwardCopy.getBillingFrequencyCode();
        if (!StringUtils.equals((String)newBillingFrequencyCode, (String)(oldBillingFrequencyCode = this.oldAwardCopy.getBillingFrequencyCode()))) {
            if (StringUtils.equals((String)oldBillingFrequencyCode, (String)"MILE") && ((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).hasActiveMilestones(this.newAwardCopy.getProposalNumber())) {
                success = false;
                this.putFieldError("billingFrequencyCode", "error.cg.active.milestones.exist", this.newAwardCopy.getBillingFrequency().getFrequencyDescription());
            } else if (StringUtils.equals((String)oldBillingFrequencyCode, (String)"PDBS") && ((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).hasActiveBills(this.newAwardCopy.getProposalNumber())) {
                success = false;
                this.putFieldError("billingFrequencyCode", "error.cg.active.bills.exist", this.newAwardCopy.getBillingFrequency().getFrequencyDescription());
            }
        }
        return success;
    }
}

