/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.cg.businessobject.AwardSubcontractor;
import org.kuali.kfs.module.cg.document.validation.impl.AwardRule;
import org.kuali.kfs.module.cg.fixture.AwardFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.MaintenanceRuleTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class AwardRuleTest
extends MaintenanceRuleTestBase {
    private AwardRule rule;
    private Award award;
    private BusinessObjectService boService;
    private Long proposalNumber;

    public void setUp() throws Exception {
        super.setUp();
        this.proposalNumber = new Long(39603L);
        this.boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.award = new Award();
        this.rule = (AwardRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.award), AwardRule.class);
    }

    public void testCheckAccounts_False() {
        this.rule.newAwardCopy = this.award;
        AwardRuleTest.assertFalse((boolean)this.rule.checkAccounts());
    }

    public void testCheckAccounts_True() {
        this.rule.newAwardCopy = this.award = (Award)this.boService.findBySinglePrimaryKey(Award.class, (Object)this.proposalNumber);
        AwardRuleTest.assertTrue((boolean)this.rule.checkAccounts());
    }

    public void testCheckProposal_True() {
        this.rule.newAwardCopy = this.award = (Award)this.boService.findBySinglePrimaryKey(Award.class, (Object)this.proposalNumber);
        AwardRuleTest.assertTrue((boolean)this.rule.checkProposal());
    }

    public void testCheckFederalPassThrough_True() {
        this.rule.newAwardCopy = this.award = (Award)this.boService.findBySinglePrimaryKey(Award.class, (Object)this.proposalNumber);
        AwardRuleTest.assertTrue((boolean)this.rule.checkFederalPassThrough());
    }

    public void testAward() {
        this.award = (Award)this.boService.findBySinglePrimaryKey(Award.class, (Object)this.proposalNumber);
        AwardRuleTest.assertTrue((boolean)this.rule.checkAwardOrganization(this.award.getPrimaryAwardOrganization()));
        AwardRuleTest.assertTrue((boolean)this.rule.checkAwardSubcontractor((AwardSubcontractor)this.award.getAwardSubcontractors().get(0)));
        AwardRuleTest.assertTrue((boolean)this.rule.checkAwardAccount((AwardAccount)this.award.getAwardAccounts().get(0)));
        AwardRuleTest.assertTrue((boolean)this.rule.checkAwardProjectDirector((AwardProjectDirector)this.award.getAwardProjectDirectors().get(0)));
        AwardRuleTest.assertTrue((boolean)this.rule.checkAwardFundManager((AwardFundManager)this.award.getAwardFundManagers().get(0)));
    }

    public void testCheckSuspendedAwardInvoicing_True() {
        this.rule.newAwardCopy = this.award = AwardFixture.CG_AWARD_INV_ACCOUNT.createAward();
        AwardRuleTest.assertTrue((boolean)this.rule.checkExcludedFromInvoicing());
    }

    public void testCheckInvoicingOption_True() {
        this.rule.newAwardCopy = this.award = AwardFixture.CG_AWARD_INV_ACCOUNT.createAward();
        AwardRuleTest.assertTrue((boolean)this.rule.checkInvoicingOption());
    }
}

