/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.businessobject;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;

public class AwardTest {
    private Award cut;
    private AwardProjectDirector awardProjectDirector;
    private AwardProjectDirector awardProjectDirectorForList;
    private List<AwardProjectDirector> awardProjectDirectors;

    @Before
    public void setUp() {
        this.cut = new Award();
        this.awardProjectDirector = new AwardProjectDirector();
        this.awardProjectDirectors = new ArrayList<AwardProjectDirector>();
        this.awardProjectDirectorForList = new AwardProjectDirector();
        this.awardProjectDirectors.add(this.awardProjectDirectorForList);
    }

    @Test
    public void getAwardPrimaryProjectDirector_nullField_noProjectDirectorsInList() {
        Assert.assertNull((Object)this.cut.getAwardPrimaryProjectDirector());
    }

    @Test
    public void getAwardPrimaryProjectDirector_nullField_noPrimaryProjectDirectorInList() {
        this.cut.setAwardProjectDirectors(this.awardProjectDirectors);
        Assert.assertNull((Object)this.cut.getAwardPrimaryProjectDirector());
    }

    @Test
    public void getAwardPrimaryProjectDirector_nullField_hasPrimaryProjectDirectorInList() {
        this.awardProjectDirectorForList.setAwardPrimaryProjectDirectorIndicator(true);
        this.cut.setAwardProjectDirectors(this.awardProjectDirectors);
        Assert.assertEquals((Object)this.awardProjectDirectorForList, (Object)this.cut.getAwardPrimaryProjectDirector());
    }

    @Test
    public void getAwardPrimaryProjectDirector_setField_noProjectDirectorsInList() {
        this.cut.setAwardPrimaryProjectDirector(this.awardProjectDirector);
        Assert.assertEquals((Object)this.awardProjectDirector, (Object)this.cut.getAwardPrimaryProjectDirector());
    }

    @Test
    public void getAwardPrimaryProjectDirector_setField_noPrimaryProjectDirectorInList() {
        this.cut.setAwardPrimaryProjectDirector(this.awardProjectDirector);
        this.cut.setAwardProjectDirectors(this.awardProjectDirectors);
        Assert.assertEquals((Object)this.awardProjectDirector, (Object)this.cut.getAwardPrimaryProjectDirector());
    }

    @Test
    public void getAwardPrimaryProjectDirector_setField_hasPrimaryProjectDirectorInList() {
        this.cut.setAwardPrimaryProjectDirector(this.awardProjectDirector);
        this.awardProjectDirectorForList.setAwardPrimaryProjectDirectorIndicator(true);
        this.cut.setAwardProjectDirectors(this.awardProjectDirectors);
        Assert.assertEquals((Object)this.awardProjectDirectorForList, (Object)this.cut.getAwardPrimaryProjectDirector());
    }
}

