/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.sql.Date;
import java.util.Collection;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.AgencyAddress;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.cg.document.validation.impl.CGMaintenanceDocumentRuleBase;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.MaintenanceRuleTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.springframework.util.AutoPopulatingList;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CGMaintenanceDocumentRuleBaseTest
extends MaintenanceRuleTestBase {
    private CGMaintenanceDocumentRuleBase rule;
    private String agencyNumber;
    private Agency agency;
    private Award award;

    public void setUp() {
        this.rule = new CGMaintenanceDocumentRuleBase();
        this.agencyNumber = "55076";
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.award = (Award)boService.findBySinglePrimaryKey(Award.class, (Object)"39603");
        this.agency = (Agency)boService.findBySinglePrimaryKey(Agency.class, (Object)this.agencyNumber);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    public void testCheckEndAfterBegin() {
        Date begin = new Date(11111L);
        Date end = new Date(11115L);
        CGMaintenanceDocumentRuleBaseTest.assertFalse((boolean)this.rule.checkEndAfterBegin(begin, begin, ""));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkEndAfterBegin(begin, end, ""));
    }

    public void testAll() {
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkPrimary((Collection)this.agency.getAgencyAddresses(), AgencyAddress.class, "agencyAddresses", Agency.class));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkProjectDirectorsExist(this.award.getAwardProjectDirectors(), AwardProjectDirector.class, "awardProjectDirectors"));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkFundManagersExist(this.award.getAwardFundManagers(), "awardFundManagers"));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkProjectDirectorsExist(this.award.getAwardAccounts(), AwardAccount.class, "awardAccounts"));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkProjectDirectorsStatuses(this.award.getAwardProjectDirectors(), AwardProjectDirector.class, "awardProjectDirectors"));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkFederalPassThrough(this.award.getFederalPassThroughIndicator(), this.award.getAgency(), this.award.getFederalPassThroughAgencyNumber(), Award.class, "federalPassThroughIndicator"));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkAgencyNotEqualToFederalPassThroughAgency(this.award.getAgency(), this.award.getFederalPassThroughAgency(), "agencyNumber", "federalPassThroughAgencyNumber"));
    }

    public void testCheckAgencyNotEqualToFederalPassThroughAgency_Equal_INVALID() {
        Agency agency = new Agency();
        agency.setAgencyNumber(this.agencyNumber);
        Agency federalPassThroughAgency = new Agency();
        federalPassThroughAgency.setAgencyNumber(this.agencyNumber);
        CGMaintenanceDocumentRuleBaseTest.assertFalse((boolean)this.rule.checkAgencyNotEqualToFederalPassThroughAgency(agency, federalPassThroughAgency, "agencyNumber", "federalPassThroughAgencyNumber"));
        CGMaintenanceDocumentRuleBaseTest.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.agencyNumber")).get(0);
        CGMaintenanceDocumentRuleBaseTest.assertEquals((String)"error.cg.agencyEqualsFederalPassThroughAgency", (String)errorMessage.getErrorKey());
        CGMaintenanceDocumentRuleBaseTest.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
        errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.federalPassThroughAgencyNumber")).get(0);
        CGMaintenanceDocumentRuleBaseTest.assertEquals((String)"error.cg.federalPassThroughAgencyEqualsAgency", (String)errorMessage.getErrorKey());
        CGMaintenanceDocumentRuleBaseTest.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    public void testCheckAgencyNotEqualToFederalPassThroughAgency_NotEqual_VALID() {
        Agency agency = new Agency();
        agency.setAgencyNumber(this.agencyNumber);
        Agency federalPassThroughAgency = new Agency();
        federalPassThroughAgency.setAgencyNumber("1");
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkAgencyNotEqualToFederalPassThroughAgency(agency, federalPassThroughAgency, "agencyNumber", "federalPassThroughAgencyNumber"));
        CGMaintenanceDocumentRuleBaseTest.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }
}

