/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.kim.impl.identity.PersonImpl;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.document.validation.impl.AwardRule;
import org.kuali.kfs.module.cg.fixture.AwardFixture;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SpringContext.class})
public class AwardRule2Test {
    private final AccountsReceivableModuleBillingService accountsReceivableModuleBillingSvcMock = (AccountsReceivableModuleBillingService)Mockito.mock(AccountsReceivableModuleBillingService.class);
    private Award award;
    private AwardRule cutSpy;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cutSpy = (AwardRule)Mockito.spy((Object)new AwardRule());
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        PowerMockito.when((Object)((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class))).thenReturn((Object)this.accountsReceivableModuleBillingSvcMock);
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)true);
        this.award = AwardFixture.CG_AWARD_INV_ACCOUNT.createAward();
        GlobalVariables.getMessageMap().getErrorMessages().clear();
    }

    @After
    public void tearDown() {
        this.cutSpy.setDictionaryValidationService(null);
    }

    @Test
    public void checkAwardFundManager() {
        this.award.setAwardFundManagers(AwardRule2Test.setupAwardFundManagers());
        Assert.assertTrue((boolean)this.cutSpy.checkAwardFundManager((AwardFundManager)this.award.getAwardFundManagers().get(0)));
    }

    private static List<AwardFundManager> setupAwardFundManagers() {
        ArrayList<AwardFundManager> awardFundManagers = new ArrayList<AwardFundManager>();
        AwardFundManager awardFundManager = (AwardFundManager)Mockito.spy(AwardFundManager.class);
        awardFundManager.setPrincipalId("5334003983");
        awardFundManager.setPrimaryFundManagerIndicator(true);
        PersonImpl fundManagerMock = (PersonImpl)Mockito.mock(PersonImpl.class);
        awardFundManager.setFundManager(fundManagerMock);
        awardFundManagers.add(awardFundManager);
        ((AwardFundManager)Mockito.doReturn((Object)fundManagerMock).when((Object)awardFundManager)).getFundManager();
        return awardFundManagers;
    }
}

