/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.service.ContractsAndGrantsLookupService;
import org.kuali.rice.krad.bo.BusinessObject;

public class AwardLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    protected AccountsReceivableModuleBillingService accountsReceivableModuleBillingService;
    protected ContractsAndGrantsLookupService contractsAndGrantsLookupService;

    public List<Column> getColumns() {
        List columns = super.getColumns();
        if (!this.getAccountsReceivableModuleBillingService().isContractsGrantsBillingEnhancementActive()) {
            columns.removeIf(column -> this.getFieldsToIgnore().contains(column.getPropertyName()));
        }
        return columns;
    }

    protected void setRows() {
        List fields;
        List lookupFieldNames = null;
        if (this.getBusinessObjectMetaDataService().isLookupable(this.getBusinessObjectClass())) {
            lookupFieldNames = this.getBusinessObjectMetaDataService().getLookupableFieldNames(this.getBusinessObjectClass());
        }
        if (lookupFieldNames == null) {
            throw new RuntimeException("Lookup not defined for business object " + this.getBusinessObjectClass());
        }
        ArrayList<String> lookupFieldAttributeList = new ArrayList<String>();
        for (String lookupFieldName : lookupFieldNames) {
            if (this.getFieldsToIgnore().contains(lookupFieldName)) continue;
            lookupFieldAttributeList.add(lookupFieldName);
        }
        try {
            fields = FieldUtils.createAndPopulateFieldsForLookup(lookupFieldAttributeList, (List)this.getReadOnlyFieldsList(), (Class)this.getBusinessObjectClass());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to create instance of business object class" + e.getMessage());
        }
        int numCols = this.getBusinessObjectDictionaryService().getLookupNumberOfColumns(this.getBusinessObjectClass());
        this.rows = FieldUtils.wrapFields((List)fields, (int)numCols);
    }

    protected List<String> getFieldsToIgnore() {
        ArrayList<String> fieldsToIgnore = new ArrayList<String>();
        if (!this.getAccountsReceivableModuleBillingService().isContractsGrantsBillingEnhancementActive()) {
            fieldsToIgnore.add("lookupFundMgrPerson.principalName");
            fieldsToIgnore.add("awardPrimaryFundManager.fundManager.name");
            fieldsToIgnore.add("lastBilledDate");
            fieldsToIgnore.add("billingFrequencyCode");
            fieldsToIgnore.add("excludedFromInvoicing");
            fieldsToIgnore.add("additionalFormsDescription");
            fieldsToIgnore.add("additionalFormsRequiredIndicator");
            fieldsToIgnore.add("minInvoiceAmount");
            fieldsToIgnore.add("fundingExpirationDate");
        }
        return fieldsToIgnore;
    }

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        if (this.contractsAndGrantsLookupService.setupSearchFields(fieldValues, "lookupPerson.principalName", "awardProjectDirectors.principalId") && this.contractsAndGrantsLookupService.setupSearchFields(fieldValues, "lookupFundMgrPerson.principalName", "awardFundManagers.principalId")) {
            return super.getSearchResultsHelper(fieldValues, unbounded);
        }
        return Collections.EMPTY_LIST;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> anchorHtmlDataList = new ArrayList<HtmlData>();
        anchorHtmlDataList.add((HtmlData)this.getUrlData(businessObject, "edit", pkNames));
        if (this.allowsMaintenanceNewOrCopyAction()) {
            anchorHtmlDataList.add((HtmlData)this.getUrlData(businessObject, "copy", pkNames));
        }
        if (this.getAccountsReceivableModuleBillingService().isContractsGrantsBillingEnhancementActive()) {
            HtmlData.AnchorHtmlData invoiceUrl = this.getInvoicesLookupUrl(businessObject);
            anchorHtmlDataList.add((HtmlData)invoiceUrl);
        }
        return anchorHtmlDataList;
    }

    protected HtmlData.AnchorHtmlData getInvoicesLookupUrl(BusinessObject bo) {
        Award award = (Award)bo;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("documentTypeName", this.getAccountsReceivableModuleBillingService().getContractsGrantsInvoiceDocumentType());
        params.put("documentAttribute.proposalNumber", award.getProposalNumber());
        String url = UrlFactory.parameterizeUrl((String)this.configurationService.getPropertyValueAsString("workflow.documentsearch.base.url"), params);
        HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(url, "search", "View Invoices");
        anchorHtmlData.setTarget("_blank");
        return anchorHtmlData;
    }

    public AccountsReceivableModuleBillingService getAccountsReceivableModuleBillingService() {
        return this.accountsReceivableModuleBillingService;
    }

    public void setAccountsReceivableModuleBillingService(AccountsReceivableModuleBillingService accountsReceivableModuleBillingService) {
        this.accountsReceivableModuleBillingService = accountsReceivableModuleBillingService;
    }

    public ContractsAndGrantsLookupService getContractsAndGrantsLookupService() {
        return this.contractsAndGrantsLookupService;
    }

    public void setContractsAndGrantsLookupService(ContractsAndGrantsLookupService contractsAndGrantsLookupService) {
        this.contractsAndGrantsLookupService = contractsAndGrantsLookupService;
    }
}

