/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.businessobject.CGProjectDirector;
import org.kuali.kfs.module.cg.businessobject.Primaryable;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;

public class CGMaintenanceDocumentRuleBase
extends MaintenanceDocumentRuleBase {
    protected static final String PROJECT_DIRECTOR_DECEASED = "D";
    protected static final String[] PROJECT_DIRECTOR_INVALID_STATUSES = new String[]{"D"};
    protected static final String AGENCY_TYPE_CODE_FEDERAL = "F";

    protected boolean checkEndAfterBegin(Date begin, Date end, String propertyName) {
        boolean success = true;
        if (ObjectUtils.isNotNull((Object)begin) && ObjectUtils.isNotNull((Object)end) && !end.after(begin)) {
            this.putFieldError(propertyName, "error.cg.endingDateNotAfterBegin");
            success = false;
        }
        return success;
    }

    protected <E extends Primaryable> boolean checkPrimary(Collection<E> primaryables, Class<E> elementClass, String collectionName, Class<? extends BusinessObject> boClass) {
        boolean success = true;
        int count = 0;
        for (Primaryable p : primaryables) {
            if (!p.isPrimary()) continue;
            ++count;
        }
        if (count != 1) {
            success = false;
            String elementLabel = this.getDataDictionaryService().getCollectionElementLabel(boClass.getName(), collectionName, elementClass);
            if (count == 0) {
                this.putFieldError(collectionName, "error.cg.noPrimary", elementLabel);
            } else {
                this.putFieldError(collectionName, "error.cg.multiplePrimary", elementLabel);
            }
        }
        return success;
    }

    protected <T extends CGProjectDirector> boolean checkProjectDirectorsExist(List<T> projectDirectors, Class<T> elementClass, String collectionName) {
        boolean success = true;
        String personUserPropertyName = "projectDirector.principalName";
        String label = this.getDataDictionaryService().getAttributeLabel(elementClass, "projectDirector.principalName");
        int i = 0;
        for (CGProjectDirector pd : projectDirectors) {
            String propertyName = collectionName + "[" + i++ + "].projectDirector.principalName";
            String id = pd.getPrincipalId();
            if (!StringUtils.isBlank((CharSequence)id) && this.getIdentityService().getEntityByPrincipalId(id) != null) continue;
            this.putFieldError(propertyName, "error.existence", label);
            success = false;
        }
        return success;
    }

    protected boolean checkFundManagersExist(List<AwardFundManager> fundManagers, String collectionName) {
        boolean success = true;
        String personUserPropertyName = "fundManager.principalName";
        String label = this.getDataDictionaryService().getAttributeLabel(AwardFundManager.class, "fundManager.principalName");
        int i = 0;
        for (AwardFundManager fm : fundManagers) {
            String propertyName = collectionName + "[" + i++ + "].fundManager.principalName";
            String id = fm.getPrincipalId();
            if (!StringUtils.isBlank((CharSequence)id) && this.getIdentityService().getEntityByPrincipalId(id) != null) continue;
            this.putFieldError(propertyName, "error.existence", label);
            success = false;
        }
        return success;
    }

    protected <T extends CGProjectDirector> boolean checkProjectDirectorsAreDirectors(List<T> projectDirectors, Class<T> elementClass, String collectionName) {
        boolean success = true;
        String personUserPropertyName = "projectDirector.principalName";
        RoleService roleService = this.getRoleService();
        ArrayList<String> roleId = new ArrayList<String>();
        roleId.add(roleService.getRoleIdByNamespaceCodeAndName("KFS-SYS", "Contracts & Grants Project Director"));
        int i = 0;
        for (CGProjectDirector pd : projectDirectors) {
            String propertyName = collectionName + "[" + i++ + "].projectDirector.principalName";
            String id = pd.getProjectDirector().getPrincipalId();
            if (roleService.principalHasRole(id, roleId, null)) continue;
            this.putFieldError(propertyName, "error.cg.notAProjectDirector", id);
            success = false;
        }
        return success;
    }

    protected <T extends CGProjectDirector> boolean checkProjectDirectorsStatuses(List<T> projectDirectors, Class<T> elementClass, String propertyName) {
        boolean success = true;
        for (CGProjectDirector pd : projectDirectors) {
            CodedAttribute empStatus;
            String pdEmplStatusCode = pd.getProjectDirector().getEmployeeStatusCode();
            if (!StringUtils.isBlank((CharSequence)pdEmplStatusCode) && !Arrays.asList(PROJECT_DIRECTOR_INVALID_STATUSES).contains(pdEmplStatusCode)) continue;
            Object pdEmplStatusName = "INVALID STATUS CODE " + pdEmplStatusCode;
            if (StringUtils.isNotBlank((CharSequence)pdEmplStatusCode) && (empStatus = this.getIdentityService().getEmploymentStatus(pdEmplStatusCode)) != null) {
                pdEmplStatusName = empStatus.getName();
            }
            String[] errors = new String[]{pd.getProjectDirector().getName(), pdEmplStatusCode + " - " + (String)pdEmplStatusName};
            this.putFieldError(propertyName, "error.cg.invalidProjectDirectorStatus", errors);
            success = false;
        }
        return success;
    }

    protected boolean checkAgencyNotEqualToFederalPassThroughAgency(Agency agency, Agency federalPassThroughAgency, String agencyPropertyName, String fedPassThroughAgencyPropertyName) {
        boolean success = true;
        if (ObjectUtils.isNotNull((Object)((Object)agency)) && ObjectUtils.isNotNull((Object)((Object)federalPassThroughAgency)) && ObjectUtils.isNotNull((Object)agency.getAgencyNumber()) && ObjectUtils.isNotNull((Object)federalPassThroughAgency.getAgencyNumber()) && agency.equals((Object)federalPassThroughAgency)) {
            this.putFieldError(agencyPropertyName, "error.cg.agencyEqualsFederalPassThroughAgency");
            this.putFieldError(fedPassThroughAgencyPropertyName, "error.cg.federalPassThroughAgencyEqualsAgency");
            success = false;
        }
        return success;
    }

    protected boolean checkFederalPassThrough(boolean federalPassThroughIndicator, Agency primaryAgency, String federalPassThroughAgencyNumber, Class propertyClass, String federalPassThroughIndicatorFieldName) {
        boolean success = true;
        boolean primaryAgencyIsFederal = false;
        if (ObjectUtils.isNotNull((Object)((Object)primaryAgency))) {
            primaryAgencyIsFederal = AGENCY_TYPE_CODE_FEDERAL.equalsIgnoreCase(primaryAgency.getAgencyTypeCode());
        }
        if (primaryAgencyIsFederal) {
            if (federalPassThroughIndicator) {
                this.putFieldError(federalPassThroughIndicatorFieldName, "error.cg.primaryAgencyIsFederalAndFPTIndicatorIsChecked", new String[]{primaryAgency.getAgencyNumber(), AGENCY_TYPE_CODE_FEDERAL});
                success = false;
            }
            if (!StringUtils.isBlank((CharSequence)federalPassThroughAgencyNumber)) {
                this.putFieldError("federalPassThroughAgencyNumber", "error.cg.primaryAgencyIsFederalAndFPTAgencyNumberIsNotBlank", new String[]{primaryAgency.getAgencyNumber(), AGENCY_TYPE_CODE_FEDERAL});
                success = false;
            }
        } else if (federalPassThroughIndicator && StringUtils.isBlank((CharSequence)federalPassThroughAgencyNumber)) {
            this.putFieldError("federalPassThroughAgencyNumber", "error.cg.federalPassThroughAgencyIndicatorIsChecked");
            success = false;
        } else if (!federalPassThroughIndicator && !StringUtils.isBlank((CharSequence)federalPassThroughAgencyNumber)) {
            this.putFieldError("federalPassThroughAgencyNumber", "error.cg.federalPassThroughAgencyNumberIsNotBlank");
            success = false;
        }
        return success;
    }

    protected boolean isContractsGrantsBillingEnhancementActive() {
        return ((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).isContractsGrantsBillingEnhancementActive();
    }

    IdentityService getIdentityService() {
        return KimApiServiceLocator.getIdentityService();
    }
}

