/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.ar.AccountsReceivableBillingFrequency;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.ar.businessobject.BillingFrequency;
import org.kuali.kfs.integration.cg.CGIntegrationConstants;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kim.impl.identity.PersonImpl;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.businessobject.AwardOrganization;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.cg.businessobject.AwardSubcontractor;
import org.kuali.kfs.module.cg.businessobject.SubContractor;
import org.kuali.kfs.module.cg.document.validation.impl.AwardRule;
import org.kuali.kfs.module.cg.fixture.AwardFixture;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.util.AutoPopulatingList;

@Execution(value=ExecutionMode.SAME_THREAD)
class AwardRuleTest {
    private static final String AWARD_ACCOUNTS_LABEL = "Award Accounts";
    private static final String BILLING_FREQUENCY_LABEL = "Billing Frequency";
    private static final String INVOICING_OPTION_LABEL = "Invoicing Option";
    @Mock
    private AccountsReceivableModuleBillingService accountsReceivableModuleBillingSvcMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private DictionaryValidationService dictionaryValidationSvcMock;
    private Award award;
    private AwardRule cutSpy;

    AwardRuleTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.cutSpy = (AwardRule)Mockito.spy((Object)new AwardRule());
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)true);
        ((AwardRule)Mockito.doReturn((Object)this.accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        Mockito.when((Object)this.dataDictionarySvcMock.getCollectionElementLabel(Award.class.getName(), "awardAccounts", AwardAccount.class)).thenReturn((Object)AWARD_ACCOUNTS_LABEL);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(Award.class, "billingFrequencyCode")).thenReturn((Object)BILLING_FREQUENCY_LABEL);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(Award.class, "invoicingOptionCode")).thenReturn((Object)INVOICING_OPTION_LABEL);
        this.cutSpy.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        ((AwardRule)Mockito.doReturn((Object)this.dataDictionarySvcMock).when((Object)this.cutSpy)).getDataDictionaryService();
        this.award = AwardFixture.CG_AWARD_INV_ACCOUNT.createAward();
        GlobalVariables.getMessageMap().getErrorMessages().clear();
    }

    @AfterEach
    void tearDown() {
        this.cutSpy.setDictionaryValidationService(null);
    }

    @Test
    void checkAccounts_NoAwardAccounts() {
        this.cutSpy.newAwardCopy = new Award();
        Assertions.assertFalse((boolean)this.cutSpy.checkAccounts());
    }

    @Test
    void checkAccounts_HasAwardAccounts() {
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        AwardAccount awardAccount = new AwardAccount();
        awardAccounts.add(awardAccount);
        this.award.setAwardAccounts(awardAccounts);
        this.cutSpy.newAwardCopy = this.award;
        Assertions.assertTrue((boolean)this.cutSpy.checkAccounts());
    }

    @Test
    void checkProposal_ProposalHasBeenAwarded() {
        ((AwardRule)Mockito.doReturn((Object)Boolean.TRUE).when((Object)this.cutSpy)).isProposalAwarded(this.award);
        this.cutSpy.newAwardCopy = this.award;
        Assertions.assertFalse((boolean)this.cutSpy.checkProposal());
    }

    @Test
    void checkProposal_ProposalHasNotBeenAwarded() {
        ((AwardRule)Mockito.doReturn((Object)Boolean.FALSE).when((Object)this.cutSpy)).isProposalAwarded(this.award);
        this.cutSpy.newAwardCopy = this.award;
        Assertions.assertTrue((boolean)this.cutSpy.checkProposal());
    }

    @Test
    void checkFederalPassThrough_NotFederalPassThrough() {
        this.cutSpy.newAwardCopy = this.award;
        Assertions.assertTrue((boolean)this.cutSpy.checkFederalPassThrough());
    }

    @Test
    void checkFederalPassThrough_FederalPassThroughIndicatorIsYes_NoAgencyNumber() {
        this.award.setFederalPassThroughIndicator(true);
        this.cutSpy.newAwardCopy = this.award;
        Assertions.assertFalse((boolean)this.cutSpy.checkFederalPassThrough());
    }

    @Test
    void checkFederalPassThrough_FederalPassThrough_AgencyNumberPopulated() {
        this.award.setFederalPassThroughIndicator(true);
        this.award.setFederalPassThroughAgencyNumber("12345");
        this.cutSpy.newAwardCopy = this.award;
        Assertions.assertTrue((boolean)this.cutSpy.checkFederalPassThrough());
    }

    @Test
    void checkAwardOrganization() {
        AwardOrganization awardOrganization = (AwardOrganization)Mockito.spy(AwardOrganization.class);
        awardOrganization.setOrganizationCode("PSY");
        awardOrganization.setChartOfAccountsCode("BL");
        awardOrganization.setOrganization(new Organization());
        this.award.setPrimaryAwardOrganization(awardOrganization);
        ((AwardOrganization)Mockito.doNothing().when((Object)awardOrganization)).refreshReferenceObject("organization");
        Assertions.assertTrue((boolean)this.cutSpy.checkAwardOrganization(this.award.getPrimaryAwardOrganization()));
    }

    @Test
    void checkAwardSubcontractor() {
        ArrayList<AwardSubcontractor> awardSubcontractors = new ArrayList<AwardSubcontractor>();
        AwardSubcontractor awardSubcontractor = (AwardSubcontractor)Mockito.spy(AwardSubcontractor.class);
        awardSubcontractor.setSubcontractorNumber("12345");
        awardSubcontractor.setSubcontractor(new SubContractor());
        awardSubcontractors.add(awardSubcontractor);
        this.award.setAwardSubcontractors(awardSubcontractors);
        ((AwardSubcontractor)Mockito.doNothing().when((Object)awardSubcontractor)).refreshReferenceObject("subcontractor");
        Assertions.assertTrue((boolean)this.cutSpy.checkAwardSubcontractor((AwardSubcontractor)this.award.getAwardSubcontractors().get(0)));
    }

    @Test
    void checkAwardAccount() {
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        AwardAccount awardAccount = (AwardAccount)Mockito.spy(AwardAccount.class);
        awardAccount.setChartOfAccountsCode("BL");
        awardAccount.setAccountNumber("0211821");
        awardAccount.setPrincipalId("5334003983");
        Account account = new Account();
        account.setChartOfAccountsCode("BL");
        account.setAccountNumber("0211821");
        awardAccount.setAccount(account);
        PersonImpl projectDirectorMock = (PersonImpl)Mockito.mock(PersonImpl.class);
        awardAccount.setProjectDirector(projectDirectorMock);
        awardAccounts.add(awardAccount);
        this.award.setAwardAccounts(awardAccounts);
        ((AwardAccount)Mockito.doNothing().when((Object)awardAccount)).refreshReferenceObject("account");
        ((AwardAccount)Mockito.doReturn((Object)projectDirectorMock).when((Object)awardAccount)).getProjectDirector();
        Assertions.assertTrue((boolean)this.cutSpy.checkAwardAccount((AwardAccount)this.award.getAwardAccounts().get(0)));
    }

    @Test
    void checkAwardProjectDirector() {
        ArrayList<AwardProjectDirector> awardProjectDirectors = new ArrayList<AwardProjectDirector>();
        AwardProjectDirector awardProjectDirector = (AwardProjectDirector)Mockito.spy(AwardProjectDirector.class);
        awardProjectDirector.setPrincipalId("5334003983");
        PersonImpl projectDirectorMock = (PersonImpl)Mockito.mock(PersonImpl.class);
        awardProjectDirector.setProjectDirector(projectDirectorMock);
        awardProjectDirectors.add(awardProjectDirector);
        this.award.setAwardProjectDirectors(awardProjectDirectors);
        ((AwardProjectDirector)Mockito.doReturn((Object)projectDirectorMock).when((Object)awardProjectDirector)).getProjectDirector();
        Assertions.assertTrue((boolean)this.cutSpy.checkAwardProjectDirector((AwardProjectDirector)this.award.getAwardProjectDirectors().get(0)));
    }

    @Test
    void checkExcludedFromInvoicing() {
        this.cutSpy.newAwardCopy = this.award;
        Assertions.assertTrue((boolean)this.cutSpy.checkExcludedFromInvoicing());
    }

    @Test
    void checkInvoicingOption() {
        this.cutSpy.newAwardCopy = this.award;
        Assertions.assertTrue((boolean)this.cutSpy.checkInvoicingOption());
    }

    @Test
    void checkInvoicingOption_ContractControlAccountNotSetup() {
        this.cutSpy.newAwardCopy = this.award;
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.checkAwardContractControlAccounts((ContractsAndGrantsBillingAward)this.award)).thenReturn(Arrays.asList("errorKey", this.award.getInvoicingOptionDescription()));
        Assertions.assertFalse((boolean)this.cutSpy.checkInvoicingOption());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode")).get(0);
        Assertions.assertEquals((Object)"errorKey", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)this.award.getInvoicingOptionDescription(), (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void checkInvoicingOption_InvalidInvoicingOption_MonthlyBillingFrequency_ScheduleInvoicingOption() {
        this.cutSpy.newAwardCopy = this.award;
        BillingFrequency billingFrequency = new BillingFrequency();
        billingFrequency.setFrequency(this.award.getBillingFrequencyCode());
        billingFrequency.setFrequencyDescription("Monthly");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.SCHEDULE.getCode());
        Assertions.assertFalse((boolean)this.cutSpy.checkInvoicingOption());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode")).get(0);
        Assertions.assertEquals((Object)"error.cg.invalid.invoicing.option", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)2, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)CGIntegrationConstants.AwardInvoicingOption.Types.SCHEDULE.getName(), (Object)errorMessage.getMessageParameters()[0]);
        Assertions.assertEquals((Object)"Monthly", (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    void checkInvoicingOption_MilestoneBillingFrequency_AccountInvoicingOption() {
        this.award.setBillingFrequencyCode("MILE");
        this.cutSpy.newAwardCopy = this.award;
        BillingFrequency billingFrequency = new BillingFrequency();
        billingFrequency.setFrequency(this.award.getBillingFrequencyCode());
        billingFrequency.setFrequencyDescription("Milestone");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.ACCOUNT.getCode());
        Assertions.assertFalse((boolean)this.cutSpy.checkInvoicingOption());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode")).get(0);
        Assertions.assertEquals((Object)"error.cg.invalid.invoicing.option", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)2, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)CGIntegrationConstants.AwardInvoicingOption.Types.ACCOUNT.getName(), (Object)errorMessage.getMessageParameters()[0]);
        Assertions.assertEquals((Object)"Milestone", (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    void checkInvoicingOption_MilestoneBillingFrequency_AwardInvoicingOption() {
        this.award.setBillingFrequencyCode("MILE");
        this.cutSpy.newAwardCopy = this.award;
        BillingFrequency billingFrequency = new BillingFrequency();
        billingFrequency.setFrequency(this.award.getBillingFrequencyCode());
        billingFrequency.setFrequencyDescription("Milestone");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.AWARD.getCode());
        Assertions.assertFalse((boolean)this.cutSpy.checkInvoicingOption());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode")).get(0);
        Assertions.assertEquals((Object)"error.cg.invalid.invoicing.option", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)2, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)CGIntegrationConstants.AwardInvoicingOption.Types.AWARD.getName(), (Object)errorMessage.getMessageParameters()[0]);
        Assertions.assertEquals((Object)"Milestone", (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    void checkInvoicingOption_PredeterminedBillingFrequency_ContractControlAccountInvoicingOption() {
        this.award.setBillingFrequencyCode("PDBS");
        this.cutSpy.newAwardCopy = this.award;
        BillingFrequency billingFrequency = new BillingFrequency();
        billingFrequency.setFrequency(this.award.getBillingFrequencyCode());
        billingFrequency.setFrequencyDescription("Predetermined Billing");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.CONTRACT_CONTROL.getCode());
        Assertions.assertFalse((boolean)this.cutSpy.checkInvoicingOption());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode")).get(0);
        Assertions.assertEquals((Object)"error.cg.invalid.invoicing.option", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)2, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)CGIntegrationConstants.AwardInvoicingOption.Types.CONTRACT_CONTROL.getName(), (Object)errorMessage.getMessageParameters()[0]);
        Assertions.assertEquals((Object)"Predetermined Billing", (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    void checkConditionallyRequiredFields_BillingFrequencyEnteredInvoicingOptionMissing() {
        this.cutSpy.newAwardCopy = this.award;
        this.award.setBillingFrequencyCode("MNTH");
        this.award.setInvoicingOptionCode(null);
        Assertions.assertFalse((boolean)this.cutSpy.checkConditionallyRequiredFields());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.cg.billing.frequency.and.invoicing.option.required", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)2, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)INVOICING_OPTION_LABEL, (Object)errorMessage.getMessageParameters()[0]);
        Assertions.assertEquals((Object)BILLING_FREQUENCY_LABEL, (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    void checkConditionallyRequiredFields_InvoicingOptionEnteredBillingFrequencyMissing() {
        this.cutSpy.newAwardCopy = this.award;
        this.award.setBillingFrequencyCode(null);
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.ACCOUNT.getCode());
        Assertions.assertFalse((boolean)this.cutSpy.checkConditionallyRequiredFields());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.billingFrequencyCode");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.cg.billing.frequency.and.invoicing.option.required", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)2, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)BILLING_FREQUENCY_LABEL, (Object)errorMessage.getMessageParameters()[0]);
        Assertions.assertEquals((Object)INVOICING_OPTION_LABEL, (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    void checkBillingFrequency_noChange() {
        this.cutSpy.oldAwardCopy = this.award;
        this.cutSpy.newAwardCopy = (Award)ObjectUtils.deepCopy((Serializable)this.award);
        Assertions.assertTrue((boolean)this.cutSpy.checkBillingFrequency());
    }

    @Test
    void checkBillingFrequency_frequencyChangeToMilestone_noActiveMilestones() {
        this.cutSpy.oldAwardCopy = this.award;
        Award awardCopy = (Award)ObjectUtils.deepCopy((Serializable)this.award);
        this.award.setBillingFrequencyCode("MILE");
        this.cutSpy.newAwardCopy = awardCopy;
        Assertions.assertTrue((boolean)this.cutSpy.checkBillingFrequency());
    }

    @Test
    void checkBillingFrequency_frequencyChangeToPredeterminedBilling_noActiveBills() {
        this.cutSpy.oldAwardCopy = this.award = AwardFixture.CG_AWARD_INV_ACCOUNT.createAward();
        Award awardCopy = (Award)ObjectUtils.deepCopy((Serializable)this.award);
        this.award.setBillingFrequencyCode("PDBS");
        this.cutSpy.newAwardCopy = awardCopy;
        Assertions.assertTrue((boolean)this.cutSpy.checkBillingFrequency());
    }

    @Test
    void checkBillingFrequency_frequencyChangeToMilestone_activeUnbilledMilestones() {
        Award awardCopy = this.setupAwardCopy();
        this.cutSpy.oldAwardCopy = this.award;
        this.cutSpy.newAwardCopy = awardCopy;
        this.award.setBillingFrequencyCode("MILE");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.hasActiveUnbilledMilestones(awardCopy.getProposalNumber(), "BL", "0211821")).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cutSpy.checkBillingFrequency());
    }

    @Test
    void checkBillingFrequency_frequencyChangeToMilestone_activeUnbilledBills() {
        Award awardCopy = this.setupAwardCopy();
        this.cutSpy.oldAwardCopy = this.award;
        this.cutSpy.newAwardCopy = awardCopy;
        this.award.setBillingFrequencyCode("PDBS");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.hasActiveUnbilledBills(awardCopy.getProposalNumber(), "BL", "0211821")).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cutSpy.checkBillingFrequency());
    }

    @Test
    void checkCustomerAddress_noAgency_valid() {
        this.cutSpy.newAwardCopy = this.award;
        Assertions.assertTrue((boolean)this.cutSpy.checkCustomerAddress());
    }

    @Test
    void checkCustomerAddress_customerMatchesAgency_valid() {
        this.cutSpy.newAwardCopy = this.award;
        Agency agency = new Agency();
        agency.setCustomerNumber("10010");
        this.award.setAgency(agency);
        this.award.setCustomerNumber("10010");
        Assertions.assertTrue((boolean)this.cutSpy.checkCustomerAddress());
    }

    @Test
    void checkCustomerAddress_customerDoesNotMatchAgency_invalid() {
        this.cutSpy.newAwardCopy = this.award;
        Agency agency = new Agency();
        agency.setCustomerNumber("10010");
        this.award.setAgency(agency);
        this.award.setCustomerNumber("XXXXX");
        Assertions.assertFalse((boolean)this.cutSpy.checkCustomerAddress());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.customerAddressIdentifier");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.cg.billing.customer.address.must.match.agency.customer", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void performContractsGrantsBillingChecks_Milestone_hasMultipleAccounts() {
        this.award.setBillingFrequencyCode("MILE");
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.SCHEDULE.getCode());
        this.award.setAwardFundManagers(AwardRuleTest.setupAwardFundManagers());
        BillingFrequency billingFrequency = (BillingFrequency)Mockito.mock(BillingFrequency.class);
        Mockito.when((Object)billingFrequency.getFrequency()).thenReturn((Object)"MILE");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setAwardAccounts(AwardRuleTest.setupAwardAccounts());
        this.cutSpy.oldAwardCopy = this.award;
        this.cutSpy.newAwardCopy = this.award;
        Assertions.assertTrue((boolean)this.cutSpy.performContractsGrantsBillingChecks());
    }

    @Test
    void performContractsGrantsBillingChecks_PredeterminedBilling_hasMultipleAccounts() {
        this.award.setBillingFrequencyCode("PDBS");
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.SCHEDULE.getCode());
        this.award.setAwardFundManagers(AwardRuleTest.setupAwardFundManagers());
        BillingFrequency billingFrequency = (BillingFrequency)Mockito.mock(BillingFrequency.class);
        Mockito.when((Object)billingFrequency.getFrequency()).thenReturn((Object)"PDBS");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setAwardAccounts(AwardRuleTest.setupAwardAccounts());
        this.cutSpy.oldAwardCopy = this.award;
        this.cutSpy.newAwardCopy = this.award;
        Assertions.assertTrue((boolean)this.cutSpy.performContractsGrantsBillingChecks());
    }

    private static List<AwardFundManager> setupAwardFundManagers() {
        ArrayList<AwardFundManager> awardFundManagers = new ArrayList<AwardFundManager>();
        AwardFundManager awardFundManager = (AwardFundManager)Mockito.spy(AwardFundManager.class);
        awardFundManager.setPrincipalId("5334003983");
        awardFundManager.setPrimaryFundManagerIndicator(true);
        PersonImpl fundManagerMock = (PersonImpl)Mockito.mock(PersonImpl.class);
        awardFundManager.setFundManager(fundManagerMock);
        awardFundManagers.add(awardFundManager);
        ((AwardFundManager)Mockito.doReturn((Object)fundManagerMock).when((Object)awardFundManager)).getFundManager();
        return awardFundManagers;
    }

    private Award setupAwardCopy() {
        Award awardCopy = (Award)ObjectUtils.deepCopy((Serializable)this.award);
        List<AwardAccount> awardAccounts = AwardRuleTest.setupAwardAccounts();
        awardCopy.setAwardAccounts(awardAccounts);
        AccountsReceivableBillingFrequency billingFrequencyMock = (AccountsReceivableBillingFrequency)Mockito.mock(AccountsReceivableBillingFrequency.class);
        Mockito.when((Object)billingFrequencyMock.getFrequency()).thenReturn((Object)awardCopy.getBillingFrequencyCode());
        awardCopy.setBillingFrequency(billingFrequencyMock);
        return awardCopy;
    }

    private static List<AwardAccount> setupAwardAccounts() {
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(AwardRuleTest.setupAwardAccount("0211821"));
        awardAccounts.add(AwardRuleTest.setupAwardAccount("0211822"));
        return awardAccounts;
    }

    private static AwardAccount setupAwardAccount(String accountNumber) {
        AwardAccount awardAccount = (AwardAccount)Mockito.spy(AwardAccount.class);
        awardAccount.setChartOfAccountsCode("BL");
        awardAccount.setAccountNumber(accountNumber);
        awardAccount.setPrincipalId("5334003983");
        awardAccount.setActive(true);
        return awardAccount;
    }
}

