/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.businessobject.inquiry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.kns.datadictionary.InquirySectionDefinition;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.inquiry.InquiryRestrictions;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.kns.web.ui.SectionBridge;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cg.service.ContractsAndGrantsBillingService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.krad.bo.BusinessObject;

public class AgencyInquirableImpl
extends KualiInquirableImpl {
    private static final Logger LOG = LogManager.getLogger();

    public List<Section> getSections(BusinessObject businessObject) {
        ArrayList<Section> sections = new ArrayList<Section>();
        if (this.getBusinessObjectClass() == null) {
            LOG.error("Business object class not set in inquirable.");
            throw new RuntimeException("Business object class not set in inquirable.");
        }
        InquiryRestrictions inquiryRestrictions = KNSServiceLocator.getBusinessObjectAuthorizationService().getInquiryRestrictions(businessObject, GlobalVariables.getUserSession().getPerson());
        List inquirySections = this.getBusinessObjectDictionaryService().getInquirySections(this.getBusinessObjectClass());
        Collection<?> sectionIdsToIgnore = this.getSectionIdsToIgnore();
        for (InquirySectionDefinition inquirySection : inquirySections) {
            String sectionId = inquirySection.getId();
            if (inquiryRestrictions.isHiddenSectionId(sectionId) || sectionIdsToIgnore.contains(sectionId)) continue;
            Section section = SectionBridge.toSection((Inquirable)this, (InquirySectionDefinition)inquirySection, (BusinessObject)businessObject, (InquiryRestrictions)inquiryRestrictions);
            sections.add(section);
        }
        return sections;
    }

    protected Collection<?> getSectionIdsToIgnore() {
        if (!((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).isContractsGrantsBillingEnhancementActive()) {
            return ((ContractsAndGrantsBillingService)SpringContext.getBean(ContractsAndGrantsBillingService.class)).getAgencyContractsGrantsBillingSectionIds();
        }
        return CollectionUtils.EMPTY_COLLECTION;
    }
}

