/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.businessobject;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractAndGrantsProposal;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.PersonImpl;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.CFDA;
import org.kuali.kfs.module.cg.businessobject.ProposalAwardType;
import org.kuali.kfs.module.cg.businessobject.ProposalOrganization;
import org.kuali.kfs.module.cg.businessobject.ProposalProjectDirector;
import org.kuali.kfs.module.cg.businessobject.ProposalPurpose;
import org.kuali.kfs.module.cg.businessobject.ProposalResearchRisk;
import org.kuali.kfs.module.cg.businessobject.ProposalStatus;
import org.kuali.kfs.module.cg.businessobject.ProposalSubcontractor;
import org.kuali.kfs.sys.context.SpringContext;

public class Proposal
extends PersistableBusinessObjectBase
implements MutableInactivatable,
ContractAndGrantsProposal {
    private String proposalNumber;
    private Date proposalBeginningDate;
    private Date proposalEndingDate;
    private KualiDecimal proposalTotalAmount;
    private KualiDecimal proposalDirectCostAmount;
    private KualiDecimal proposalIndirectCostAmount;
    private Date proposalRejectedDate;
    private Timestamp proposalLastUpdateDate;
    private Date proposalDueDate;
    private KualiDecimal proposalTotalProjectAmount;
    private Date proposalSubmissionDate;
    private boolean proposalFederalPassThroughIndicator;
    private String oldProposalNumber;
    private String grantNumber;
    private Date proposalClosingDate;
    private String proposalAwardTypeCode;
    private String agencyNumber;
    private String proposalStatusCode;
    private String federalPassThroughAgencyNumber;
    private String cfdaNumber;
    private String proposalFellowName;
    private String proposalPurposeCode;
    private String proposalProjectTitle;
    private boolean active;
    private List<ProposalSubcontractor> proposalSubcontractors = new ArrayList<ProposalSubcontractor>();
    private List<ProposalOrganization> proposalOrganizations = new ArrayList<ProposalOrganization>();
    private List<ProposalProjectDirector> proposalProjectDirectors = new ArrayList<ProposalProjectDirector>();
    private List<ProposalResearchRisk> proposalResearchRisks = new ArrayList<ProposalResearchRisk>();
    private ProposalAwardType proposalAwardType;
    private Agency agency;
    private ProposalStatus proposalStatus;
    private Agency federalPassThroughAgency;
    private ProposalPurpose proposalPurpose;
    private CFDA cfda;
    private ProposalOrganization primaryProposalOrganization;
    private String routingOrg;
    private String routingChart;
    private Award award;
    private transient String lookupProjectDirectorUniversalIdentifier;
    private transient PersonImpl lookupProjectDirector;

    public Award getAward() {
        return this.award;
    }

    public void setAward(Award award) {
        this.award = award;
    }

    public List<Collection<PersistableBusinessObject>> buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getProposalSubcontractors());
        managedLists.add(this.getProposalOrganizations());
        managedLists.add(this.getProposalProjectDirectors());
        return managedLists;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public Date getProposalBeginningDate() {
        return this.proposalBeginningDate;
    }

    public void setProposalBeginningDate(Date proposalBeginningDate) {
        this.proposalBeginningDate = proposalBeginningDate;
    }

    public Date getProposalEndingDate() {
        return this.proposalEndingDate;
    }

    public void setProposalEndingDate(Date proposalEndingDate) {
        this.proposalEndingDate = proposalEndingDate;
    }

    public KualiDecimal getProposalTotalAmount() {
        KualiDecimal direct = this.getProposalDirectCostAmount();
        KualiDecimal indirect = this.getProposalIndirectCostAmount();
        return ObjectUtils.isNull((Object)direct) || ObjectUtils.isNull((Object)indirect) ? null : (KualiDecimal)direct.add((AbstractKualiDecimal)indirect);
    }

    public void setProposalTotalAmount(KualiDecimal proposalTotalAmount) {
    }

    protected void beforeInsert() {
        super.beforeInsert();
        this.proposalTotalAmount = this.getProposalTotalAmount();
    }

    protected void beforeUpdate() {
        super.beforeUpdate();
        this.proposalTotalAmount = this.getProposalTotalAmount();
    }

    public KualiDecimal getProposalDirectCostAmount() {
        return this.proposalDirectCostAmount;
    }

    public void setProposalDirectCostAmount(KualiDecimal proposalDirectCostAmount) {
        this.proposalDirectCostAmount = proposalDirectCostAmount;
    }

    public KualiDecimal getProposalIndirectCostAmount() {
        return this.proposalIndirectCostAmount;
    }

    public void setProposalIndirectCostAmount(KualiDecimal proposalIndirectCostAmount) {
        this.proposalIndirectCostAmount = proposalIndirectCostAmount;
    }

    public Date getProposalRejectedDate() {
        return this.proposalRejectedDate;
    }

    public void setProposalRejectedDate(Date proposalRejectedDate) {
        this.proposalRejectedDate = proposalRejectedDate;
    }

    public Timestamp getProposalLastUpdateDate() {
        return this.proposalLastUpdateDate;
    }

    public void setProposalLastUpdateDate(Timestamp proposalLastUpdateDate) {
        this.proposalLastUpdateDate = proposalLastUpdateDate;
    }

    public Date getProposalDueDate() {
        return this.proposalDueDate;
    }

    public void setProposalDueDate(Date proposalDueDate) {
        this.proposalDueDate = proposalDueDate;
    }

    public KualiDecimal getProposalTotalProjectAmount() {
        return this.proposalTotalProjectAmount;
    }

    public void setProposalTotalProjectAmount(KualiDecimal proposalTotalProjectAmount) {
        this.proposalTotalProjectAmount = proposalTotalProjectAmount;
    }

    public Date getProposalSubmissionDate() {
        return this.proposalSubmissionDate;
    }

    public void setProposalSubmissionDate(Date proposalSubmissionDate) {
        this.proposalSubmissionDate = proposalSubmissionDate;
    }

    public boolean getProposalFederalPassThroughIndicator() {
        return this.proposalFederalPassThroughIndicator;
    }

    public void setProposalFederalPassThroughIndicator(boolean proposalFederalPassThroughIndicator) {
        this.proposalFederalPassThroughIndicator = proposalFederalPassThroughIndicator;
    }

    public String getOldProposalNumber() {
        return this.oldProposalNumber;
    }

    public void setOldProposalNumber(String oldProposalNumber) {
        this.oldProposalNumber = oldProposalNumber;
    }

    public String getGrantNumber() {
        return this.grantNumber;
    }

    public void setGrantNumber(String grantNumber) {
        this.grantNumber = grantNumber;
    }

    public Date getProposalClosingDate() {
        return this.proposalClosingDate;
    }

    public void setProposalClosingDate(Date proposalClosingDate) {
        this.proposalClosingDate = proposalClosingDate;
    }

    public String getProposalAwardTypeCode() {
        return this.proposalAwardTypeCode;
    }

    public void setProposalAwardTypeCode(String proposalAwardTypeCode) {
        this.proposalAwardTypeCode = proposalAwardTypeCode;
    }

    public String getAgencyNumber() {
        return this.agencyNumber;
    }

    public void setAgencyNumber(String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public String getProposalStatusCode() {
        return this.proposalStatusCode;
    }

    public void setProposalStatusCode(String proposalStatusCode) {
        this.proposalStatusCode = proposalStatusCode;
    }

    public String getFederalPassThroughAgencyNumber() {
        return this.federalPassThroughAgencyNumber;
    }

    public void setFederalPassThroughAgencyNumber(String federalPassThroughAgencyNumber) {
        this.federalPassThroughAgencyNumber = federalPassThroughAgencyNumber;
    }

    public String getCfdaNumber() {
        return this.cfdaNumber;
    }

    public void setCfdaNumber(String cfdaNumber) {
        this.cfdaNumber = cfdaNumber;
    }

    public String getProposalFellowName() {
        return this.proposalFellowName;
    }

    public void setProposalFellowName(String proposalFellowName) {
        this.proposalFellowName = proposalFellowName;
    }

    public String getProposalPurposeCode() {
        return this.proposalPurposeCode;
    }

    public void setProposalPurposeCode(String proposalPurposeCode) {
        this.proposalPurposeCode = proposalPurposeCode;
    }

    public String getProposalProjectTitle() {
        return this.proposalProjectTitle;
    }

    public void setProposalProjectTitle(String proposalProjectTitle) {
        this.proposalProjectTitle = proposalProjectTitle;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public ProposalAwardType getProposalAwardType() {
        return this.proposalAwardType;
    }

    @Deprecated
    public void setProposalAwardType(ProposalAwardType proposalAwardType) {
        this.proposalAwardType = proposalAwardType;
    }

    public Agency getAgency() {
        return this.agency;
    }

    @Deprecated
    public void setAgency(Agency agency) {
        this.agency = agency;
    }

    public ProposalStatus getProposalStatus() {
        return this.proposalStatus;
    }

    @Deprecated
    public void setProposalStatus(ProposalStatus proposalStatus) {
        this.proposalStatus = proposalStatus;
    }

    public Agency getFederalPassThroughAgency() {
        return this.federalPassThroughAgency;
    }

    @Deprecated
    public void setFederalPassThroughAgency(Agency federalPassThroughAgency) {
        this.federalPassThroughAgency = federalPassThroughAgency;
    }

    public ProposalPurpose getProposalPurpose() {
        return this.proposalPurpose;
    }

    @Deprecated
    public void setProposalPurpose(ProposalPurpose proposalPurpose) {
        this.proposalPurpose = proposalPurpose;
    }

    public CFDA getCfda() {
        return this.cfda;
    }

    @Deprecated
    public void setCfda(CFDA cfda) {
        this.cfda = cfda;
    }

    public List<ProposalSubcontractor> getProposalSubcontractors() {
        return this.proposalSubcontractors;
    }

    public void setProposalSubcontractors(List<ProposalSubcontractor> proposalSubcontractors) {
        this.proposalSubcontractors = proposalSubcontractors;
    }

    public List<ProposalOrganization> getProposalOrganizations() {
        return this.proposalOrganizations;
    }

    public void setProposalOrganizations(List<ProposalOrganization> proposalOrganizations) {
        this.proposalOrganizations = proposalOrganizations;
    }

    public List<ProposalProjectDirector> getProposalProjectDirectors() {
        return this.proposalProjectDirectors;
    }

    public void setProposalProjectDirectors(List<ProposalProjectDirector> proposalProjectDirectors) {
        this.proposalProjectDirectors = proposalProjectDirectors;
    }

    public List<ProposalResearchRisk> getProposalResearchRisks() {
        return this.proposalResearchRisks;
    }

    public List<ProposalResearchRisk> getActiveProposalResearchRisks() {
        ArrayList<ProposalResearchRisk> activeRisks = new ArrayList<ProposalResearchRisk>();
        for (ProposalResearchRisk risk : this.proposalResearchRisks) {
            if (!risk.isActive()) continue;
            activeRisks.add(risk);
        }
        return activeRisks;
    }

    public void setProposalResearchRisks(List<ProposalResearchRisk> proposalResearchRisks) {
        this.proposalResearchRisks = proposalResearchRisks;
    }

    public PersonImpl getLookupProjectDirector() {
        return this.lookupProjectDirector;
    }

    public void setLookupProjectDirector(PersonImpl lookupProjectDirector) {
        this.lookupProjectDirector = lookupProjectDirector;
    }

    public String getLookupProjectDirectorUniversalIdentifier() {
        this.lookupProjectDirector = (PersonImpl)((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.lookupProjectDirectorUniversalIdentifier, (Person)this.lookupProjectDirector);
        return this.lookupProjectDirectorUniversalIdentifier;
    }

    public void setLookupProjectDirectorUniversalIdentifier(String lookupPersonId) {
        this.lookupProjectDirectorUniversalIdentifier = lookupPersonId;
    }

    public String getRoutingChart() {
        return this.routingChart;
    }

    public void setRoutingChart(String routingChart) {
        this.routingChart = routingChart;
    }

    public String getRoutingOrg() {
        return this.routingOrg;
    }

    public void setRoutingOrg(String routingOrg) {
        this.routingOrg = routingOrg;
    }

    public ProposalOrganization getPrimaryProposalOrganization() {
        for (ProposalOrganization po : this.proposalOrganizations) {
            if (po == null || !po.isProposalPrimaryOrganizationIndicator()) continue;
            this.setPrimaryProposalOrganization(po);
            break;
        }
        return this.primaryProposalOrganization;
    }

    public void setPrimaryProposalOrganization(ProposalOrganization primaryProposalOrganization) {
        this.primaryProposalOrganization = primaryProposalOrganization;
        this.routingChart = primaryProposalOrganization.getChartOfAccountsCode();
        this.routingOrg = primaryProposalOrganization.getOrganizationCode();
    }

    public String getUserLookupRoleNamespaceCode() {
        return "KFS-SYS";
    }

    public String getUserLookupRoleName() {
        return "Contracts & Grants Project Director";
    }
}

