/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cg.businessobject.Proposal;
import org.kuali.kfs.module.cg.businessobject.ProposalOrganization;
import org.kuali.kfs.module.cg.businessobject.ProposalProjectDirector;
import org.kuali.kfs.module.cg.businessobject.ProposalSubcontractor;
import org.kuali.kfs.module.cg.document.validation.impl.CGMaintenanceDocumentRuleBase;

public class ProposalRule
extends CGMaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger();
    protected Proposal newProposalCopy;

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument documentCopy) {
        LOG.debug("Entering ProposalRule.processCustomSaveDocumentBusinessRules");
        this.processCustomRouteDocumentBusinessRules(documentCopy);
        LOG.info("Leaving ProposalRule.processCustomSaveDocumentBusinessRules");
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument documentCopy) {
        LOG.debug("Entering ProposalRule.processCustomRouteDocumentBusinessRules");
        boolean success = this.checkEndAfterBegin(this.newProposalCopy.getProposalBeginningDate(), this.newProposalCopy.getProposalEndingDate(), "proposalEndingDate");
        success &= this.checkPrimary(this.newProposalCopy.getProposalOrganizations(), ProposalOrganization.class, "proposalOrganizations", Proposal.class);
        success &= this.checkPrimary(this.newProposalCopy.getProposalProjectDirectors(), ProposalProjectDirector.class, "proposalProjectDirectors", Proposal.class);
        success &= this.checkProjectDirectorsAreDirectors(this.newProposalCopy.getProposalProjectDirectors(), ProposalProjectDirector.class, "proposalProjectDirectors");
        success &= this.checkProjectDirectorsExist(this.newProposalCopy.getProposalProjectDirectors(), ProposalProjectDirector.class, "proposalProjectDirectors");
        success &= this.checkProjectDirectorsStatuses(this.newProposalCopy.getProposalProjectDirectors(), ProposalProjectDirector.class, "proposalProjectDirectors");
        success &= this.checkFederalPassThrough(this.newProposalCopy.getProposalFederalPassThroughIndicator(), this.newProposalCopy.getAgency(), this.newProposalCopy.getFederalPassThroughAgencyNumber(), Proposal.class, "proposalFederalPassThroughIndicator");
        LOG.info("Leaving ProposalRule.processCustomRouteDocumentBusinessRules");
        return success &= this.checkAgencyNotEqualToFederalPassThroughAgency(this.newProposalCopy.getAgency(), this.newProposalCopy.getFederalPassThroughAgency(), "agencyNumber", "federalPassThroughAgencyNumber");
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering ProposalRule.processCustomAddNewCollectionLineBusinessRules( " + collectionName + " )");
        }
        boolean success = this.validateAddSubcontractor(line);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Leaving ProposalRule.processCustomAddNewCollectionLineBusinessRules( " + collectionName + " )");
        }
        return success;
    }

    protected boolean validateAddSubcontractor(PersistableBusinessObject addLine) {
        ProposalSubcontractor subc;
        boolean success = true;
        if (addLine.getClass().isAssignableFrom(ProposalSubcontractor.class) && StringUtils.isBlank((CharSequence)(subc = (ProposalSubcontractor)addLine).getSubcontractorNumber())) {
            String propertyName = "subcontractorNumber";
            String errorKey = "error.cg.proposal.subcontractorNumberRequiredForAdd";
            GlobalVariables.getMessageMap().putError(propertyName, errorKey, new String[0]);
            success = false;
        }
        return success;
    }

    public void setupConvenienceObjects() {
        this.newProposalCopy = (Proposal)((Object)super.getNewBo());
    }
}

