/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cg;

/**
 * Holds error key constants for CG.
 */
public final class CGKeyConstants {

    public static final String ERROR_DUPLICATE_AWARD_ACCOUNT = "error.cg.duplicate.awardAccount";
    public static final String ERROR_DUPLICATE_AWARD_PROJECT_DIRECTOR = "error.cg.duplicate.awardProjectDirector";
    public static final String ERROR_DUPLICATE_AWARD_ORGANIZATION = "error.cg.duplicate.awardOrganization";

    /**
     * Private Constructor since this is a constants class that should never be instantiated.
     */
    private CGKeyConstants() {
    }

    // Award Constants and errors
    public static class AwardConstants {
        public static final String ERROR_CG_ACTIVE_MILESTONES_EXIST = "error.cg.active.milestones.exist";
        public static final String ERROR_CG_ACTIVE_BILLS_EXIST = "error.cg.active.bills.exist";
        public static final String ERROR_CG_INVALID_INVOICING_OPTION = "error.cg.invalid.invoicing.option";
        public static final String ERROR_CG_BILLING_FREQUENCY_AND_INVOICING_OPTION_REQUIRED =
                "error.cg.billing.frequency.and.invoicing.option.required";
        public static final String ERROR_CG_BILLING_CUSTOMER_ADDRESS_MUST_MATCH_AGENCY_CUSTOMER =
                "error.cg.billing.customer.address.must.match.agency.customer";
        public static final String WARNING_CG_AWARD_TOTAL_AWARD_AMOUNT_LESS_THAN_SCHEDULED_AMOUNT =
                "warning.cg.award.totalAwardAmountLessThanScheduleAmount";
        public static final String MILESTONE_SCHEDULE_STRING = "Milestone";
        public static final String PREDETERMINED_BILLING_SCHEDULE_STRING = "Predetermined Billing";
    }

    // Agency constants and errors
    public static class AgencyConstants {
        public static final String ERROR_AGENCY_NAME_LESS_THAN_THREE_CHARACTERS =
                "error.document.agency.agencyNameLessThanThreeCharacters";
        public static final String ERROR_AGENCY_NAME_NO_SPACES_IN_FIRST_THREE_CHARACTERS =
                "error.document.agency.agencyNameNoSpacesInFirstThreeCharacters";
        public static final String AGENCY_ADDRESS_TYPE_CODE_US = "US";
        public static final String ERROR_AGENCY_ADDRESS_STATE_CODE_REQUIRED_WHEN_COUNTRY_US =
                "error.document.agency.stateCodeIsRequiredWhenCountryUS";
        public static final String ERROR_AGENCY_ADDRESS_ZIP_CODE_REQUIRED_WHEN_COUNTRY_US =
                "error.document.agency.zipCodeIsRequiredWhenCountryUS";
        public static final String ERROR_AGENCY_ADDRESS_INTERNATIONAL_PROVINCE_NAME_REQUIRED_WHEN_COUNTRY_NON_US =
                "error.document.agency.addressInternationalProvinceNameIsRequiredWhenCountryNonUS";
        public static final String ERROR_AGENCY_ADDRESS_INTERNATIONAL_MAIL_CODE_REQUIRED_WHEN_COUNTRY_NON_US =
                "error.document.agency.internationalMailCodeIsRequiredWhenCountryNonUS";
        public static final String ERROR_AGENCY_CUSTOMER_TYPE_CODE_REQUIRED_WHEN_AGENCY_CUSTOMER_NEW =
                "error.document.agency.customerTypeCodeisRequiredWhenNewCustomer";
        public static final String ERROR_AGENCY_CUSTOMER_NUMBER_REQUIRED_WHEN_AGENCY_CUSTOMER_EXISTING =
                "error.document.agency.customerNumberRequiredWhenExistingCustomer";
        public static final String ERROR_AGENCY_ACTUAL_CUSTOMER_REQUIRED_WHEN_AGENCY_CUSTOMER_EXISTING =
                "error.document.agency.actualCustomerRequiredWhenExistingCustomer";
    }
}
