/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.util.HashMap;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.rules.DocumentRuleBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.AgencyAddress;
import org.kuali.kfs.module.cg.businessobject.AgencyType;
import org.kuali.kfs.module.cg.document.validation.impl.AgencyRule;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.util.AutoPopulatingList;

@Execution(value=ExecutionMode.SAME_THREAD)
public class AgencyRuleTest {
    private AgencyRule cutSpy;
    @Mock
    private Agency agencyMock;
    @Mock
    private BusinessObjectService boSvcMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private MaintenanceDocument documentMock;
    private AgencyAddress agencyAddress;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.agencyMock.getAgencyNumber()).thenReturn((Object)"11505");
        Mockito.when((Object)this.agencyMock.getReportingName()).thenReturn((Object)"USAIR FORCE");
        Mockito.when((Object)this.agencyMock.getFullName()).thenReturn((Object)"U.S. AIR FORCE");
        Mockito.when((Object)this.agencyMock.getAgencyTypeCode()).thenReturn((Object)"P");
        Mockito.when((Object)this.agencyMock.getCustomerCreationOptionCode()).thenReturn((Object)"C");
        this.agencyAddress = new AgencyAddress();
        this.agencyAddress.setAgencyAddressName("Address Name");
        this.cutSpy = (AgencyRule)Mockito.spy(AgencyRule.class);
        this.cutSpy.setBoService(this.boSvcMock);
        this.cutSpy.newAgency = this.agencyMock;
        DocumentRuleBase.setDataDictionaryService((DataDictionaryService)this.dataDictionarySvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterAll
    public static void tearDown() {
        DocumentRuleBase.setDataDictionaryService(null);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void checkAgencyReportsTo_valid() {
        Agency reportsToAgency = new Agency();
        reportsToAgency.setAgencyNumber("12010");
        reportsToAgency.setActive(true);
        Mockito.when((Object)this.agencyMock.getReportsToAgencyNumber()).thenReturn((Object)"12010");
        Mockito.when((Object)this.agencyMock.getReportsToAgency()).thenReturn((Object)reportsToAgency);
        Assertions.assertTrue((boolean)this.cutSpy.checkAgencyReportsTo(null));
    }

    @Test
    public void checkAgencyReportsTo_nullReportsToAgencyNumber_valid() {
        Assertions.assertTrue((boolean)this.cutSpy.checkAgencyReportsTo(null));
    }

    @Test
    public void checkAgencyReportsTo_inactiveReportsToAgency_invalid() {
        Agency reportsToAgency = new Agency();
        reportsToAgency.setAgencyNumber("12010");
        Mockito.when((Object)this.agencyMock.getReportsToAgencyNumber()).thenReturn((Object)"12010");
        Mockito.when((Object)this.agencyMock.getReportsToAgency()).thenReturn((Object)reportsToAgency);
        Assertions.assertFalse((boolean)this.cutSpy.checkAgencyReportsTo(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.reportsToAgencyNumber")).get(0);
        Assertions.assertEquals((Object)"error.cg.agenyInactive", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"12010", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void checkAgencyReportsTo_reportsToAgencyHasSameAgencyNumber_invalid() {
        Agency reportsToAgency = new Agency();
        reportsToAgency.setAgencyNumber("11505");
        reportsToAgency.setActive(true);
        Mockito.when((Object)this.agencyMock.getReportsToAgencyNumber()).thenReturn((Object)"11505");
        Mockito.when((Object)this.agencyMock.getReportsToAgency()).thenReturn((Object)reportsToAgency);
        Assertions.assertFalse((boolean)this.cutSpy.checkAgencyReportsTo(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.reportsToAgencyNumber")).get(0);
        Assertions.assertEquals((Object)"error.cg.agencyReportsToSelf", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"11505", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void checkAgencyReportsTo_circularReporting_invalid() {
        Agency reportsToAgency = new Agency();
        reportsToAgency.setAgencyNumber("12010");
        reportsToAgency.setActive(true);
        reportsToAgency.setReportsToAgency(this.agencyMock);
        Mockito.when((Object)this.agencyMock.getReportsToAgencyNumber()).thenReturn((Object)"12010");
        Mockito.when((Object)this.agencyMock.getReportsToAgency()).thenReturn((Object)reportsToAgency);
        Assertions.assertFalse((boolean)this.cutSpy.checkAgencyReportsTo(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.reportsToAgencyNumber")).get(0);
        Assertions.assertEquals((Object)"error.cg.agencyCircularReporting", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"11505", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void validateAgencyType_found_valid() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", this.agencyMock.getAgencyTypeCode());
        Mockito.when((Object)((AgencyType)this.boSvcMock.findByPrimaryKey(AgencyType.class, params))).thenReturn((Object)new AgencyType());
        Assertions.assertTrue((boolean)this.cutSpy.validateAgencyType(null));
    }

    @Test
    public void validateAgencyType_notFound_invalid() {
        Assertions.assertFalse((boolean)this.cutSpy.validateAgencyType(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.agencyTypeCode")).get(0);
        Assertions.assertEquals((Object)"error.cg.agencyTypeNotFound", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"P", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void validateAgencyReportingName_createNewCustomer_ValidName_valid() {
        Assertions.assertTrue((boolean)this.cutSpy.validateAgencyReportingName(null));
    }

    @Test
    public void validateAgencyReportingName_useExistingCustomer_ShortName_valid() {
        Mockito.when((Object)this.agencyMock.getReportingName()).thenReturn((Object)"US");
        Mockito.when((Object)this.agencyMock.getCustomerCreationOptionCode()).thenReturn((Object)"E");
        Assertions.assertTrue((boolean)this.cutSpy.validateAgencyReportingName(null));
    }

    @Test
    public void validateAgencyReportingName_createNewCustomer_ShortName_invalid() {
        Mockito.when((Object)this.agencyMock.getReportingName()).thenReturn((Object)"US");
        Assertions.assertFalse((boolean)this.cutSpy.validateAgencyReportingName(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.reportingName")).get(0);
        Assertions.assertEquals((Object)"error.document.agency.agencyNameLessThanThreeCharacters", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validateAgencyReportingName_createNewCustomer_StartsWithSpaces_invalid() {
        Mockito.when((Object)this.agencyMock.getReportingName()).thenReturn((Object)"  US");
        Assertions.assertFalse((boolean)this.cutSpy.validateAgencyReportingName(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.reportingName")).get(0);
        Assertions.assertEquals((Object)"error.document.agency.agencyNameNoSpacesInFirstThreeCharacters", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    public void checkAddressIsValid_CountryUS_EmptyStateCode_EmptyZipCode_useExistingCustomer_valid() {
        Mockito.when((Object)this.agencyMock.getCustomerCreationOptionCode()).thenReturn((Object)"E");
        this.agencyAddress.setAgencyCountryCode("US");
        this.agencyAddress.setAgencyStateCode("");
        this.agencyAddress.setAgencyZipCode("");
        Assertions.assertTrue((boolean)this.cutSpy.checkAddressIsValid(this.agencyAddress));
    }

    @Test
    public void checkAddressIsValid_CountryUS_validAddress_valid() {
        this.agencyAddress.setAgencyCountryCode("US");
        this.agencyAddress.setAgencyStateCode("NY");
        this.agencyAddress.setAgencyZipCode("14850");
        Assertions.assertTrue((boolean)this.cutSpy.checkAddressIsValid(this.agencyAddress));
    }

    @Test
    public void checkAddressIsValid_CountryNonUS_validAddress_valid() {
        this.agencyAddress.setAgencyCountryCode("RO");
        this.agencyAddress.setAgencyAddressInternationalProvinceName("ONT");
        this.agencyAddress.setAgencyZipCode("ABC 123");
        Assertions.assertFalse((boolean)this.cutSpy.checkAddressIsValid(this.agencyAddress));
    }

    @Test
    public void checkAddressIsValid_CountryUS_EmptyStateCode_EmptyZipCode_Invalid() {
        this.agencyAddress.setAgencyCountryCode("US");
        this.agencyAddress.setAgencyStateCode("");
        this.agencyAddress.setAgencyZipCode("");
        Assertions.assertFalse((boolean)this.cutSpy.checkAddressIsValid(this.agencyAddress));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("agencyZipCode")).get(0);
        Assertions.assertEquals((Object)"error.document.agency.zipCodeIsRequiredWhenCountryUS", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
        errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("agencyStateCode")).get(0);
        Assertions.assertEquals((Object)"error.document.agency.stateCodeIsRequiredWhenCountryUS", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    public void checkAddressIsValid_CountryNonUS_EmptyProvinceName_EmptyZipCode_Invalid() {
        this.agencyAddress.setAgencyCountryCode("RO");
        this.agencyAddress.setAgencyAddressInternationalProvinceName("");
        this.agencyAddress.setAgencyZipCode("");
        Assertions.assertFalse((boolean)this.cutSpy.checkAddressIsValid(this.agencyAddress));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("agencyInternationalMailCode")).get(0);
        Assertions.assertEquals((Object)"error.document.agency.internationalMailCodeIsRequiredWhenCountryNonUS", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
        errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("agencyAddressInternationalProvinceName")).get(0);
        Assertions.assertEquals((Object)"error.document.agency.addressInternationalProvinceNameIsRequiredWhenCountryNonUS", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_newCustomer_primaryAddressRequired() {
        Mockito.when((Object)this.agencyMock.getCustomerTypeCode()).thenReturn((Object)"01");
        ((AgencyRule)Mockito.doReturn((Object)true).when((Object)this.cutSpy)).isContractsGrantsBillingEnhancementActive();
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.documentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.agencyAddresses")).get(0);
        Assertions.assertEquals((Object)"error.cg.noPrimary", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertNull((Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_existingCustomer_primaryAddressNotRequired() {
        AccountsReceivableCustomer customerMock = (AccountsReceivableCustomer)Mockito.mock(AccountsReceivableCustomer.class);
        Mockito.when((Object)customerMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.agencyMock.getCustomerCreationOptionCode()).thenReturn((Object)"E");
        Mockito.when((Object)this.agencyMock.getCustomerTypeCode()).thenReturn((Object)"01");
        Mockito.when((Object)this.agencyMock.getCustomerNumber()).thenReturn((Object)"0123456");
        Mockito.when((Object)this.agencyMock.getCustomer()).thenReturn((Object)customerMock);
        ((AgencyRule)Mockito.doReturn((Object)true).when((Object)this.cutSpy)).isContractsGrantsBillingEnhancementActive();
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.documentMock));
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_noCustomer_primaryAddressNotRequired() {
        Mockito.when((Object)this.agencyMock.getCustomerCreationOptionCode()).thenReturn((Object)"N");
        ((AgencyRule)Mockito.doReturn((Object)true).when((Object)this.cutSpy)).isContractsGrantsBillingEnhancementActive();
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.documentMock));
    }
}

