/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.document.validation.impl.AwardRule;
import org.kuali.kfs.module.cg.fixture.AwardFixture;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
@Execution(value=ExecutionMode.SAME_THREAD)
class AwardRule2Test {
    private final AccountsReceivableModuleBillingService accountsReceivableModuleBillingSvcMock = (AccountsReceivableModuleBillingService)Mockito.mock(AccountsReceivableModuleBillingService.class);
    private Award award;
    private AwardRule cutSpy;

    AwardRule2Test() {
    }

    @BeforeEach
    void setUp() {
        this.cutSpy = (AwardRule)Mockito.spy((Object)new AwardRule());
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)true);
        this.award = AwardFixture.CG_AWARD_INV_ACCOUNT.createAward();
        GlobalVariables.getMessageMap().getErrorMessages().clear();
    }

    @AfterEach
    void tearDown() {
        this.cutSpy.setDictionaryValidationService(null);
    }

    @Test
    void checkAwardFundManager() {
        boolean actual;
        this.award.setAwardFundManagers(AwardRule2Test.setupAwardFundManagers());
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountsReceivableModuleBillingService.class)).thenReturn((Object)this.accountsReceivableModuleBillingSvcMock);
            actual = this.cutSpy.checkAwardFundManager((AwardFundManager)this.award.getAwardFundManagers().get(0));
        }
        Assertions.assertTrue((boolean)actual);
    }

    private static List<AwardFundManager> setupAwardFundManagers() {
        ArrayList<AwardFundManager> awardFundManagers = new ArrayList<AwardFundManager>();
        AwardFundManager awardFundManager = (AwardFundManager)Mockito.spy(AwardFundManager.class);
        awardFundManager.setPrincipalId("5334003983");
        awardFundManager.setPrimaryFundManagerIndicator(true);
        Person fundManagerMock = (Person)Mockito.mock(Person.class);
        awardFundManager.setFundManager(fundManagerMock);
        awardFundManagers.add(awardFundManager);
        ((AwardFundManager)Mockito.doReturn((Object)fundManagerMock).when((Object)awardFundManager)).getFundManager();
        return awardFundManagers;
    }
}

