/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.sql.Date;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kim.api.identity.IdentityService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kim.impl.identity.entity.Entity;
import org.kuali.kfs.krad.rules.DocumentRuleBase;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.AgencyAddress;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.cg.document.validation.impl.CGMaintenanceDocumentRuleBase;
import org.mockito.Mockito;
import org.springframework.util.AutoPopulatingList;

@Execution(value=ExecutionMode.SAME_THREAD)
class CGMaintenanceDocumentRuleBaseTest {
    private static final String AGENCY_NUMBER = "55076";
    private final Award awardMock = (Award)Mockito.mock(Award.class);
    private final DataDictionaryService dataDictionarySvcMock = (DataDictionaryService)Mockito.mock(DataDictionaryService.class);
    private final IdentityService identitySvcMock = (IdentityService)Mockito.mock(IdentityService.class);
    private final CGMaintenanceDocumentRuleBase cutSpy = (CGMaintenanceDocumentRuleBase)Mockito.spy((Object)new CGMaintenanceDocumentRuleBase());

    CGMaintenanceDocumentRuleBaseTest() {
    }

    @BeforeEach
    void setUp() {
        ((CGMaintenanceDocumentRuleBase)Mockito.doReturn((Object)this.identitySvcMock).when((Object)this.cutSpy)).getIdentityService();
        Mockito.when((Object)this.identitySvcMock.getEntityByPrincipalId("wklykins")).thenReturn((Object)new Entity());
        DocumentRuleBase.setDataDictionaryService((DataDictionaryService)this.dataDictionarySvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        DocumentRuleBase.setDataDictionaryService(null);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void checkEndAfterBegin() {
        Date begin = new Date(11111L);
        Date end = new Date(11115L);
        Assertions.assertFalse((boolean)this.cutSpy.checkEndAfterBegin(begin, begin, ""));
        Assertions.assertTrue((boolean)this.cutSpy.checkEndAfterBegin(begin, end, ""));
    }

    @Test
    void checkPrimary() {
        AgencyAddress agencyAddress = new AgencyAddress();
        agencyAddress.setCustomerAddressTypeCode("P");
        List<AgencyAddress> agencyAddresses = List.of(agencyAddress);
        boolean primary = this.cutSpy.checkPrimary(agencyAddresses, AgencyAddress.class, "agencyAddresses", Agency.class);
        Assertions.assertTrue((boolean)primary);
    }

    @Test
    void checkProjectDirectorsExist_AwardProjectDirectors() {
        AwardProjectDirector awardProjectDirector = new AwardProjectDirector();
        awardProjectDirector.setPrincipalId("wklykins");
        List<AwardProjectDirector> awardProjectDirectors = List.of(awardProjectDirector);
        boolean projectDirectorsExist = this.cutSpy.checkProjectDirectorsExist(awardProjectDirectors, AwardProjectDirector.class, "awardProjectDirectors");
        Assertions.assertTrue((boolean)projectDirectorsExist);
    }

    @Test
    void checkProjectDirectorsExist_AwardAccounts() {
        AwardAccount awardAccount = new AwardAccount();
        awardAccount.setPrincipalId("wklykins");
        List<AwardAccount> awardAccounts = List.of(awardAccount);
        boolean projectDirectorsExist = this.cutSpy.checkProjectDirectorsExist(awardAccounts, AwardAccount.class, "awardAccounts");
        Assertions.assertTrue((boolean)projectDirectorsExist);
    }

    @Test
    void checkFundManagersExist() {
        AwardFundManager awardFundManager = new AwardFundManager();
        awardFundManager.setPrincipalId("wklykins");
        List<AwardFundManager> awardFundManagers = List.of(awardFundManager);
        boolean fundManagersExist = this.cutSpy.checkFundManagersExist(awardFundManagers, "awardFundManagers");
        Assertions.assertTrue((boolean)fundManagersExist);
    }

    @Test
    void checkProjectDirectorsStatuses() {
        Person projectDirectorMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)projectDirectorMock.getEmployeeStatusCode()).thenReturn((Object)"A");
        AwardProjectDirector awardProjectDirectorMock = (AwardProjectDirector)Mockito.mock(AwardProjectDirector.class);
        Mockito.when((Object)awardProjectDirectorMock.getProjectDirector()).thenReturn((Object)projectDirectorMock);
        List<AwardProjectDirector> awardProjectDirectors = List.of(awardProjectDirectorMock);
        boolean projectDirectorsStatuses = this.cutSpy.checkProjectDirectorsStatuses(awardProjectDirectors, AwardProjectDirector.class, "awardProjectDirectors");
        Assertions.assertTrue((boolean)projectDirectorsStatuses);
    }

    @Test
    void checkFederalPassThrough() {
        boolean federalPassThrough = this.cutSpy.checkFederalPassThrough(this.awardMock.getFederalPassThroughIndicator(), this.awardMock.getAgency(), this.awardMock.getFederalPassThroughAgencyNumber(), Award.class, "federalPassThroughIndicator");
        Assertions.assertTrue((boolean)federalPassThrough);
    }

    @Test
    void checkAgencyNotEqualToFederalPassThroughAgency() {
        Mockito.when((Object)this.awardMock.getAgency()).thenReturn((Object)((Agency)Mockito.mock(Agency.class)));
        boolean notFederalPassThroughAgency = this.cutSpy.checkAgencyNotEqualToFederalPassThroughAgency(this.awardMock.getAgency(), this.awardMock.getFederalPassThroughAgency(), "agencyNumber", "federalPassThroughAgencyNumber");
        Assertions.assertTrue((boolean)notFederalPassThroughAgency);
    }

    @Test
    void testCheckAgencyNotEqualToFederalPassThroughAgency_Equal_INVALID() {
        Agency agency = new Agency();
        agency.setAgencyNumber(AGENCY_NUMBER);
        Agency federalPassThroughAgency = new Agency();
        federalPassThroughAgency.setAgencyNumber(AGENCY_NUMBER);
        boolean notFederalPassThroughAgency = this.cutSpy.checkAgencyNotEqualToFederalPassThroughAgency(agency, federalPassThroughAgency, "agencyNumber", "federalPassThroughAgencyNumber");
        Assertions.assertFalse((boolean)notFederalPassThroughAgency);
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage1 = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.agencyNumber")).get(0);
        Assertions.assertEquals((Object)"error.cg.agencyEqualsFederalPassThroughAgency", (Object)errorMessage1.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage1.getMessageParameters().length);
        ErrorMessage errorMessage2 = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.federalPassThroughAgencyNumber")).get(0);
        Assertions.assertEquals((Object)"error.cg.federalPassThroughAgencyEqualsAgency", (Object)errorMessage2.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage2.getMessageParameters().length);
    }

    @Test
    void testCheckAgencyNotEqualToFederalPassThroughAgency_NotEqual_VALID() {
        Agency agency = new Agency();
        agency.setAgencyNumber(AGENCY_NUMBER);
        Agency federalPassThroughAgency = new Agency();
        federalPassThroughAgency.setAgencyNumber("1");
        boolean notFederalPassThroughAgency = this.cutSpy.checkAgencyNotEqualToFederalPassThroughAgency(agency, federalPassThroughAgency, "agencyNumber", "federalPassThroughAgencyNumber");
        Assertions.assertTrue((boolean)notFederalPassThroughAgency);
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }
}

