/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.sys.context.SpringContext;

/**
 * Rules for the Award maintenance document.
 */
public final class AwardRuleUtil {

    /**
     * Private Constructor since this is a util class that should never be instantiated.
     */
    private AwardRuleUtil() {
    }

    /**
     * Determines if a proposal has already been awarded
     *
     * @param award the award to check the proposal for
     * @return true if the award's proposal has already been awarded
     */
    public static boolean isProposalAwarded(final Award award) {
        if (ObjectUtils.isNull(award)) {
            return false;
        }
        Award result = null;
        if (ObjectUtils.isNotNull(award.getProposalNumber())) {
            result = SpringContext.getBean(BusinessObjectService.class).findBySinglePrimaryKey(Award.class,
                    award.getProposalNumber());
        }

        // Make sure it exists and is not the same object
        return ObjectUtils.isNotNull(result) && !StringUtils.equals(award.getObjectId(), result.getObjectId());
    }

}
